/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jetty.logging.JettyLogger;
import org.eclipse.jetty.logging.JettyLoggerFactory;
import org.eclipse.jetty.logging.JettyLoggingServiceProvider;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StacklessLogging
implements AutoCloseable {
    private static final JettyLoggerFactory loggerFactory;
    private final List<JettyLogger> squelched;

    public StacklessLogging(Class<?> ... classesToSquelch) {
        this((String[])Stream.of(classesToSquelch).map(Class::getName).toArray(String[]::new));
    }

    public StacklessLogging(Package ... packagesToSquelch) {
        this((String[])Stream.of(packagesToSquelch).map(Package::getName).toArray(String[]::new));
    }

    public StacklessLogging(String ... loggerNames) {
        this((Logger[])Stream.of(loggerNames).map(loggerFactory::getJettyLogger).toArray(Logger[]::new));
    }

    public StacklessLogging(Logger ... logs) {
        if (loggerFactory == null) {
            this.squelched = Collections.emptyList();
            return;
        }
        ArrayList<JettyLogger> stackless = new ArrayList<JettyLogger>();
        for (Logger log : logs) {
            JettyLogger jettyLogger;
            if (!(log instanceof JettyLogger) || (jettyLogger = (JettyLogger)log).isDebugEnabled()) continue;
            stackless.add(jettyLogger);
        }
        this.squelched = List.copyOf(stackless);
        JettyLogger.add(this);
    }

    @Override
    public void close() {
        JettyLogger.remove(this);
    }

    boolean isHiding(JettyLogger logger) {
        return this.squelched.contains(logger);
    }

    static {
        JettyLoggerFactory jettyLoggerFactory = null;
        ILoggerFactory activeLoggerFactory = LoggerFactory.getILoggerFactory();
        if (activeLoggerFactory instanceof JettyLoggerFactory) {
            jettyLoggerFactory = (JettyLoggerFactory)activeLoggerFactory;
        } else {
            JettyLoggingServiceProvider provider = new JettyLoggingServiceProvider();
            provider.initialize();
            jettyLoggerFactory = provider.getJettyLoggerFactory();
        }
        loggerFactory = jettyLoggerFactory;
    }
}

