/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.server;

import java.nio.file.Files;
import java.nio.file.Path;
import java.security.KeyStore;
import java.util.Set;
import org.eclipse.jetty.quic.quiche.PemExporter;
import org.eclipse.jetty.quic.quiche.PemPaths;
import org.eclipse.jetty.quic.server.ServerQuicConfiguration;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuicheServerQuicConfiguration
extends ServerQuicConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(QuicheServerQuicConfiguration.class);
    private Path pemWorkDirectory;

    public QuicheServerQuicConfiguration() {
        this(null);
    }

    public QuicheServerQuicConfiguration(Path pemWorkDirectory) {
        this.pemWorkDirectory = pemWorkDirectory;
    }

    public Path getPemWorkDirectory() {
        return this.pemWorkDirectory;
    }

    public void setPemWorkDirectory(Path pemWorkDirectory) {
        if (this.isStarted()) {
            throw new IllegalStateException("cannot change PEM working directory after start");
        }
        this.pemWorkDirectory = pemWorkDirectory;
    }

    public void configure(SslContextFactory.Server sslContextFactory) throws Exception {
        String keyManagerPassword;
        Path pemWorkDirectory = this.getPemWorkDirectory();
        Set aliases = sslContextFactory.getAliases();
        if (aliases.isEmpty()) {
            throw new IllegalStateException("Missing or invalid KeyStore: a SslContextFactory configured with a valid, non-empty KeyStore is required");
        }
        String alias = sslContextFactory.getCertAlias();
        if (alias == null) {
            alias = (String)aliases.stream().findFirst().orElseThrow();
        }
        char[] password = (keyManagerPassword = sslContextFactory.getKeyManagerPassword()) == null ? sslContextFactory.getKeyStorePassword().toCharArray() : keyManagerPassword.toCharArray();
        KeyStore keyStore = sslContextFactory.getKeyStore();
        Path[] keyPair = PemExporter.exportKeyPair((KeyStore)keyStore, (String)alias, (char[])password, (Path)pemWorkDirectory);
        Path privateKeyPemPath = keyPair[0];
        Path certificateChainPemPath = keyPair[1];
        Path trustedCertificatesPemPath = null;
        KeyStore trustStore = sslContextFactory.getTrustStore();
        if (trustStore != null) {
            trustedCertificatesPemPath = PemExporter.exportTrustStore((KeyStore)trustStore, (Path)pemWorkDirectory);
        }
        this.getImplementationConfiguration().put(sslContextFactory, new PemPaths(privateKeyPemPath, certificateChainPemPath, trustedCertificatesPemPath));
    }

    public void deconfigure(SslContextFactory.Server sslContextFactory) {
        PemPaths pemPaths = (PemPaths)this.getImplementationConfiguration().remove(sslContextFactory);
        if (pemPaths != null) {
            this.deleteFile(pemPaths.privateKeyPemPath());
            this.deleteFile(pemPaths.certificateChainPemPath());
            this.deleteFile(pemPaths.trustedCertificatesPemPath());
        }
    }

    private void deleteFile(Path path) {
        block3: {
            try {
                if (path != null) {
                    Files.delete(path);
                }
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("could not delete {}", (Object)path, (Object)x);
            }
        }
    }
}

