/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.annotations;

import jakarta.annotation.security.RunAs;
import jakarta.servlet.Servlet;
import java.lang.annotation.Annotation;
import org.eclipse.jetty.ee9.annotations.AnnotationIntrospector;
import org.eclipse.jetty.ee9.servlet.ServletHolder;
import org.eclipse.jetty.ee9.webapp.Descriptor;
import org.eclipse.jetty.ee9.webapp.MetaData;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunAsAnnotationHandler
extends AnnotationIntrospector.AbstractIntrospectableAnnotationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RunAsAnnotationHandler.class);

    public RunAsAnnotationHandler(WebAppContext wac) {
        super(false, wac);
    }

    public void doHandle(Class clazz) {
        if (!Servlet.class.isAssignableFrom(clazz)) {
            return;
        }
        RunAs runAs = clazz.getAnnotation(RunAs.class);
        if (runAs != null) {
            String role = runAs.value();
            if (role != null) {
                for (ServletHolder holder : this._context.getServletHandler().getServlets(clazz)) {
                    MetaData metaData = this._context.getMetaData();
                    Descriptor d = metaData.getOriginDescriptor(holder.getName() + ".servlet.run-as");
                    if (d != null) continue;
                    metaData.setOrigin(holder.getName() + ".servlet.run-as", (Annotation)runAs, clazz);
                    holder.setRunAsRole(role);
                }
            } else {
                LOG.warn("Bad value for @RunAs annotation on class {}", (Object)clazz.getName());
            }
        }
    }

    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation) {
        LOG.warn("@RunAs annotation not applicable for fields: {}.{}", (Object)className, (Object)fieldName);
    }

    public void handleMethod(String className, String methodName, int access, String params, String signature, String[] exceptions, String annotation) {
        LOG.warn("@RunAs annotation ignored on method: {}.{} {}", new Object[]{className, methodName, signature});
    }
}

