/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.websocket.jakarta.server.config;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.server.ServerApplicationConfig;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpoint;
import java.util.Set;
import org.eclipse.jetty.ee11.servlet.FilterHolder;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.ee11.websocket.jakarta.server.JakartaWebSocketServerContainer;
import org.eclipse.jetty.ee11.websocket.servlet.WebSocketUpgradeFilter;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.server.WebSocketMappings;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HandlesTypes(value={ServerApplicationConfig.class, ServerEndpoint.class, Endpoint.class})
public class JakartaWebSocketServletContainerInitializer
implements ServletContainerInitializer {
    public static final String ATTR_JAKARTA_SERVER_CONTAINER = ServerContainer.class.getName();
    public static final String ENABLE_KEY = "org.eclipse.jetty.websocket.jakarta";
    public static final String HTTPCLIENT_ATTRIBUTE = "org.eclipse.jetty.websocket.jakarta.HttpClient";
    private static final Logger LOG = LoggerFactory.getLogger(JakartaWebSocketServletContainerInitializer.class);
    private final Configurator configurator;

    public JakartaWebSocketServletContainerInitializer() {
        this(null);
    }

    public JakartaWebSocketServletContainerInitializer(Configurator configurator) {
        this.configurator = configurator;
    }

    private static Boolean isEnabledViaContext(ServletContext context, String keyName) {
        String cp = context.getInitParameter(keyName);
        if (cp != null) {
            return TypeUtil.isTrue((Object)cp);
        }
        Object enable = context.getAttribute(keyName);
        if (enable != null) {
            return TypeUtil.isTrue((Object)enable);
        }
        return null;
    }

    public static void configure(ServletContextHandler context, Configurator configurator) {
        if (!context.isStopped()) {
            throw new IllegalStateException("configure should be called before starting");
        }
        context.addServletContainerInitializer((ServletContainerInitializer)new JakartaWebSocketServletContainerInitializer(configurator));
    }

    public static ServerContainer initialize(ServletContextHandler context) {
        JakartaWebSocketServerContainer serverContainer = JakartaWebSocketServerContainer.getContainer(context.getServletContext());
        if (serverContainer == null) {
            WebSocketComponents components = WebSocketServerComponents.ensureWebSocketComponents((Server)context.getServer(), (ContextHandler)context);
            FilterHolder filterHolder = WebSocketUpgradeFilter.ensureFilter((ServletContext)context.getServletContext());
            WebSocketMappings mapping = WebSocketMappings.ensureMappings((ContextHandler)context);
            serverContainer = JakartaWebSocketServerContainer.ensureContainer(context.getServletContext());
            if (LOG.isDebugEnabled()) {
                LOG.debug("configureContext {} {} {} {}", new Object[]{mapping, components, filterHolder, serverContainer});
            }
        }
        return serverContainer;
    }

    /*
     * Exception decompiling
     */
    public void onStartup(Set<Class<?>> c, ServletContext context) throws ServletException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void filterClasses(Set<Class<?>> c, Set<Class<? extends Endpoint>> discoveredExtendedEndpoints, Set<Class<?>> discoveredAnnotatedEndpoints, Set<Class<? extends ServerApplicationConfig>> serverAppConfigs) {
        for (Class<?> clazz : c) {
            ServerEndpoint endpoint;
            if (ServerApplicationConfig.class.isAssignableFrom(clazz)) {
                serverAppConfigs.add(clazz);
            }
            if (Endpoint.class.isAssignableFrom(clazz)) {
                discoveredExtendedEndpoints.add(clazz);
            }
            if ((endpoint = clazz.getAnnotation(ServerEndpoint.class)) == null) continue;
            discoveredAnnotatedEndpoints.add(clazz);
        }
    }

    public static interface Configurator {
        public void accept(ServletContext var1, ServerContainer var2) throws DeploymentException;
    }
}

