/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.memcached.session;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.memcached.session.MemcachedSessionDataMap;
import org.eclipse.jetty.session.SessionDataMap;
import org.eclipse.jetty.session.SessionDataMapFactory;

public class MemcachedSessionDataMapFactory
implements SessionDataMapFactory {
    protected int _expiry;
    protected boolean _heartbeats = true;
    protected int[] _weights;
    protected List<InetSocketAddress> _addresses;

    public void setAddresses(InetSocketAddress ... addresses) {
        if (addresses == null) {
            this._addresses = null;
        } else {
            this._addresses = new ArrayList<InetSocketAddress>();
            for (InetSocketAddress a : addresses) {
                this._addresses.add(a);
            }
        }
    }

    public void setWeights(int[] weights) {
        this._weights = weights;
    }

    public int getExpirySec() {
        return this._expiry;
    }

    public void setExpirySec(int expiry) {
        this._expiry = expiry;
    }

    public boolean isHeartbeats() {
        return this._heartbeats;
    }

    public void setHeartbeats(boolean heartbeats) {
        this._heartbeats = heartbeats;
    }

    public SessionDataMap getSessionDataMap() {
        MemcachedSessionDataMap m = new MemcachedSessionDataMap(this._addresses, this._weights);
        m.setExpirySec(this._expiry);
        m.setHeartbeats(this.isHeartbeats());
        return m;
    }
}

