/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.deploy.ContextHandlerFactory;
import org.eclipse.jetty.deploy.Deployer;
import org.eclipse.jetty.deploy.StandardContextHandlerFactory;
import org.eclipse.jetty.deploy.StandardDeployer;
import org.eclipse.jetty.server.Deployable;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.component.Environment;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.PathCollators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="Provider for dynamic deployment of contexts (and webapps) based on presence in directory")
public class DeploymentScanner
extends ContainerLifeCycle
implements Scanner.BulkListener {
    private static final Logger LOG = LoggerFactory.getLogger(DeploymentScanner.class);
    private static final String ATTRIBUTE_PREFIX = "jetty.deploy.attribute.";
    private final Server server;
    private final FilenameFilter filenameFilter;
    private final List<Path> monitoredDirs = new CopyOnWriteArrayList<Path>();
    private final ContextHandlerFactory contextHandlerFactory;
    private final Map<String, PathsApp> trackedApps = new HashMap<String, PathsApp>();
    private final Map<String, Attributes> environmentAttributesMap = new HashMap<String, Attributes>();
    private Deployer deployer;
    private Comparator<DeployAction> actionComparator = new DeployActionComparator();
    private Path environmentsDir;
    private int scanInterval = 10;
    private Scanner scanner;
    private boolean useRealPaths;
    private boolean deferInitialScan = false;
    private String defaultEnvironmentName;

    public DeploymentScanner(@Name(value="server") Server server) {
        this(server, null, null, null);
    }

    public DeploymentScanner(@Name(value="server") Server server, @Name(value="deployer") Deployer deployer) {
        this(server, deployer, null, null);
    }

    public DeploymentScanner(@Name(value="server") Server server, @Name(value="deployer") Deployer deployer, @Name(value="filenameFilter") FilenameFilter filter) {
        this(server, deployer, filter, null);
    }

    public DeploymentScanner(@Name(value="server") Server server, @Name(value="deployer") Deployer deployer, @Name(value="contextHandlerFactory") ContextHandlerFactory contextHandlerFactory) {
        this(server, deployer, null, contextHandlerFactory);
    }

    public DeploymentScanner(@Name(value="server") Server server, @Name(value="deployer") Deployer deployer, @Name(value="filenameFilter") FilenameFilter filter, @Name(value="contextHandlerFactory") ContextHandlerFactory contextHandlerFactory) {
        this.contextHandlerFactory = contextHandlerFactory == null ? new StandardContextHandlerFactory() : contextHandlerFactory;
        this.installBean(this.contextHandlerFactory);
        this.server = Objects.requireNonNull(server);
        this.deployer = deployer == null ? (Deployer)server.getBean(Deployer.class) : deployer;
        this.installBean(deployer);
        this.filenameFilter = Objects.requireNonNullElse(filter, new MonitoredPathFilter(this.monitoredDirs));
        this.installBean(new DumpableCollection("monitored", this.monitoredDirs));
    }

    public static String stripOldAttributePrefix(String key) {
        if (key.startsWith(ATTRIBUTE_PREFIX)) {
            return key.substring(ATTRIBUTE_PREFIX.length());
        }
        return key;
    }

    public void addMonitoredDirectory(Path dir) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding monitored directory: {}", (Object)dir);
        }
        if (this.isStarted()) {
            throw new IllegalStateException("Unable to add monitored directory while running");
        }
        this.monitoredDirs.add(Objects.requireNonNull(dir));
    }

    void addScannerListener(Scanner.Listener listener) {
        this.scanner.addListener(listener);
    }

    public EnvironmentConfig configureEnvironment(String name) {
        return new EnvironmentConfig(Environment.get((String)name));
    }

    public Comparator<DeployAction> getActionComparator() {
        return this.actionComparator;
    }

    public void setActionComparator(Comparator<DeployAction> actionComparator) {
        this.actionComparator = actionComparator;
    }

    public String getDefaultEnvironmentName() {
        if (this.defaultEnvironmentName == null) {
            return Environment.getAll().stream().map(Environment::getName).max(Deployable.ENVIRONMENT_COMPARATOR).orElse(null);
        }
        return this.defaultEnvironmentName;
    }

    public void setDefaultEnvironmentName(String name) {
        this.defaultEnvironmentName = name;
    }

    public Path getEnvironmentsDirectory() {
        return this.environmentsDir;
    }

    public void setEnvironmentsDirectory(Path dir) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting Environments directory: {}", (Object)dir);
        }
        if (this.isStarted()) {
            throw new IllegalStateException("Unable to add environments directory while running");
        }
        this.environmentsDir = dir;
    }

    public List<Path> getMonitoredDirectories() {
        return this.monitoredDirs;
    }

    public void setMonitoredDirectories(Collection<Path> directories) {
        if (this.isStarted()) {
            throw new IllegalStateException("Unable to add monitored directories while running");
        }
        this.monitoredDirs.clear();
        for (Path dir : directories) {
            this.addMonitoredDirectory(dir);
        }
    }

    @ManagedAttribute(value="scanning interval to detect changes which need reloaded")
    public int getScanInterval() {
        return this.scanInterval;
    }

    public void setScanInterval(int scanInterval) {
        this.scanInterval = scanInterval;
    }

    public boolean isDeferInitialScan() {
        return this.deferInitialScan;
    }

    public void setDeferInitialScan(boolean defer) {
        this.deferInitialScan = defer;
    }

    public boolean isUseRealPaths() {
        return this.useRealPaths;
    }

    public void setUseRealPaths(boolean useRealPaths) {
        this.useRealPaths = useRealPaths;
    }

    public void pathsChanged(Map<Path, Scanner.Notification> changeSet) {
        Objects.requireNonNull(changeSet);
        if (LOG.isDebugEnabled()) {
            LOG.debug("pathsChanged: {}", (Object)changeSet.entrySet().stream().map(e -> String.format("%s|%s", e.getKey(), e.getValue())).collect(Collectors.joining(", ", "[", "]")));
        }
        HashSet<String> changedBaseNames = new HashSet<String>();
        HashSet<String> changedEnvironments = new HashSet<String>();
        for (Map.Entry<Path, Scanner.Notification> entry : changeSet.entrySet()) {
            Path path = entry.getKey();
            PathsApp.State state = switch (entry.getValue()) {
                default -> throw new IncompatibleClassChangeError();
                case Scanner.Notification.ADDED -> PathsApp.State.ADDED;
                case Scanner.Notification.CHANGED -> PathsApp.State.CHANGED;
                case Scanner.Notification.REMOVED -> PathsApp.State.REMOVED;
            };
            String basename = FileID.getBasename((Path)path).toLowerCase();
            if (Files.isDirectory(path, new LinkOption[0]) && FileID.isExtension((Path)path, (String[])new String[]{"d"})) {
                basename = basename.substring(0, basename.length() - 2);
            }
            if (this.isMonitoredPath(path)) {
                changedBaseNames.add(basename);
                PathsApp app = this.trackedApps.computeIfAbsent(basename, PathsApp::new);
                app.putPath(path, state);
                continue;
            }
            if (!this.isEnvironmentConfigPath(path)) continue;
            String envname = null;
            for (Environment environment : Environment.getAll()) {
                String name = environment.getName();
                if (!basename.startsWith(name)) continue;
                envname = name;
            }
            if (StringUtil.isBlank(envname)) {
                LOG.warn("Unable to determine Environment for file: {}", (Object)path);
                continue;
            }
            changedEnvironments.add(envname);
        }
        List<PathsApp> changedApps = changedBaseNames.stream().map(this::findApp).collect(Collectors.toList());
        if (!changedEnvironments.isEmpty()) {
            for (String changedEnvName : changedEnvironments) {
                for (PathsApp app : this.trackedApps.values()) {
                    if (changedBaseNames.contains(app.getName()) || !changedEnvName.equalsIgnoreCase(app.getEnvironmentName())) continue;
                    if (app.getState() == PathsApp.State.UNCHANGED) {
                        app.setState(PathsApp.State.CHANGED);
                    }
                    changedApps.add(app);
                    changedBaseNames.add(app.getName());
                }
                this.environmentAttributesMap.remove(changedEnvName);
                try {
                    Attributes envAttributes = this.loadEnvironmentAttributes(changedEnvName);
                    this.environmentAttributesMap.put(changedEnvName, envAttributes);
                }
                catch (IOException e2) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Unable to load environment properties for environment [{}]", (Object)changedEnvName, (Object)e2);
                }
            }
        } else {
            Environment.getAll().forEach(env -> this.environmentAttributesMap.put(env.getName(), (Attributes)env));
        }
        List<DeployAction> list = this.buildActionList(changedApps);
        this.performActions(list);
    }

    public void resetAppState(String name) {
        PathsApp app = this.findApp(name);
        if (app == null) {
            return;
        }
        app.resetStates();
    }

    @ManagedOperation(value="Scan the monitored directories", impact="ACTION")
    public void scan() {
        LOG.info("Performing scan of monitored directories: {}", (Object)this.monitoredDirs.stream().map(Path::toUri).map(URI::toASCIIString).collect(Collectors.joining(", ", "[", "]")));
        this.scanner.nudge();
    }

    public String toString() {
        return String.format("%s@%x[dirs=%s]", ((Object)((Object)this)).getClass(), ((Object)((Object)this)).hashCode(), this.monitoredDirs);
    }

    protected List<DeployAction> buildActionList(List<PathsApp> changedApps) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("buildActionList: {}", changedApps);
        }
        ArrayList<DeployAction> actions = new ArrayList<DeployAction>();
        for (PathsApp app : changedApps) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("changed app: {}", (Object)app);
            }
            switch (app.getState().ordinal()) {
                case 1: {
                    this.startTracking(app);
                    actions.add(new DeployAction(DeployAction.Type.DEPLOY, app.getName()));
                    break;
                }
                case 2: {
                    actions.add(new DeployAction(DeployAction.Type.REDEPLOY, app.getName()));
                    break;
                }
                case 3: {
                    actions.add(new DeployAction(DeployAction.Type.UNDEPLOY, app.getName()));
                }
            }
        }
        return this.sortActions(actions);
    }

    protected void doStart() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} doStart()", (Object)this);
        }
        if (this.deployer == null) {
            Collection chcs;
            this.deployer = (Deployer)this.server.getBean(Deployer.class);
            if (this.deployer == null && (chcs = this.server.getContainedBeans(ContextHandlerCollection.class)).size() == 1) {
                this.deployer = new StandardDeployer((ContextHandlerCollection)chcs.iterator().next());
                this.addBean(this.deployer, true);
                LifeCycle.start((Object)this.deployer);
            }
            if (this.deployer == null) {
                throw new IllegalStateException("No deployer available");
            }
        }
        if (this.monitoredDirs.isEmpty()) {
            throw new IllegalStateException("No monitored dir specified");
        }
        LOG.info("Deployment monitor in {} at intervals {}s", this.monitoredDirs, (Object)this.getScanInterval());
        Predicate<Path> validDir = path -> {
            if (!Files.exists(path, new LinkOption[0])) {
                LOG.warn("Does not exist: {}", path);
                return false;
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                LOG.warn("Is not a directory: {}", path);
                return false;
            }
            return true;
        };
        final ArrayList<Path> dirs = new ArrayList<Path>();
        for (Path dir : this.monitoredDirs) {
            if (!validDir.test(dir)) continue;
            dirs.add(dir);
        }
        if (this.environmentsDir != null && validDir.test(this.environmentsDir)) {
            dirs.add(this.environmentsDir);
        }
        this.scanner = new Scanner(null, this.useRealPaths);
        this.scanner.setScanDirs(dirs);
        this.scanner.setScanInterval(this.scanInterval);
        this.scanner.setFilenameFilter(this.filenameFilter);
        this.scanner.setReportDirs(true);
        this.scanner.setScanDepth(1);
        this.scanner.addListener((Scanner.Listener)this);
        this.scanner.setReportExistingFilesOnStartup(true);
        this.scanner.setAutoStartScanning(!this.deferInitialScan);
        this.addBean(this.scanner);
        if (this.isDeferInitialScan()) {
            if (this.server == null) {
                throw new IllegalStateException("Cannot defer initial scan with a null Server");
            }
            this.server.addEventListener((EventListener)new LifeCycle.Listener(){
                final /* synthetic */ DeploymentScanner this$0;
                {
                    this.this$0 = this$0;
                }

                public void lifeCycleStarted(LifeCycle event) {
                    if (event instanceof Server) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Triggering Deferred Scan of {}", (Object)dirs);
                        }
                        this.this$0.scanner.startScanning();
                    }
                }
            });
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.scanner != null) {
            this.removeBean(this.scanner);
            this.scanner.removeListener((Scanner.Listener)this);
            this.scanner = null;
        }
    }

    protected boolean exists(String path) {
        return this.scanner.exists(path);
    }

    protected PathsApp findApp(String name) {
        return this.trackedApps.get(name);
    }

    protected boolean isEnvironmentConfigPath(Path path) {
        if (this.environmentsDir == null) {
            return false;
        }
        return this.isSameDir(this.environmentsDir, path.getParent());
    }

    protected boolean isMonitoredPath(Path path) {
        Path parentDir = path.getParent();
        for (Path monitoredDir : this.monitoredDirs) {
            if (!this.isSameDir(monitoredDir, parentDir)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSameDir(Path dirA, Path dirB) {
        try {
            return Files.isSameFile(dirA, dirB);
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring: Unable to use Files.isSameFile({}, {})", new Object[]{dirA, dirB, e});
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void performActions(List<DeployAction> actions) {
        removedApps = new HashSet<PathsApp>();
lbl2:
        // 7 sources

        block10: for (DeployAction step : actions) {
            app = this.findApp(step.name());
            if (app == null) {
                throw new IllegalStateException("Unable to find app [" + step.name() + "]");
            }
            try {
                switch (step.type().ordinal()) {
                    case 0: {
                        removedApps.add(app);
                        this.deployer.undeploy(app.getContextHandler());
                        ** break;
                    }
                    case 2: {
                        removedApps.remove(app);
                        app.loadProperties();
                        appEnvironment = app.getEnvironmentName();
                        if (StringUtil.isBlank((String)appEnvironment)) {
                            appEnvironment = this.getDefaultEnvironmentName();
                        }
                        app.setEnvironment(Environment.get((String)appEnvironment));
                        envAttributes = this.environmentAttributesMap.get(appEnvironment);
                        deployAttributes = envAttributes == null ? app.getAttributes() : new Attributes.Layer(envAttributes, app.getAttributes());
                        envXmlPaths = this.findEnvironmentXmlPaths(deployAttributes);
                        envXmlPaths.sort(PathCollators.byName((boolean)true));
                        StandardContextHandlerFactory.setEnvironmentXmlPaths(deployAttributes, envXmlPaths);
                        mainPath = app.getMainPath();
                        if (mainPath == null) {
                            throw new IllegalStateException("Unable to create ContextHandler for app with no main path defined: " + String.valueOf(app));
                        }
                        contextHandler = this.contextHandlerFactory.newContextHandler(this.server, app.getEnvironment(), mainPath, app.getPaths().keySet(), deployAttributes);
                        app.setContextHandler(contextHandler);
                        this.startTracking(app);
                        this.deployer.deploy(app.getContextHandler());
                        ** break;
                    }
                    case 1: {
                        oldContextHandler = app.getContextHandler();
                        app.loadProperties();
                        appEnvironment = app.getEnvironmentName();
                        if (StringUtil.isBlank((String)appEnvironment)) {
                            appEnvironment = this.getDefaultEnvironmentName();
                        }
                        app.setEnvironment(Environment.get((String)appEnvironment));
                        envAttributes = this.environmentAttributesMap.get(appEnvironment);
                        deployAttributes = envAttributes == null ? app.getAttributes() : new Attributes.Layer(envAttributes, app.getAttributes());
                        envXmlPaths = this.findEnvironmentXmlPaths(deployAttributes);
                        envXmlPaths.sort(PathCollators.byName((boolean)true));
                        StandardContextHandlerFactory.setEnvironmentXmlPaths(deployAttributes, envXmlPaths);
                        mainPath = app.getMainPath();
                        if (mainPath == null) {
                            throw new IllegalStateException("Unable to create ContextHandler for app with no main path defined: " + String.valueOf(app));
                        }
                        contextHandler = this.contextHandlerFactory.newContextHandler(this.server, app.getEnvironment(), mainPath, app.getPaths().keySet(), deployAttributes);
                        app.setContextHandler(contextHandler);
                        this.startTracking(app);
                        this.deployer.redeploy(oldContextHandler, app.getContextHandler());
                        continue block10;
                    }
                    ** default:
lbl55:
                    // 1 sources

                    continue block10;
                }
            }
            catch (Throwable t) {
                DeploymentScanner.LOG.warn("Failed to to perform action {} on {}", new Object[]{step.type(), app, t});
                ExceptionUtil.ifExceptionThrowUnchecked((Throwable)t);
            }
            finally {
                app.resetStates();
            }
        }
        for (PathsApp removed : removedApps) {
            this.stopTracking(removed);
        }
    }

    protected List<DeployAction> sortActions(List<DeployAction> actions) {
        Comparator<DeployAction> deployActionComparator = this.getActionComparator();
        if (deployActionComparator != null) {
            actions.sort(deployActionComparator);
        }
        return actions;
    }

    private List<Path> findEnvironmentXmlPaths(Attributes deployAttributes) {
        List<Path> rawEnvXmlPaths = deployAttributes.getAttributeNameSet().stream().filter(k -> k.startsWith("jetty.deploy.environmentXml")).map(k -> Path.of((String)deployAttributes.getAttribute(k), new String[0])).toList();
        ArrayList<Path> ret = new ArrayList<Path>();
        for (Path rawPath : rawEnvXmlPaths) {
            if (Files.exists(rawPath, new LinkOption[0])) {
                if (Files.isRegularFile(rawPath, new LinkOption[0])) {
                    if (rawPath.isAbsolute()) {
                        ret.add(rawPath);
                        continue;
                    }
                    ret.add(rawPath.toAbsolutePath());
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Ignoring non-file reference to environment xml: {}", (Object)rawPath);
                continue;
            }
            if (rawPath.isAbsolute()) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resolving environment xml path relative reference: {}", (Object)rawPath);
            }
            boolean found = false;
            for (Path monitoredDir : this.getMonitoredDirectories()) {
                Path resolved = monitoredDir.resolve(rawPath);
                if (Files.isRegularFile(resolved, new LinkOption[0])) {
                    found = true;
                    ret.add(resolved);
                    continue;
                }
                resolved = monitoredDir.getParent().resolve(rawPath);
                if (!Files.isRegularFile(resolved, new LinkOption[0])) continue;
                found = true;
                ret.add(resolved);
            }
            if (found || !LOG.isDebugEnabled()) continue;
            LOG.debug("Ignoring relative environment xml path that doesn't exist: {}", (Object)rawPath);
        }
        return ret;
    }

    private Attributes loadEnvironmentAttributes(String env) throws IOException {
        List<Path> envPropertyFiles;
        Environment envAttributes = Environment.get((String)env);
        if (envAttributes == null) {
            LOG.warn("Not an environment: {}", (Object)env);
            return Attributes.NULL;
        }
        Path dir = this.getEnvironmentsDirectory();
        if (dir == null) {
            return envAttributes;
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            LOG.warn("Not an environments directory: {}", (Object)dir);
            return envAttributes;
        }
        try (Stream<Path> paths = Files.list(dir);){
            envPropertyFiles = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> FileID.isExtension((Path)p, (String[])new String[]{"properties"})).filter(p -> {
                String name = p.getFileName().toString();
                return name.startsWith(env);
            }).sorted(PathCollators.byName((boolean)true)).toList();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Environment property files {}", envPropertyFiles);
        }
        Environment attributesLayer = envAttributes;
        for (Path file : envPropertyFiles) {
            InputStream stream = Files.newInputStream(file, new OpenOption[0]);
            try {
                Properties tmp = new Properties();
                tmp.load(stream);
                Attributes.Layer layer = new Attributes.Layer((Attributes)attributesLayer);
                tmp.stringPropertyNames().forEach(name -> {
                    String value = tmp.getProperty((String)name);
                    String key = DeploymentScanner.stripOldAttributePrefix(name);
                    layer.setAttribute(key, (Object)value);
                });
                attributesLayer = layer;
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return attributesLayer;
    }

    private void startTracking(PathsApp app) {
        this.trackedApps.put(app.getName(), app);
    }

    private void stopTracking(PathsApp app) {
        this.trackedApps.remove(app.getName());
    }

    public static class DeployActionComparator
    implements Comparator<DeployAction> {
        private final Comparator<DeployAction> typeComparator = Comparator.comparing(DeployAction::type);
        private final Comparator<DeployAction> basenameComparator = Comparator.comparing(DeployAction::name);

        @Override
        public int compare(DeployAction o1, DeployAction o2) {
            int diff = this.typeComparator.compare(o1, o2);
            if (diff != 0) {
                return diff;
            }
            return switch (o1.type().ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> this.basenameComparator.compare(o2, o1);
                case 1, 2 -> this.basenameComparator.compare(o1, o2);
            };
        }
    }

    public static class MonitoredPathFilter
    implements FilenameFilter {
        private final List<Path> monitoredDirs;

        public MonitoredPathFilter(List<Path> monitoredDirs) {
            this.monitoredDirs = monitoredDirs;
        }

        @Override
        public boolean accept(File dir, String name) {
            if (dir == null || !dir.canRead()) {
                return false;
            }
            Path path = dir.toPath().resolve(name);
            try {
                if (name.startsWith(".")) {
                    return false;
                }
                if (Files.isHidden(path)) {
                    return false;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (Files.isRegularFile(path, new LinkOption[0]) && FileID.isExtension((String)name, (String[])new String[]{"jar", "war", "xml", "properties"})) {
                return true;
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return false;
            }
            if (this.monitoredDirs.contains(path)) {
                return false;
            }
            String lowerName = name.toLowerCase(Locale.ENGLISH);
            if (lowerName.endsWith(".d")) {
                return true;
            }
            return !"cvs".equals(lowerName) && !"cvsroot".equals(lowerName);
        }
    }

    public static class EnvironmentConfig {
        private final Environment _environment;

        private EnvironmentConfig(Environment environment) {
            this._environment = environment;
        }

        public void loadProperties(Path path) throws IOException {
            Properties props = new Properties();
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                props.load(inputStream);
                props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this._environment.setAttribute((String)key, value)));
            }
        }

        public void loadPropertiesFromPathName(String pathName) throws IOException {
            this.loadProperties(Path.of(pathName, new String[0]));
        }

        public void setConfigurationClasses(String configurations) {
            this.setConfigurationClasses(StringUtil.isBlank((String)configurations) ? null : configurations.split(","));
        }

        public void setConfigurationClasses(String[] configurations) {
            if (configurations == null) {
                this._environment.removeAttribute("jetty.deploy.configurationClasses");
            } else {
                this._environment.setAttribute("jetty.deploy.configurationClasses", (Object)configurations);
            }
        }

        public void setContainerScanJarPattern(String pattern) {
            this._environment.setAttribute("jetty.deploy.containerScanJarPattern", (Object)pattern);
        }

        public void setContextHandlerClass(String classname) {
            this._environment.setAttribute("jetty.deploy.contextHandlerClass", (Object)classname);
        }

        public void setDefaultContextHandlerClass(String classname) {
            this._environment.setAttribute("jetty.deploy.default.contextHandlerClass", (Object)classname);
        }

        public void setDefaultsDescriptor(String defaultsDescriptor) {
            this._environment.setAttribute("jetty.deploy.defaultsDescriptor", (Object)defaultsDescriptor);
        }

        public void setExtractWars(boolean extractWars) {
            this._environment.setAttribute("jetty.deploy.extractWars", (Object)extractWars);
        }

        public void setParentLoaderPriority(boolean parentLoaderPriority) {
            this._environment.setAttribute("jetty.deploy.parentLoaderPriority", (Object)parentLoaderPriority);
        }

        public void setServletContainerInitializerExclusionPattern(String pattern) {
            this._environment.setAttribute("jetty.deploy.servletContainerInitializerExclusionPattern", (Object)pattern);
        }

        public void setServletContainerInitializerOrder(String order) {
            this._environment.setAttribute("jetty.deploy.servletContainerInitializerOrder", (Object)order);
        }

        public void setWebInfScanJarPattern(String pattern) {
            this._environment.setAttribute("jetty.deploy.webInfScanJarPattern", (Object)pattern);
        }
    }

    protected static class PathsApp {
        private static final Logger LOG = LoggerFactory.getLogger(PathsApp.class);
        private final String name;
        private final Map<Path, State> paths = new HashMap<Path, State>();
        private final Attributes attributes = new Attributes.Mapped();
        private State state;
        private ContextHandler contextHandler;

        public PathsApp(String name) {
            this.name = name;
            this.state = this.calcState();
        }

        private static String asStringList(Collection<Path> paths) {
            return paths.stream().sorted(PathCollators.byName((boolean)true)).map(Path::toString).collect(Collectors.joining(", ", "[", "]"));
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathsApp that = (PathsApp)o;
            return Objects.equals(this.name, that.name);
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        public ContextHandler getContextHandler() {
            return this.contextHandler;
        }

        public void setContextHandler(ContextHandler contextHandler) {
            this.contextHandler = contextHandler;
        }

        public Environment getEnvironment() {
            return (Environment)this.getAttributes().getAttribute("environment");
        }

        public void setEnvironment(Environment env) {
            this.getAttributes().setAttribute("environment", (Object)env);
        }

        public String getEnvironmentName() {
            Environment env = this.getEnvironment();
            if (env == null) {
                return "";
            }
            return env.getName();
        }

        public Path getMainPath() {
            List<Path> livePaths = this.paths.entrySet().stream().filter(e -> e.getValue() != State.REMOVED).map(Map.Entry::getKey).sorted(PathCollators.byName((boolean)true)).toList();
            if (livePaths.isEmpty()) {
                return null;
            }
            List<Path> xmls = livePaths.stream().filter(FileID::isXml).toList();
            if (xmls.size() == 1) {
                return xmls.get(0);
            }
            if (xmls.size() > 1) {
                throw new IllegalStateException("More than 1 XML for deployable " + PathsApp.asStringList(xmls));
            }
            List<Path> wars = livePaths.stream().filter(FileID::isWebArchive).toList();
            if (wars.size() == 1) {
                return wars.get(0);
            }
            if (wars.size() > 1) {
                throw new IllegalStateException("More than 1 WAR for deployable " + PathsApp.asStringList(wars));
            }
            List<Path> dirs = livePaths.stream().filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).toList();
            if (dirs.size() == 1) {
                return dirs.get(0);
            }
            if (dirs.size() > 1) {
                throw new IllegalStateException("More than 1 Directory for deployable " + PathsApp.asStringList(dirs));
            }
            LOG.warn("Unable to determine main deployable for {}", (Object)this);
            return null;
        }

        public String getName() {
            return this.name;
        }

        public Map<Path, State> getPaths() {
            return this.paths;
        }

        public State getState() {
            return this.state;
        }

        public void setState(State state) {
            this.state = state;
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }

        public void loadProperties() {
            String propFilename = String.format("%s.properties", this.getName());
            List<Path> propFiles = this.paths.keySet().stream().filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().equalsIgnoreCase(propFilename)).sorted(PathCollators.byName((boolean)true)).toList();
            if (propFiles.isEmpty()) {
                return;
            }
            if (propFiles.size() > 1) {
                LOG.warn("Multiple matching files with name [{}]: {}", (Object)propFilename, (Object)PathsApp.asStringList(propFiles));
            }
            for (Path propFile : propFiles) {
                try {
                    InputStream inputStream = Files.newInputStream(propFile, new OpenOption[0]);
                    try {
                        Properties props = new Properties();
                        props.load(inputStream);
                        props.stringPropertyNames().forEach(name -> {
                            String value = props.getProperty((String)name);
                            String key = DeploymentScanner.stripOldAttributePrefix(name);
                            this.getAttributes().setAttribute(key, (Object)value);
                        });
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    LOG.warn("Unable to read properties file: {}", (Object)propFile, (Object)e);
                }
            }
            String environmentName = (String)this.getAttributes().getAttribute("environment");
            if (StringUtil.isNotBlank((String)environmentName)) {
                this.setEnvironment(Environment.get((String)environmentName));
            }
        }

        public void putPath(Path path, State state) {
            this.paths.put(path, state);
            this.setState(this.calcState());
        }

        public void resetStates() {
            List<Path> removedPaths = this.paths.entrySet().stream().filter(e -> e.getValue() == State.REMOVED).map(Map.Entry::getKey).toList();
            for (Path removedPath : removedPaths) {
                this.paths.remove(removedPath);
            }
            this.paths.replaceAll((p, v) -> State.UNCHANGED);
            this.state = this.calcState();
        }

        public String toString() {
            StringBuilder str = new StringBuilder("%s@%x".formatted(this.getClass().getSimpleName(), this.hashCode()));
            str.append("[").append(this.name);
            str.append("|").append((Object)this.getState());
            str.append(", env=").append(this.getEnvironmentName());
            str.append(", mainPath=").append(this.getMainPath());
            str.append(", paths=");
            str.append(this.paths.entrySet().stream().map(e -> String.format("%s|%s", e.getKey(), e.getValue())).collect(Collectors.joining(", ", "[", "]")));
            str.append(", contextHandler=");
            if (this.contextHandler == null) {
                str.append("<unset>");
            } else {
                str.append(this.contextHandler);
            }
            str.append("]");
            return str.toString();
        }

        private State calcState() {
            if (this.paths.isEmpty()) {
                return State.REMOVED;
            }
            State ret = null;
            for (State pathState : this.paths.values()) {
                switch (pathState.ordinal()) {
                    case 0: {
                        if (ret == null) {
                            ret = State.UNCHANGED;
                            break;
                        }
                        if (ret == State.UNCHANGED) break;
                        ret = State.CHANGED;
                        break;
                    }
                    case 1: {
                        if (ret == null) {
                            ret = State.ADDED;
                            break;
                        }
                        if (ret != State.UNCHANGED && ret != State.REMOVED) break;
                        ret = State.ADDED;
                        break;
                    }
                    case 2: {
                        ret = State.CHANGED;
                        break;
                    }
                    case 3: {
                        if (ret == null) {
                            ret = State.REMOVED;
                            break;
                        }
                        if (ret == State.REMOVED) break;
                        ret = State.CHANGED;
                    }
                }
            }
            return ret != null ? ret : State.UNCHANGED;
        }

        public static enum State {
            UNCHANGED,
            ADDED,
            CHANGED,
            REMOVED;

        }
    }

    public record DeployAction(Type type, String name) {

        public static enum Type {
            UNDEPLOY,
            REDEPLOY,
            DEPLOY;

        }
    }
}

