/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.Util;
import org.eclipse.jetty.plus.annotation.Injection;
import org.eclipse.jetty.plus.annotation.InjectionCollection;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAnnotationHandler
implements AnnotationParser.AnnotationHandler {
    protected WebAppContext _wac;
    protected InjectionCollection _injections;

    public ResourceAnnotationHandler(WebAppContext wac) {
        this._wac = wac;
        this._injections = (InjectionCollection)this._wac.getAttribute("org.eclipse.jetty.injectionCollection");
    }

    @Override
    public void handleClass(String className, int version, int access, String signature, String superName, String[] interfaces, String annotation, List<AnnotationParser.Value> values) {
        String name = null;
        String mappedName = null;
        String resourceType = null;
        if (values != null) {
            for (AnnotationParser.Value v : values) {
                if ("name".equals(v.getName())) {
                    name = (String)v.getValue();
                    continue;
                }
                if ("mappedName".equals(v.getName())) {
                    mappedName = (String)v.getValue();
                    continue;
                }
                if (!"type".equals(v.getName())) continue;
                resourceType = (String)v.getValue();
            }
            if (name == null || name.trim().equals("")) {
                throw new IllegalStateException("Class level Resource annotations must contain a name (Common Annotations Spec Section 2.3)");
            }
            try {
                if (!NamingEntryUtil.bindToENC((Object)this._wac, (String)name, mappedName) && !NamingEntryUtil.bindToENC((Object)this._wac.getServer(), (String)name, (String)mappedName)) {
                    throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                }
            }
            catch (NamingException e) {
                Log.warn((Throwable)e);
            }
        }
    }

    @Override
    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        block19: {
            try {
                Injection webXmlInjection;
                if ((access & 8) > 0) {
                    Log.warn((String)("Skipping Resource annotation on " + className + "." + fieldName + ": cannot be static"));
                    return;
                }
                if ((access & 0x10) > 0) {
                    Log.warn((String)("Skipping Resource annotation on " + className + "." + fieldName + ": cannot be final"));
                    return;
                }
                String name = className + "/" + fieldName;
                String mappedName = null;
                Type resourceType = null;
                if (values != null) {
                    for (AnnotationParser.Value val : values) {
                        if (val.getName().equals("name") && !"".equals((String)val.getValue())) {
                            name = (String)val.getValue();
                            continue;
                        }
                        if (val.getName().equals("mappedName") && !"".equals((String)val.getValue())) {
                            mappedName = (String)val.getValue();
                            continue;
                        }
                        if (!val.getName().equals("type")) continue;
                        resourceType = (Type)val.getValue();
                    }
                }
                if ((webXmlInjection = this._injections.getInjection(name, className, fieldName)) != null) break block19;
                try {
                    boolean bound = NamingEntryUtil.bindToENC((Object)this._wac, (String)name, mappedName);
                    if (!bound) {
                        bound = NamingEntryUtil.bindToENC((Object)this._wac.getServer(), (String)name, mappedName);
                    }
                    if (!bound) {
                        bound = NamingEntryUtil.bindToENC(null, (String)name, mappedName);
                    }
                    if (!bound) {
                        try {
                            InitialContext ic = new InitialContext();
                            String nameInEnvironment = mappedName != null ? mappedName : name;
                            ic.lookup("java:comp/env/" + nameInEnvironment);
                            bound = true;
                        }
                        catch (NameNotFoundException e) {
                            bound = false;
                        }
                    }
                    if (bound) {
                        Log.debug((String)("Bound " + (mappedName == null ? name : mappedName) + " as " + name));
                        Injection injection = new Injection();
                        injection.setTarget(className, fieldName, Util.asCanonicalName(resourceType));
                        injection.setJndiName(name);
                        injection.setMappingName(mappedName);
                        this._injections.add(injection);
                    } else if (!Util.isEnvEntryType(fieldType)) {
                        System.err.println(fieldType);
                        throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                    }
                }
                catch (NamingException e) {
                    if (!Util.isEnvEntryType(fieldType)) {
                        throw new IllegalStateException(e);
                    }
                }
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
            }
        }
    }

    @Override
    public void handleMethod(String className, String methodName, int access, String desc, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        block21: {
            try {
                Injection webXmlInjection;
                if ((access & 8) > 0) {
                    Log.warn((String)("Skipping Resource annotation on " + className + "." + methodName + ": cannot be static"));
                    return;
                }
                if (!methodName.startsWith("set")) {
                    Log.warn((String)("Skipping Resource annotation on " + className + "." + methodName + ": invalid java bean, does not start with 'set'"));
                    return;
                }
                Type[] args = Type.getArgumentTypes((String)desc);
                if (args == null || args.length != 1) {
                    Log.warn((String)("Skipping Resource annotation on " + className + "." + methodName + ": invalid java bean, not single argument to method"));
                    return;
                }
                Type retVal = Type.getReturnType((String)desc);
                if (!Type.VOID_TYPE.equals((Object)retVal)) {
                    Log.warn((String)("Skipping Resource annotation on " + className + "." + methodName + ": invalid java bean, not void"));
                    return;
                }
                String name = methodName.substring(3);
                name = name.substring(0, 1).toLowerCase() + name.substring(1);
                name = className + "/" + name;
                String mappedName = null;
                Type resourceType = null;
                if (values != null) {
                    for (AnnotationParser.Value v : values) {
                        if ("name".equals(v.getName())) {
                            name = (String)v.getValue();
                            continue;
                        }
                        if ("mappedName".equals(v.getName()) && !"".equals((String)v.getValue())) {
                            mappedName = (String)v.getValue();
                            continue;
                        }
                        if (!"type".equals(v.getName())) continue;
                        resourceType = (Type)v.getValue();
                    }
                }
                if ((webXmlInjection = this._injections.getInjection(name, className, methodName, Util.asCanonicalName(args[0]))) != null) break block21;
                try {
                    boolean bound = NamingEntryUtil.bindToENC((Object)this._wac, (String)name, mappedName);
                    if (!bound) {
                        bound = NamingEntryUtil.bindToENC((Object)this._wac.getServer(), (String)name, mappedName);
                    }
                    if (!bound) {
                        bound = NamingEntryUtil.bindToENC(null, (String)name, mappedName);
                    }
                    if (!bound) {
                        try {
                            InitialContext ic = new InitialContext();
                            String nameInEnvironment = mappedName != null ? mappedName : name;
                            ic.lookup("java:comp/env/" + nameInEnvironment);
                            bound = true;
                        }
                        catch (NameNotFoundException e) {
                            bound = false;
                        }
                    }
                    if (bound) {
                        Log.debug((String)("Bound " + (mappedName == null ? name : mappedName) + " as " + name));
                        Injection injection = new Injection();
                        injection.setTarget(className, methodName, Util.asCanonicalName(args[0]), Util.asCanonicalName(resourceType));
                        injection.setJndiName(name);
                        injection.setMappingName(mappedName);
                        this._injections.add(injection);
                    } else if (!Util.isEnvEntryType(args[0].getDescriptor())) {
                        throw new IllegalStateException("No resource at " + (mappedName == null ? name : mappedName));
                    }
                }
                catch (NamingException e) {
                    if (!Util.isEnvEntryType(args[0].getDescriptor())) {
                        throw new IllegalStateException(e);
                    }
                }
            }
            catch (Exception e) {
                Log.warn((Throwable)e);
            }
        }
    }
}

