/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.java.client;

import java.io.UncheckedIOException;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import org.eclipse.jetty.alpn.ALPN;
import org.eclipse.jetty.io.ssl.ALPNProcessor;

public class JDK9ClientALPNProcessor
implements ALPNProcessor.Client {
    public void configure(SSLEngine sslEngine, List<String> protocols) {
        SSLParameters sslParameters = sslEngine.getSSLParameters();
        sslParameters.setApplicationProtocols(protocols.toArray(new String[0]));
        sslEngine.setSSLParameters(sslParameters);
    }

    public void process(SSLEngine sslEngine) {
        try {
            ALPN.ClientProvider provider = (ALPN.ClientProvider)ALPN.get((SSLEngine)sslEngine);
            if (provider != null) {
                provider.selected(sslEngine.getApplicationProtocol());
            }
        }
        catch (SSLException x) {
            throw new UncheckedIOException(x);
        }
    }
}

