/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PriorityFrame;
import org.eclipse.jetty.http2.generator.FrameGenerator;
import org.eclipse.jetty.http2.generator.HeaderGenerator;
import org.eclipse.jetty.http2.generator.PriorityGenerator;
import org.eclipse.jetty.http2.hpack.HpackEncoder;
import org.eclipse.jetty.http2.hpack.HpackException;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class HeadersGenerator
extends FrameGenerator {
    private final HpackEncoder encoder;
    private final int maxHeaderBlockFragment;
    private final PriorityGenerator priorityGenerator;

    public HeadersGenerator(HeaderGenerator headerGenerator, HpackEncoder encoder) {
        this(headerGenerator, encoder, 0);
    }

    public HeadersGenerator(HeaderGenerator headerGenerator, HpackEncoder encoder, int maxHeaderBlockFragment) {
        super(headerGenerator);
        this.encoder = encoder;
        this.maxHeaderBlockFragment = maxHeaderBlockFragment;
        this.priorityGenerator = new PriorityGenerator(headerGenerator);
    }

    @Override
    public int generate(RetainableByteBuffer.Mutable accumulator, Frame frame) throws HpackException {
        HeadersFrame headersFrame = (HeadersFrame)frame;
        return this.generateHeaders(accumulator, headersFrame.getStreamId(), headersFrame.getMetaData(), headersFrame.getPriority(), headersFrame.isEndStream());
    }

    public int generateHeaders(RetainableByteBuffer.Mutable accumulator, int streamId, MetaData metaData, PriorityFrame priority, boolean endStream) throws HpackException {
        if (streamId < 0) {
            throw new IllegalArgumentException("Invalid stream id: " + streamId);
        }
        int flags = 0;
        if (priority != null) {
            flags = 32;
        }
        RetainableByteBuffer hpack = this.encode(this.encoder, metaData, this.getMaxFrameSize());
        BufferUtil.flipToFlush((ByteBuffer)hpack.getByteBuffer(), (int)0);
        int hpackLength = hpack.remaining();
        if (this.maxHeaderBlockFragment > 0 && hpackLength > this.maxHeaderBlockFragment) {
            int start = accumulator.remaining();
            if (endStream) {
                flags |= 1;
            }
            int length = this.maxHeaderBlockFragment + (priority == null ? 0 : 5);
            this.generateHeader(accumulator, FrameType.HEADERS, length, flags, streamId);
            this.generatePriority(accumulator, priority);
            accumulator.add(hpack.slice((long)this.maxHeaderBlockFragment));
            hpack.skip((long)this.maxHeaderBlockFragment);
            while (hpack.remaining() > this.maxHeaderBlockFragment) {
                this.generateHeader(accumulator, FrameType.CONTINUATION, this.maxHeaderBlockFragment, 0, streamId);
                accumulator.add(hpack.slice((long)this.maxHeaderBlockFragment));
                hpack.skip((long)this.maxHeaderBlockFragment);
            }
            this.generateHeader(accumulator, FrameType.CONTINUATION, hpack.remaining(), 4, streamId);
            accumulator.add(hpack);
            return accumulator.remaining() - start;
        }
        flags |= 4;
        if (endStream) {
            flags |= 1;
        }
        int length = hpackLength + (priority == null ? 0 : 5);
        this.generateHeader(accumulator, FrameType.HEADERS, length, flags, streamId);
        this.generatePriority(accumulator, priority);
        accumulator.add(hpack);
        return 9 + length;
    }

    private void generatePriority(RetainableByteBuffer.Mutable buffer, PriorityFrame priority) {
        if (priority != null) {
            this.priorityGenerator.generatePriorityBody(buffer, priority.getStreamId(), priority.getParentStreamId(), priority.getWeight(), priority.isExclusive());
        }
    }
}

