/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.generator;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.http2.generator.HeaderGenerator;
import org.eclipse.jetty.http2.hpack.HpackEncoder;
import org.eclipse.jetty.http2.hpack.HpackException;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public abstract class FrameGenerator {
    private final HeaderGenerator headerGenerator;

    protected FrameGenerator(HeaderGenerator headerGenerator) {
        this.headerGenerator = headerGenerator;
    }

    public abstract int generate(RetainableByteBuffer.Mutable var1, Frame var2) throws HpackException;

    protected void generateHeader(RetainableByteBuffer.Mutable accumulator, FrameType frameType, int length, int flags, int streamId) {
        this.headerGenerator.generate(accumulator, frameType, 9 + length, length, flags, streamId);
    }

    public int getMaxFrameSize() {
        return this.headerGenerator.getMaxFrameSize();
    }

    public boolean isUseDirectByteBuffers() {
        return this.headerGenerator.isUseDirectByteBuffers();
    }

    protected RetainableByteBuffer encode(HpackEncoder encoder, MetaData metaData, int maxFrameSize) throws HpackException {
        RetainableByteBuffer.Mutable hpacked = this.headerGenerator.getByteBufferPool().acquire(maxFrameSize, this.isUseDirectByteBuffers());
        try {
            ByteBuffer byteBuffer = hpacked.getByteBuffer();
            BufferUtil.clearToFill((ByteBuffer)byteBuffer);
            encoder.encode(byteBuffer, metaData);
            return hpacked;
        }
        catch (HpackException x) {
            hpacked.release();
            throw x;
        }
    }
}

