/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.GoAwayFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PingFrame;
import org.eclipse.jetty.http2.frames.PriorityFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.strategy.AdaptiveExecutionStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP2Connection
extends AbstractConnection
implements Parser.Listener,
Connection.UpgradeTo {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP2Connection.class);
    private final AutoLock lock = new AutoLock();
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
    private final HTTP2Producer producer = new HTTP2Producer();
    private final AtomicLong bytesIn = new AtomicLong();
    private final ByteBufferPool bufferPool;
    private final HTTP2Session session;
    private final int bufferSize;
    private final ExecutionStrategy strategy;
    private boolean useInputDirectByteBuffers;
    private boolean useOutputDirectByteBuffers;

    protected HTTP2Connection(ByteBufferPool bufferPool, Executor executor, EndPoint endPoint, HTTP2Session session, int bufferSize) {
        super(endPoint, executor);
        this.bufferPool = bufferPool;
        this.session = session;
        this.bufferSize = bufferSize;
        this.strategy = new AdaptiveExecutionStrategy((ExecutionStrategy.Producer)this.producer, executor);
        LifeCycle.start((Object)this.strategy);
    }

    public long getMessagesIn() {
        HTTP2Session session = this.getSession();
        return session.getStreamsOpened();
    }

    public long getMessagesOut() {
        HTTP2Session session = this.getSession();
        return session.getStreamsClosed();
    }

    public long getBytesIn() {
        return this.bytesIn.get();
    }

    public long getBytesOut() {
        return this.session.getBytesWritten();
    }

    public HTTP2Session getSession() {
        return this.session;
    }

    public void onUpgradeTo(ByteBuffer buffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 onUpgradeTo {} {}", (Object)this, (Object)BufferUtil.toDetailString((ByteBuffer)buffer));
        }
        this.producer.setInputBuffer(buffer);
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public boolean isUseOutputDirectByteBuffers() {
        return this.useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this.useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Open {} ", (Object)this);
        }
        super.onOpen();
    }

    public void onClose(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Close {} ", (Object)this);
        }
        super.onClose(cause);
        LifeCycle.stop((Object)this.strategy);
    }

    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 onFillable {} ", (Object)this);
        }
        this.produce();
    }

    private int fill(EndPoint endPoint, ByteBuffer buffer) {
        try {
            if (endPoint.isInputShutdown()) {
                return -1;
            }
            return endPoint.fill(buffer);
        }
        catch (IOException x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not read from {}", (Object)endPoint, (Object)x);
            }
            return -1;
        }
    }

    public boolean onIdleExpired(TimeoutException timeoutException) {
        boolean close;
        boolean idle = this.isFillInterested();
        if (idle && (close = this.session.onIdleTimeout())) {
            this.session.close(ErrorCode.NO_ERROR.code, "idle_timeout", Callback.NOOP);
        }
        return false;
    }

    public void offerTask(Runnable task, boolean dispatch) {
        this.offerTask(task);
        if (dispatch) {
            this.dispatch();
        } else {
            this.produce();
        }
    }

    private void offerTask(Runnable task) {
        try (AutoLock ignored = this.lock.lock();){
            this.tasks.offer(task);
        }
    }

    protected void produce() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 produce {} ", (Object)this);
        }
        this.strategy.produce();
    }

    protected void dispatch() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 dispatch {} ", (Object)this);
        }
        this.strategy.dispatch();
    }

    public void close() {
        this.session.close(ErrorCode.NO_ERROR.code, "close", Callback.NOOP);
    }

    private Runnable pollTask() {
        try (AutoLock ignored = this.lock.lock();){
            Runnable runnable = this.tasks.poll();
            return runnable;
        }
    }

    @Override
    public void onHeaders(HeadersFrame frame) {
        this.session.onHeaders(frame);
    }

    @Override
    public void onData(DataFrame frame) {
        RetainableByteBuffer.Mutable networkBuffer = this.producer.networkBuffer;
        this.session.onData(new StreamData(frame, (Retainable)networkBuffer));
    }

    @Override
    public void onPriority(PriorityFrame frame) {
        this.session.onPriority(frame);
    }

    @Override
    public void onReset(ResetFrame frame) {
        this.session.onReset(frame);
    }

    @Override
    public void onSettings(SettingsFrame frame) {
        this.session.onSettings(frame);
    }

    @Override
    public void onPushPromise(PushPromiseFrame frame) {
        this.session.onPushPromise(frame);
    }

    @Override
    public void onPing(PingFrame frame) {
        this.session.onPing(frame);
    }

    @Override
    public void onGoAway(GoAwayFrame frame) {
        this.session.onGoAway(frame);
    }

    @Override
    public void onWindowUpdate(WindowUpdateFrame frame) {
        this.session.onWindowUpdate(frame);
    }

    @Override
    public void onStreamFailure(int streamId, int error, String reason) {
        this.session.onStreamFailure(streamId, error, reason);
    }

    @Override
    public void onConnectionFailure(int error, String reason) {
        this.producer.failed = true;
        this.session.onConnectionFailure(error, reason);
    }

    protected class HTTP2Producer
    implements ExecutionStrategy.Producer {
        private final Callback fillableCallback;
        private RetainableByteBuffer.Mutable networkBuffer;
        private boolean shutdown;
        private boolean failed;

        protected HTTP2Producer() {
            this.fillableCallback = new FillableCallback();
        }

        private void setInputBuffer(ByteBuffer byteBuffer) {
            this.acquireNetworkBuffer();
            if (!this.networkBuffer.append(byteBuffer)) {
                LOG.warn("overflow");
            }
        }

        public Runnable produce() {
            Runnable task = HTTP2Connection.this.pollTask();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Dequeued task {}", (Object)task);
            }
            if (task != null) {
                return task;
            }
            if (HTTP2Connection.this.isFillInterested() || this.shutdown || this.failed) {
                return null;
            }
            boolean interested = false;
            this.acquireNetworkBuffer();
            try {
                boolean parse = this.networkBuffer.hasRemaining();
                while (true) {
                    if (parse) {
                        while (this.networkBuffer.hasRemaining()) {
                            HTTP2Connection.this.session.getParser().parse(this.networkBuffer.getByteBuffer());
                            if (!this.failed) continue;
                            Runnable runnable = null;
                            return runnable;
                        }
                        task = HTTP2Connection.this.pollTask();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Dequeued new task {}", (Object)task);
                        }
                        if (task != null) {
                            Runnable runnable = task;
                            return runnable;
                        }
                        if (this.networkBuffer.isRetained()) {
                            this.reacquireNetworkBuffer();
                        }
                    }
                    int filled = HTTP2Connection.this.fill(HTTP2Connection.this.getEndPoint(), this.networkBuffer.getByteBuffer());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Filled {} bytes in {}", (Object)filled, (Object)this.networkBuffer);
                    }
                    if (filled <= 0) {
                        if (filled == 0) {
                            interested = true;
                            Runnable runnable = null;
                            return runnable;
                        }
                        this.shutdown = true;
                        HTTP2Connection.this.session.onShutdown();
                        Runnable runnable = null;
                        return runnable;
                    }
                    HTTP2Connection.this.bytesIn.addAndGet(filled);
                    parse = true;
                }
            }
            finally {
                this.releaseNetworkBuffer();
                if (interested) {
                    HTTP2Connection.this.getEndPoint().fillInterested(this.fillableCallback);
                }
            }
        }

        private void acquireNetworkBuffer() {
            if (this.networkBuffer == null) {
                this.networkBuffer = HTTP2Connection.this.bufferPool.acquire(HTTP2Connection.this.bufferSize, HTTP2Connection.this.isUseInputDirectByteBuffers()).asMutable();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Acquired {}", (Object)this.networkBuffer);
                }
            }
        }

        private void reacquireNetworkBuffer() {
            RetainableByteBuffer.Mutable currentBuffer = this.networkBuffer;
            if (currentBuffer == null) {
                throw new IllegalStateException();
            }
            if (currentBuffer.hasRemaining()) {
                throw new IllegalStateException();
            }
            currentBuffer.release();
            this.networkBuffer = HTTP2Connection.this.bufferPool.acquire(HTTP2Connection.this.bufferSize, HTTP2Connection.this.isUseInputDirectByteBuffers());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reacquired {}<-{}", (Object)currentBuffer, (Object)this.networkBuffer);
            }
        }

        private void releaseNetworkBuffer() {
            RetainableByteBuffer.Mutable currentBuffer = this.networkBuffer;
            if (currentBuffer == null) {
                throw new IllegalStateException();
            }
            if (currentBuffer.hasRemaining() && !this.shutdown && !this.failed) {
                throw new IllegalStateException();
            }
            currentBuffer.release();
            this.networkBuffer = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Released {}", (Object)currentBuffer);
            }
        }

        public String toString() {
            return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
        }
    }

    private static class StreamData
    extends Stream.Data {
        private final Retainable retainable;

        private StreamData(DataFrame frame, Retainable retainable) {
            super(frame);
            this.retainable = retainable;
        }

        public boolean canRetain() {
            return this.retainable.canRetain();
        }

        public boolean isRetained() {
            return this.retainable.isRetained();
        }

        public void retain() {
            this.retainable.retain();
        }

        public boolean release() {
            return this.retainable.release();
        }
    }

    private class FillableCallback
    implements Callback {
        private FillableCallback() {
        }

        public void succeeded() {
            HTTP2Connection.this.onFillable();
        }

        public void failed(Throwable x) {
            HTTP2Connection.this.onFillInterestedFailed(x);
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.EITHER;
        }
    }
}

