/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.websocket.jakarta.common.messages;

import jakarta.websocket.CloseReason;
import jakarta.websocket.Decoder;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jetty.ee9.websocket.jakarta.common.decoders.RegisteredDecoder;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.CoreSession;
import org.eclipse.jetty.websocket.core.Frame;
import org.eclipse.jetty.websocket.core.exception.CloseException;
import org.eclipse.jetty.websocket.core.messages.MessageSink;
import org.eclipse.jetty.websocket.core.util.MethodHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDecodedMessageSink
implements MessageSink {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDecodedMessageSink.class);
    private final MethodHolder _methodHolder;
    private final MessageSink _messageSink;

    public AbstractDecodedMessageSink(CoreSession coreSession, MethodHolder methodHolder) {
        this._methodHolder = methodHolder;
        try {
            this._messageSink = this.newMessageSink(coreSession);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void invoke(Object message) {
        try {
            this._methodHolder.invoke(new Object[]{message});
        }
        catch (Throwable t) {
            throw new CloseException(CloseReason.CloseCodes.CANNOT_ACCEPT.getCode(), "Endpoint notification error", t);
        }
    }

    abstract MessageSink newMessageSink(CoreSession var1) throws Exception;

    public void accept(Frame frame, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("accepting frame {} for {}", (Object)frame, (Object)this._messageSink);
        }
        this._messageSink.accept(frame, callback);
    }

    public void fail(Throwable failure) {
        this._messageSink.fail(failure);
    }

    public static abstract class Stream<T extends Decoder>
    extends AbstractDecodedMessageSink {
        protected final T _decoder;

        public Stream(CoreSession coreSession, MethodHolder methodHolder, List<RegisteredDecoder> decoders) {
            super(coreSession, methodHolder);
            if (decoders.size() != 1) {
                throw new IllegalArgumentException("Require exactly one decoder for " + String.valueOf(this.getClass()));
            }
            this._decoder = decoders.get(0).getInstance();
        }
    }

    public static abstract class Basic<T extends Decoder>
    extends AbstractDecodedMessageSink {
        protected final List<T> _decoders;

        public Basic(CoreSession coreSession, MethodHolder methodHolder, List<RegisteredDecoder> decoders) {
            super(coreSession, methodHolder);
            if (decoders.isEmpty()) {
                throw new IllegalArgumentException("Require at least one decoder for " + String.valueOf(this.getClass()));
            }
            this._decoders = decoders.stream().map(RegisteredDecoder::getInstance).collect(Collectors.toList());
        }
    }
}

