/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.nested;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.ServletResponseWrapper;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.channels.IllegalSelectorException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import org.eclipse.jetty.ee9.nested.ContextHandler;
import org.eclipse.jetty.ee9.nested.HttpChannel;
import org.eclipse.jetty.ee9.nested.HttpOutput;
import org.eclipse.jetty.ee9.nested.Request;
import org.eclipse.jetty.ee9.nested.ResponseWriter;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.DateGenerator;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.content.HttpContent;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.io.WriteThroughWriter;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.HttpCookieUtils;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.AtomicBiInteger;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;

public class Response
implements HttpServletResponse {
    private static final int __MIN_BUFFER_SIZE = 1;
    private static final HttpField __EXPIRES_01JAN1970 = new PreEncodedHttpField(HttpHeader.EXPIRES, DateGenerator.__01Jan1970);
    public static final int NO_CONTENT_LENGTH = -1;
    public static final int USE_KNOWN_CONTENT_LENGTH = -2;
    private static final String HTTP_ONLY_COMMENT = "__HTTP_ONLY__";
    private static final String PARTITIONED_COMMENT = "__PARTITIONED__";
    private static final String SAME_SITE_COMMENT = "__SAME_SITE_";
    private static final String SAME_SITE_NONE_COMMENT = "__SAME_SITE_NONE__";
    private static final String SAME_SITE_LAX_COMMENT = "__SAME_SITE_LAX__";
    private static final String SAME_SITE_STRICT_COMMENT = "__SAME_SITE_STRICT__";
    public static final String SET_INCLUDE_HEADER_PREFIX = "org.eclipse.jetty.server.include.";
    private final HttpChannel _channel;
    private final AtomicBiInteger _errorSentAndIncludes = new AtomicBiInteger();
    private final HttpOutput _out;
    private int _status = 200;
    private HttpFields.Mutable _fields;
    private String _reason;
    private Locale _locale;
    private MimeTypes.Type _mimeType;
    private String _characterEncoding;
    private EncodingFrom _encodingFrom = EncodingFrom.NOT_SET;
    private String _contentType;
    private OutputType _outputType = OutputType.NONE;
    private ResponseWriter _writer;
    private long _contentLength = -1L;
    private Supplier<HttpFields> _trailers;
    private static final EnumSet<EncodingFrom> __localeOverride = EnumSet.of(EncodingFrom.NOT_SET, EncodingFrom.DEFAULT, EncodingFrom.INFERRED, EncodingFrom.SET_LOCALE);
    private static final EnumSet<EncodingFrom> __explicitCharset = EnumSet.of(EncodingFrom.SET_LOCALE, EncodingFrom.SET_CHARACTER_ENCODING, EncodingFrom.SET_CONTENT_TYPE);

    public static Response getBaseResponse(ServletResponse servletResponse) {
        while (true) {
            if (servletResponse instanceof Response) {
                Response response = (Response)servletResponse;
                return response;
            }
            if (!(servletResponse instanceof ServletResponseWrapper)) break;
            ServletResponseWrapper wrapper = (ServletResponseWrapper)servletResponse;
            servletResponse = wrapper.getResponse();
        }
        return null;
    }

    public Response(HttpChannel channel, HttpOutput out) {
        this._channel = channel;
        this._out = out;
    }

    public HttpChannel getHttpChannel() {
        return this._channel;
    }

    protected void onResponse(HttpFields.Mutable headers) {
        this._fields = headers;
    }

    protected void recycle() {
        this._fields = null;
        this._errorSentAndIncludes.set(0L);
        this._out.recycle();
        this._status = 200;
        this._reason = null;
        this._locale = null;
        this._mimeType = null;
        this._characterEncoding = null;
        this._encodingFrom = EncodingFrom.NOT_SET;
        this._contentType = null;
        this._outputType = OutputType.NONE;
        this._contentLength = -1L;
        this._trailers = null;
    }

    public HttpOutput getHttpOutput() {
        return this._out;
    }

    public void reopen() {
        this.setErrorSent(false);
        this._out.reopen();
    }

    public void errorClose() {
        this.setErrorSent(true);
        this._out.softClose();
    }

    private boolean isMutable() {
        return this._errorSentAndIncludes.get() == 0L;
    }

    private void setErrorSent(boolean errorSent) {
        this._errorSentAndIncludes.getAndSetHi(errorSent ? 1 : 0);
    }

    public boolean isIncluding() {
        return this._errorSentAndIncludes.getLo() > 0;
    }

    public void include() {
        this._errorSentAndIncludes.add(0, 1);
    }

    public void included() {
        this._errorSentAndIncludes.add(0, -1);
        if (this._outputType == OutputType.WRITER) {
            this._writer.reopen();
        }
        this._out.reopen();
    }

    public void addCookie(HttpCookie cookie) {
        if (StringUtil.isBlank((String)cookie.getName())) {
            throw new IllegalArgumentException("Cookie.name cannot be blank/null");
        }
        this._fields.add((HttpField)new HttpCookieUtils.SetCookieHttpField(this.checkSameSite(cookie), this.getHttpChannel().getHttpConfiguration().getResponseCookieCompliance()));
        this._fields.put(__EXPIRES_01JAN1970);
    }

    private HttpCookie checkSameSite(HttpCookie cookie) {
        if (cookie == null || cookie.getSameSite() != null) {
            return cookie;
        }
        ContextHandler.APIContext apiContext = this._channel.getRequest().getContext();
        Context context = apiContext == null ? null : apiContext.getCoreContext();
        HttpCookie.SameSite contextDefault = HttpCookieUtils.getSameSiteDefault((Attributes)context);
        if (contextDefault == null) {
            return cookie;
        }
        return HttpCookie.from((HttpCookie)cookie, (String[])new String[]{"SameSite", contextDefault.getAttributeValue()});
    }

    public void addCookie(Cookie cookie) {
        if (this.isMutable()) {
            if (StringUtil.isBlank((String)cookie.getName())) {
                throw new IllegalArgumentException("Cookie.name cannot be blank/null");
            }
            this.addCookie(new HttpCookieFacade(cookie));
        }
    }

    public void replaceCookie(HttpCookie cookie) {
        ListIterator i = this._fields.listIterator();
        while (i.hasNext()) {
            HttpField field = (HttpField)i.next();
            if (field.getHeader() != HttpHeader.SET_COOKIE) continue;
            CookieCompliance compliance = this.getHttpChannel().getHttpConfiguration().getResponseCookieCompliance();
            if (field instanceof HttpCookieUtils.SetCookieHttpField ? !HttpCookieUtils.match((HttpCookie)((HttpCookieUtils.SetCookieHttpField)field).getHttpCookie(), (String)cookie.getName(), (String)cookie.getDomain(), (String)cookie.getPath()) : !HttpCookieUtils.match((String)field.getValue(), (String)cookie.getName(), (String)cookie.getDomain(), (String)cookie.getPath())) continue;
            i.set(new HttpCookieUtils.SetCookieHttpField(this.checkSameSite(cookie), compliance));
            return;
        }
        this.addCookie(cookie);
    }

    public boolean containsHeader(String name) {
        return this._fields.contains(name);
    }

    public String encodeURL(String url) {
        int prefix;
        String sessionURLPrefix;
        Request request = this._channel.getRequest();
        SessionManager sessionManager = this._channel.getCoreRequest().getSessionManager();
        if (sessionManager == null) {
            return url;
        }
        HttpURI.Immutable uri = null;
        if (sessionManager.isCheckingRemoteSessionIdEncoding() && URIUtil.hasScheme((String)url)) {
            uri = HttpURI.from((String)url);
            String path = uri.getPath();
            path = path == null ? "" : path;
            int port = uri.getPort();
            if (port < 0) {
                port = URIUtil.getDefaultPortForScheme((String)uri.getScheme());
            }
            if (!request.getServerName().equalsIgnoreCase(uri.getHost())) {
                return url;
            }
            if (request.getServerPort() != port) {
                return url;
            }
            if (request.getContext() != null && !path.startsWith(request.getContextPath())) {
                return url;
            }
        }
        if ((sessionURLPrefix = sessionManager.getSessionIdPathParameterNamePrefix()) == null) {
            return url;
        }
        if (url == null) {
            return null;
        }
        if (sessionManager.isUsingCookies() && request.isRequestedSessionIdFromCookie() || !sessionManager.isUsingUriParameters()) {
            int prefix2 = url.indexOf(sessionURLPrefix);
            if (prefix2 != -1) {
                int suffix = url.indexOf("?", prefix2);
                if (suffix < 0) {
                    suffix = url.indexOf("#", prefix2);
                }
                if (suffix <= prefix2) {
                    return url.substring(0, prefix2);
                }
                return url.substring(0, prefix2) + url.substring(suffix);
            }
            return url;
        }
        HttpSession httpSession = request.getSession(false);
        if (httpSession == null) {
            return url;
        }
        Session coreSession = Session.getSession((Object)httpSession);
        if (!coreSession.isValid()) {
            return url;
        }
        String id = coreSession.getExtendedId();
        if (uri == null) {
            uri = HttpURI.from((String)url);
        }
        if ((prefix = url.indexOf(sessionURLPrefix)) != -1) {
            int suffix = url.indexOf("?", prefix);
            if (suffix < 0) {
                suffix = url.indexOf("#", prefix);
            }
            if (suffix <= prefix) {
                return url.substring(0, prefix + sessionURLPrefix.length()) + id;
            }
            return url.substring(0, prefix + sessionURLPrefix.length()) + id + url.substring(suffix);
        }
        int suffix = url.indexOf(63);
        if (suffix < 0) {
            suffix = url.indexOf(35);
        }
        if (suffix < 0) {
            return url + ((HttpScheme.HTTPS.is(uri.getScheme()) || HttpScheme.HTTP.is(uri.getScheme())) && uri.getPath() == null ? "/" : "") + sessionURLPrefix + id;
        }
        return url.substring(0, suffix) + ((HttpScheme.HTTPS.is(uri.getScheme()) || HttpScheme.HTTP.is(uri.getScheme())) && uri.getPath() == null ? "/" : "") + sessionURLPrefix + id + url.substring(suffix);
    }

    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    @Deprecated(since="Servlet API 2.1")
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    @Deprecated(since="Servlet API 2.1")
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    public void sendError(int code, String message) throws IOException {
        if (this.isIncluding()) {
            return;
        }
        switch (code) {
            case -1: {
                this._channel.abort(new IOException(message));
                break;
            }
            case 102: {
                this.sendProcessing();
                break;
            }
            case 103: {
                this.sendEarlyHint();
                break;
            }
            default: {
                this._channel.getState().sendError(code, message);
            }
        }
    }

    public void sendProcessing() throws IOException {
        if (!this.isCommitted()) {
            this._channel.send102Processing(this._fields.asImmutable());
        }
    }

    public void sendEarlyHint() throws IOException {
        if (!this.isCommitted()) {
            this._channel.send103EarlyHints(this._fields.asImmutable());
        }
    }

    public void sendRedirect(int code, String location) throws IOException {
        this.sendRedirect(code, location, false);
    }

    public void sendRedirect(String location, boolean consumeAll) throws IOException {
        this.sendRedirect(this.getHttpChannel().getRequest().getHttpVersion().getVersion() < HttpVersion.HTTP_1_1.getVersion() ? 302 : 303, location, consumeAll);
    }

    public void sendRedirect(int code, String location, boolean consumeAll) throws IOException {
        if (consumeAll) {
            this.getHttpChannel().ensureConsumeAllOrNotPersistent();
        }
        if (!HttpStatus.isRedirection((int)code)) {
            throw new IllegalArgumentException("Not a 3xx redirect code");
        }
        if (!this.isMutable()) {
            return;
        }
        if (location == null) {
            throw new IllegalArgumentException();
        }
        if (!URIUtil.hasScheme((String)location)) {
            StringBuilder buf;
            StringBuilder stringBuilder = buf = this._channel.getHttpConfiguration().isRelativeRedirectAllowed() ? new StringBuilder() : this._channel.getRequest().getRootURL();
            if (location.startsWith("/")) {
                location = URIUtil.normalizePathQuery((String)location);
            } else {
                String path = this._channel.getRequest().getRequestURI();
                String parent = path.endsWith("/") ? path : URIUtil.parentPath((String)path);
                location = URIUtil.normalizePathQuery((String)URIUtil.addEncodedPaths((String)parent, (String)location));
                if (location != null && !location.startsWith("/")) {
                    buf.append('/');
                }
            }
            if (location == null) {
                throw new IllegalStateException("path cannot be above root");
            }
            buf.append(location);
            location = buf.toString();
        }
        this.resetBuffer();
        this.setHeader(HttpHeader.LOCATION, location);
        this.setStatus(code);
        this.closeOutput();
    }

    public void sendRedirect(String location) throws IOException {
        this.sendRedirect(302, location);
    }

    public void setDateHeader(String name, long date) {
        if (this.isMutable()) {
            HttpHeader header = (HttpHeader)HttpHeader.CACHE.get(name);
            if (header == null) {
                this._fields.putDate(name, date);
            } else {
                this._fields.putDate(header, date);
            }
        }
    }

    public void addDateHeader(String name, long date) {
        if (this.isMutable()) {
            this._fields.addDateField(name, date);
        }
    }

    public void setHeader(HttpHeader name, String value) {
        if (this.isMutable()) {
            if (HttpHeader.CONTENT_TYPE == name) {
                this.setContentType(value);
            } else {
                this._fields.put(name, value);
                if (HttpHeader.CONTENT_LENGTH == name) {
                    this._contentLength = value == null ? -1L : Long.parseLong(value);
                }
            }
        }
    }

    public void setHeader(String name, String value) {
        long biInt = this._errorSentAndIncludes.get();
        if (biInt != 0L) {
            boolean including;
            boolean errorSent = AtomicBiInteger.getHi((long)biInt) != 0;
            boolean bl = including = AtomicBiInteger.getLo((long)biInt) > 0;
            if (!errorSent && including && name.startsWith(SET_INCLUDE_HEADER_PREFIX)) {
                name = name.substring(SET_INCLUDE_HEADER_PREFIX.length());
            } else {
                return;
            }
        }
        if (HttpHeader.CONTENT_TYPE.is(name)) {
            this.setContentType(value);
        } else {
            this._fields.put(name, value);
            if (HttpHeader.CONTENT_LENGTH.is(name)) {
                this._contentLength = value == null ? -1L : Long.parseLong(value);
            }
        }
    }

    public Collection<String> getHeaderNames() {
        return this._fields.getFieldNamesCollection();
    }

    public String getHeader(String name) {
        return this._fields.get(name);
    }

    public Collection<String> getHeaders(String name) {
        List i = this._fields.getValuesList(name);
        if (i == null) {
            return Collections.emptyList();
        }
        return i;
    }

    public void addHeader(String name, String value) {
        long biInt = this._errorSentAndIncludes.get();
        if (biInt != 0L) {
            boolean including;
            boolean errorSent = AtomicBiInteger.getHi((long)biInt) != 0;
            boolean bl = including = AtomicBiInteger.getLo((long)biInt) > 0;
            if (!errorSent && including && name.startsWith(SET_INCLUDE_HEADER_PREFIX)) {
                name = name.substring(SET_INCLUDE_HEADER_PREFIX.length());
            } else {
                return;
            }
        }
        if (HttpHeader.CONTENT_TYPE.is(name)) {
            this.setContentType(value);
            return;
        }
        if (HttpHeader.CONTENT_LENGTH.is(name)) {
            this.setHeader(name, value);
            return;
        }
        this._fields.add(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (this.isMutable()) {
            this._fields.put(name, (long)value);
            if (HttpHeader.CONTENT_LENGTH.is(name)) {
                this._contentLength = value;
            }
        }
    }

    public void addIntHeader(String name, int value) {
        if (this.isMutable()) {
            this._fields.add(name, Integer.toString(value));
            if (HttpHeader.CONTENT_LENGTH.is(name)) {
                this._contentLength = value;
            }
        }
    }

    public void setStatus(int sc) {
        if (sc <= 0) {
            throw new IllegalArgumentException();
        }
        if (this.isMutable()) {
            if (this._status != sc) {
                this._reason = null;
            }
            this._status = sc;
        }
    }

    @Deprecated(since="Servlet API 2.1")
    public void setStatus(int sc, String message) {
        this.setStatusWithReason(sc, null);
    }

    public void setStatusWithReason(int sc, String message) {
        if (sc <= 0) {
            throw new IllegalArgumentException();
        }
        if (this.isMutable()) {
            this._status = sc;
            this._reason = message;
        }
    }

    public String getCharacterEncoding() {
        return this.getCharacterEncoding(false);
    }

    private String getCharacterEncoding(boolean setContentType) {
        if (this._characterEncoding != null) {
            return this._characterEncoding;
        }
        if (this._mimeType != null && this._mimeType.isCharsetAssumed()) {
            return this._mimeType.getCharsetString();
        }
        MimeTypes mimeTypes = this._channel.getRequest().getCoreRequest().getContext().getMimeTypes();
        String encoding = mimeTypes.getCharsetAssumedFromContentType(this._contentType);
        if (encoding != null) {
            return encoding;
        }
        encoding = mimeTypes.getCharsetInferredFromContentType(this._contentType);
        if (encoding != null) {
            if (setContentType) {
                this.setCharacterEncoding(encoding, EncodingFrom.INFERRED);
            }
            return encoding;
        }
        ContextHandler.APIContext context = this._channel.getRequest().getContext();
        if (context != null && (encoding = context.getResponseCharacterEncoding()) != null) {
            if (setContentType) {
                this.setCharacterEncoding(encoding, EncodingFrom.DEFAULT);
            }
            return encoding;
        }
        encoding = MimeTypes.ISO_8859_1;
        if (setContentType) {
            this.setCharacterEncoding(encoding, EncodingFrom.DEFAULT);
        }
        return encoding;
    }

    public String getContentType() {
        return this._contentType;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._outputType == OutputType.WRITER) {
            throw new IllegalStateException("WRITER");
        }
        this._outputType = OutputType.STREAM;
        return this._out;
    }

    public boolean isWriting() {
        return this._outputType == OutputType.WRITER;
    }

    public boolean isStreaming() {
        return this._outputType == OutputType.STREAM;
    }

    public boolean isWritingOrStreaming() {
        return this.isWriting() || this.isStreaming();
    }

    public PrintWriter getWriter() throws IOException {
        if (this._outputType == OutputType.STREAM) {
            throw new IllegalStateException("STREAM");
        }
        if (this._outputType == OutputType.NONE) {
            String encoding = this.getCharacterEncoding(true);
            Locale locale = this.getLocale();
            if (this._writer != null && this._writer.isFor(locale, encoding)) {
                this._writer.reopen();
            } else {
                WriteThroughWriter outputStreamWriter = WriteThroughWriter.newWriter((OutputStream)((Object)this._out), (String)encoding);
                this._writer = new ResponseWriter(outputStreamWriter, locale, encoding);
            }
            this._outputType = OutputType.WRITER;
        }
        return this._writer;
    }

    public void setContentLength(int len) {
        if (this.isCommitted() || !this.isMutable()) {
            return;
        }
        if (len > 0) {
            long written = this._out.getWritten();
            if (written > (long)len) {
                throw new IllegalArgumentException("setContentLength(" + len + ") when already written " + written);
            }
            this._contentLength = len;
            this._fields.put(HttpHeader.CONTENT_LENGTH, (long)len);
            if (this.isAllContentWritten(written)) {
                try {
                    this.closeOutput();
                }
                catch (IOException e) {
                    throw new RuntimeIOException((Throwable)e);
                }
            }
        } else if (len == 0) {
            long written = this._out.getWritten();
            if (written > 0L) {
                throw new IllegalArgumentException("setContentLength(0) when already written " + written);
            }
            this._contentLength = len;
            this._fields.put(HttpFields.CONTENT_LENGTH_0);
        } else {
            this._contentLength = len;
            this._fields.remove(HttpHeader.CONTENT_LENGTH);
        }
    }

    public long getContentLength() {
        return this._contentLength;
    }

    public boolean isAllContentWritten(long written) {
        return this._contentLength >= 0L && written >= this._contentLength;
    }

    public boolean isContentComplete(long written) {
        return this._contentLength < 0L || written >= this._contentLength;
    }

    public void closeOutput() throws IOException {
        if (this._outputType == OutputType.WRITER) {
            this._writer.close();
        } else {
            this._out.close();
        }
    }

    @Deprecated
    public void completeOutput() throws IOException {
        this.closeOutput();
    }

    public void completeOutput(Callback callback) {
        if (this._outputType == OutputType.WRITER) {
            this._writer.markAsClosed();
        }
        this._out.complete(callback);
    }

    public long getLongContentLength() {
        return this._contentLength;
    }

    public void setLongContentLength(long len) {
        if (this.isCommitted() || !this.isMutable()) {
            return;
        }
        this._contentLength = len;
        this._fields.put(HttpHeader.CONTENT_LENGTH, len);
    }

    public void setContentLengthLong(long length) {
        this.setLongContentLength(length);
    }

    public void setCharacterEncoding(String encoding) {
        this.setCharacterEncoding(encoding, EncodingFrom.SET_CHARACTER_ENCODING);
    }

    private void setCharacterEncoding(String encoding, EncodingFrom from) {
        if (!this.isMutable() || this.isWriting() || this.isCommitted()) {
            return;
        }
        if (encoding == null) {
            this._encodingFrom = EncodingFrom.NOT_SET;
            if (this._characterEncoding != null) {
                this._characterEncoding = null;
                if (this._mimeType != null) {
                    this._mimeType = this._mimeType.getBaseType();
                    this._contentType = this._mimeType.asString();
                    this._fields.put(this._mimeType.getContentTypeField());
                } else if (this._contentType != null) {
                    this._contentType = MimeTypes.getContentTypeWithoutCharset((String)this._contentType);
                    this._fields.put(HttpHeader.CONTENT_TYPE, this._contentType);
                }
            }
        } else {
            this._encodingFrom = from;
            String string = this._characterEncoding = HttpGenerator.__STRICT ? encoding : MimeTypes.normalizeCharset((String)encoding);
            if (this._mimeType != null) {
                this._contentType = this._mimeType.getBaseType().asString() + ";charset=" + this._characterEncoding;
                this._mimeType = (MimeTypes.Type)MimeTypes.CACHE.get(this._contentType);
                if (this._mimeType == null || HttpGenerator.__STRICT) {
                    this._fields.put(HttpHeader.CONTENT_TYPE, this._contentType);
                } else {
                    this._fields.put(this._mimeType.getContentTypeField());
                }
            } else if (this._contentType != null) {
                this._contentType = MimeTypes.getContentTypeWithoutCharset((String)this._contentType) + ";charset=" + this._characterEncoding;
                this._fields.put(HttpHeader.CONTENT_TYPE, this._contentType);
            }
        }
    }

    public void setContentType(String contentType) {
        block14: {
            block16: {
                String charset;
                block15: {
                    block13: {
                        if (this.isCommitted() || !this.isMutable()) {
                            return;
                        }
                        if (contentType != null) break block13;
                        if (this.isWriting() && this._characterEncoding != null) {
                            throw new IllegalSelectorException();
                        }
                        if (this._locale == null) {
                            this._characterEncoding = null;
                        }
                        this._mimeType = null;
                        this._contentType = null;
                        this._fields.remove(HttpHeader.CONTENT_TYPE);
                        break block14;
                    }
                    this._contentType = contentType;
                    this._mimeType = (MimeTypes.Type)MimeTypes.CACHE.get(contentType);
                    charset = MimeTypes.getCharsetFromContentType((String)contentType);
                    if (charset == null && this._mimeType != null && this._mimeType.isCharsetAssumed()) {
                        charset = this._mimeType.getCharsetString();
                    }
                    if (charset != null) break block15;
                    switch (this._encodingFrom.ordinal()) {
                        case 0: {
                            break block16;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            this._contentType = contentType + ";charset=" + this._characterEncoding;
                            this._mimeType = (MimeTypes.Type)MimeTypes.CACHE.get(this._contentType);
                            break block16;
                        }
                        default: {
                            throw new IllegalStateException(this._encodingFrom.toString());
                        }
                    }
                }
                if (this.isWriting() && !charset.equalsIgnoreCase(this._characterEncoding)) {
                    this._contentType = MimeTypes.getContentTypeWithoutCharset((String)this._contentType);
                    if (!(this._characterEncoding == null || this._mimeType != null && this._mimeType.isCharsetAssumed())) {
                        this._contentType = this._contentType + ";charset=" + this._characterEncoding;
                    }
                    this._mimeType = (MimeTypes.Type)MimeTypes.CACHE.get(this._contentType);
                } else {
                    this._characterEncoding = charset;
                    this._encodingFrom = EncodingFrom.SET_CONTENT_TYPE;
                }
            }
            if (HttpGenerator.__STRICT || this._mimeType == null) {
                this._fields.put(HttpHeader.CONTENT_TYPE, this._contentType);
            } else {
                this._contentType = this._mimeType.asString();
                this._fields.put(this._mimeType.getContentTypeField());
            }
        }
    }

    public void setBufferSize(int size) {
        if (this.isCommitted()) {
            throw new IllegalStateException("cannot set buffer size after response is in committed state");
        }
        if (this.getContentCount() > 0L) {
            throw new IllegalStateException("cannot set buffer size after response has " + this.getContentCount() + " bytes already written");
        }
        if (size < 1) {
            size = 1;
        }
        this._out.setBufferSize(size);
    }

    public int getBufferSize() {
        return this._out.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        if (!this._out.isClosed()) {
            this._out.flush();
        }
    }

    public void reset() {
        HttpCookie cookie;
        SessionManager sessionManager;
        this._status = 200;
        this._reason = null;
        this._out.resetBuffer();
        this._outputType = OutputType.NONE;
        this._contentLength = -1L;
        this._contentType = null;
        this._mimeType = null;
        this._characterEncoding = null;
        this._encodingFrom = EncodingFrom.NOT_SET;
        this._trailers = null;
        this._fields.clear();
        for (String value : this._channel.getRequest().getHttpFields().getCSV(HttpHeader.CONNECTION, false)) {
            HttpHeaderValue cb = (HttpHeaderValue)HttpHeaderValue.CACHE.get(value);
            if (cb == null) continue;
            switch (cb) {
                case CLOSE: {
                    this._fields.put(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.toString());
                    break;
                }
                case KEEP_ALIVE: {
                    if (!HttpVersion.HTTP_1_0.is(this._channel.getRequest().getProtocol())) break;
                    this._fields.put(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.toString());
                    break;
                }
                case TE: {
                    this._fields.put(HttpHeader.CONNECTION, HttpHeaderValue.TE.toString());
                    break;
                }
            }
        }
        ContextHandler.CoreContextRequest coreRequest = this.getHttpChannel().getCoreRequest();
        Request request = this.getHttpChannel().getRequest();
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null && httpSession.isNew() && (sessionManager = coreRequest.getSessionManager()) != null && (cookie = sessionManager.getSessionCookie(coreRequest.getManagedSession(), request.isSecure())) != null) {
            this.addCookie(cookie);
        }
    }

    public void resetContent() {
        this._out.resetBuffer();
        this._outputType = OutputType.NONE;
        this._contentLength = -1L;
        this._contentType = null;
        this._mimeType = null;
        this._characterEncoding = null;
        this._encodingFrom = EncodingFrom.NOT_SET;
        Iterator i = this.getHttpFields().iterator();
        block3: while (i.hasNext()) {
            HttpField field = (HttpField)i.next();
            if (field.getHeader() == null) continue;
            switch (field.getHeader()) {
                case CONTENT_TYPE: 
                case CONTENT_LENGTH: 
                case CONTENT_ENCODING: 
                case CONTENT_LANGUAGE: 
                case CONTENT_RANGE: 
                case CONTENT_MD5: 
                case CONTENT_LOCATION: 
                case TRANSFER_ENCODING: 
                case CACHE_CONTROL: 
                case LAST_MODIFIED: 
                case EXPIRES: 
                case ETAG: 
                case VARY: {
                    i.remove();
                    continue block3;
                }
            }
        }
    }

    public void resetForForward() {
        this.resetBuffer();
        this._outputType = OutputType.NONE;
    }

    public void resetBuffer() {
        this._out.resetBuffer();
        this._out.reopen();
    }

    public Supplier<HttpFields> getTrailers() {
        return this._trailers;
    }

    public void setTrailers(Supplier<HttpFields> trailers) {
        this._trailers = trailers;
    }

    public Supplier<Map<String, String>> getTrailerFields() {
        if (this._trailers instanceof HttpFieldsSupplier) {
            return ((HttpFieldsSupplier)this._trailers).getSupplier();
        }
        return null;
    }

    public void setTrailerFields(Supplier<Map<String, String>> trailers) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        HttpVersion version = this.getHttpChannel().getRequest().getHttpVersion();
        if (version == null || version.compareTo((Enum)HttpVersion.HTTP_1_1) < 0) {
            throw new IllegalStateException("Trailers not supported in " + String.valueOf(version));
        }
        this.setTrailers(new HttpFieldsSupplier(trailers));
    }

    protected MetaData.Response newResponseMetaData() {
        return new MetaData.Response(this.getStatus(), this.getReason(), this._channel.getRequest().getHttpVersion(), (HttpFields)this._channel.getCoreResponse().getHeaders(), this.getLongContentLength(), this.getTrailers());
    }

    public boolean isCommitted() {
        if (this._channel.isSendError()) {
            return true;
        }
        return this._channel.isCommitted();
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted() || !this.isMutable()) {
            return;
        }
        if (locale == null) {
            this._locale = null;
            this._fields.remove(HttpHeader.CONTENT_LANGUAGE);
            if (this._encodingFrom == EncodingFrom.SET_LOCALE) {
                this.setCharacterEncoding(null, EncodingFrom.NOT_SET);
            }
        } else {
            this._locale = locale;
            this._fields.put(HttpHeader.CONTENT_LANGUAGE, StringUtil.replace((String)locale.toString(), (char)'_', (char)'-'));
            if (this._outputType != OutputType.NONE) {
                return;
            }
            ContextHandler.APIContext context = this._channel.getRequest().getContext();
            if (context == null) {
                return;
            }
            String charset = context.getContextHandler().getLocaleEncoding(locale);
            if (!StringUtil.isEmpty((String)charset) && __localeOverride.contains((Object)this._encodingFrom)) {
                this.setCharacterEncoding(charset, EncodingFrom.SET_LOCALE);
            }
        }
    }

    public Locale getLocale() {
        if (this._locale == null) {
            return Locale.getDefault();
        }
        return this._locale;
    }

    public int getStatus() {
        return this._status;
    }

    public String getReason() {
        return this._reason;
    }

    public HttpFields.Mutable getHttpFields() {
        return this._fields;
    }

    public long getContentCount() {
        return this._out.getWritten();
    }

    public String toString() {
        return String.format("%s %d %s%n%s", this._channel.getRequest().getHttpVersion(), this._status, this._reason == null ? "" : this._reason, this._fields);
    }

    public void putHeaders(HttpContent content, long contentLength, boolean etag) {
        HttpField et;
        HttpField ce;
        HttpField lm = content.getLastModified();
        if (lm != null) {
            this._fields.put(lm);
        }
        if (contentLength == -2L) {
            this._fields.put(content.getContentLength());
            this._contentLength = content.getContentLengthValue();
        } else if (contentLength > -1L) {
            this._fields.put(HttpHeader.CONTENT_LENGTH, contentLength);
            this._contentLength = contentLength;
        }
        HttpField ct = content.getContentType();
        if (ct != null) {
            if (!__explicitCharset.contains((Object)this._encodingFrom)) {
                this._fields.put(ct);
                this._contentType = ct.getValue();
                this._characterEncoding = content.getCharacterEncoding();
                this._mimeType = content.getMimeType();
            } else {
                this.setContentType(content.getContentTypeValue());
            }
        }
        if ((ce = content.getContentEncoding()) != null) {
            this._fields.put(ce);
        }
        if (etag && (et = content.getETag()) != null) {
            this._fields.put(et);
        }
    }

    public static void putHeaders(HttpServletResponse response, HttpContent content, long contentLength, boolean etag) {
        String et;
        String ce;
        String ct;
        long lml = content.getResource().lastModified().toEpochMilli();
        if (lml >= 0L) {
            response.setDateHeader(HttpHeader.LAST_MODIFIED.asString(), lml);
        }
        if (contentLength == -2L) {
            contentLength = content.getContentLengthValue();
        }
        if (contentLength > -1L) {
            if (contentLength < Integer.MAX_VALUE) {
                response.setContentLength((int)contentLength);
            } else {
                response.setHeader(HttpHeader.CONTENT_LENGTH.asString(), Long.toString(contentLength));
            }
        }
        if ((ct = content.getContentTypeValue()) != null && response.getContentType() == null) {
            response.setContentType(ct);
        }
        if ((ce = content.getContentEncodingValue()) != null) {
            response.setHeader(HttpHeader.CONTENT_ENCODING.asString(), ce);
        }
        if (etag && (et = content.getETagValue()) != null) {
            response.setHeader(HttpHeader.ETAG.asString(), et);
        }
    }

    public static HttpServletResponse unwrap(ServletResponse servletResponse) {
        if (servletResponse instanceof HttpServletResponseWrapper) {
            return (HttpServletResponseWrapper)servletResponse;
        }
        if (servletResponse instanceof ServletResponseWrapper) {
            return Response.unwrap(((ServletResponseWrapper)servletResponse).getResponse());
        }
        return (HttpServletResponse)servletResponse;
    }

    private static enum EncodingFrom {
        NOT_SET,
        DEFAULT,
        INFERRED,
        SET_LOCALE,
        SET_CONTENT_TYPE,
        SET_CHARACTER_ENCODING;

    }

    public static enum OutputType {
        NONE,
        STREAM,
        WRITER;

    }

    private static class HttpCookieFacade
    implements HttpCookie {
        private final Cookie _cookie;
        private final String _comment;
        private final boolean _httpOnly;
        private final HttpCookie.SameSite _sameSite;
        private final boolean _partitioned;

        public HttpCookieFacade(Cookie cookie) {
            this._cookie = cookie;
            String comment = cookie.getComment();
            this._httpOnly = cookie.isHttpOnly() || HttpCookieFacade.isHttpOnlyInComment(comment);
            this._sameSite = HttpCookieFacade.getSameSiteFromComment(comment);
            this._partitioned = HttpCookieFacade.isPartitionedInComment(comment);
            this._comment = HttpCookieFacade.getCommentWithoutAttributes(comment);
        }

        public String getComment() {
            return this._comment;
        }

        public String getDomain() {
            return this._cookie.getDomain();
        }

        public long getMaxAge() {
            return this._cookie.getMaxAge();
        }

        public String getPath() {
            return this._cookie.getPath();
        }

        public boolean isSecure() {
            return this._cookie.getSecure();
        }

        public String getName() {
            return this._cookie.getName();
        }

        public String getValue() {
            return this._cookie.getValue();
        }

        public int getVersion() {
            return this._cookie.getVersion();
        }

        public HttpCookie.SameSite getSameSite() {
            return this._sameSite;
        }

        public boolean isHttpOnly() {
            return this._httpOnly;
        }

        public boolean isPartitioned() {
            return this._partitioned;
        }

        public Map<String, String> getAttributes() {
            TreeMap<String, String> attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            attributes.put("Comment", this._comment);
            attributes.put("Domain", this.getDomain());
            if (this._httpOnly) {
                attributes.put("HttpOnly", Boolean.TRUE.toString());
            }
            if (this._cookie.getMaxAge() >= 0) {
                attributes.put("Max-Age", Long.toString(this.getMaxAge()));
            }
            attributes.put("Path", this.getPath());
            if (this._sameSite != null) {
                attributes.put("SameSite", this._sameSite.getAttributeValue());
            }
            if (this.isSecure()) {
                attributes.put("Secure", Boolean.TRUE.toString());
            }
            if (this.isPartitioned()) {
                attributes.put("Partitioned", Boolean.TRUE.toString());
            }
            return attributes;
        }

        public int hashCode() {
            return HttpCookie.hashCode((HttpCookie)this);
        }

        public boolean equals(Object obj) {
            return HttpCookie.equals((HttpCookie)this, (Object)obj);
        }

        public String toString() {
            return HttpCookie.toString((HttpCookie)this);
        }

        private static boolean isHttpOnlyInComment(String comment) {
            return comment != null && comment.contains(Response.HTTP_ONLY_COMMENT);
        }

        private static boolean isPartitionedInComment(String comment) {
            return comment != null && comment.contains(Response.PARTITIONED_COMMENT);
        }

        private static HttpCookie.SameSite getSameSiteFromComment(String comment) {
            if (comment == null) {
                return null;
            }
            if (comment.contains(Response.SAME_SITE_STRICT_COMMENT)) {
                return HttpCookie.SameSite.STRICT;
            }
            if (comment.contains(Response.SAME_SITE_LAX_COMMENT)) {
                return HttpCookie.SameSite.LAX;
            }
            if (comment.contains(Response.SAME_SITE_NONE_COMMENT)) {
                return HttpCookie.SameSite.NONE;
            }
            return null;
        }

        private static String getCommentWithoutAttributes(String comment) {
            if (comment == null) {
                return null;
            }
            String strippedComment = comment.trim();
            strippedComment = StringUtil.strip((String)strippedComment, (String)Response.HTTP_ONLY_COMMENT);
            strippedComment = StringUtil.strip((String)strippedComment, (String)Response.PARTITIONED_COMMENT);
            strippedComment = StringUtil.strip((String)strippedComment, (String)Response.SAME_SITE_NONE_COMMENT);
            strippedComment = StringUtil.strip((String)strippedComment, (String)Response.SAME_SITE_LAX_COMMENT);
            return (strippedComment = StringUtil.strip((String)strippedComment, (String)Response.SAME_SITE_STRICT_COMMENT)).isEmpty() ? null : strippedComment;
        }
    }

    private static class HttpFieldsSupplier
    implements Supplier<HttpFields> {
        private final Supplier<Map<String, String>> _supplier;

        public HttpFieldsSupplier(Supplier<Map<String, String>> trailers) {
            this._supplier = trailers;
        }

        @Override
        public HttpFields get() {
            Map<String, String> t = this._supplier.get();
            if (t == null) {
                return null;
            }
            HttpFields.Mutable fields = HttpFields.build();
            for (Map.Entry<String, String> e : t.entrySet()) {
                fields.add(e.getKey(), e.getValue());
            }
            return fields.asImmutable();
        }

        public Supplier<Map<String, String>> getSupplier() {
            return this._supplier;
        }
    }
}

