/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.eclipse.jetty.ee8.maven.plugin.MavenWebAppContext;
import org.eclipse.jetty.ee8.maven.plugin.Overlay;
import org.eclipse.jetty.ee8.maven.plugin.OverlayConfig;
import org.eclipse.jetty.ee8.maven.plugin.SelectiveJarResource;
import org.eclipse.jetty.ee8.maven.plugin.WarPluginInfo;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class OverlayManager {
    private WarPluginInfo warPlugin;

    public OverlayManager(WarPluginInfo warPlugin) {
        this.warPlugin = warPlugin;
    }

    public void applyOverlays(MavenWebAppContext webApp) throws Exception {
        ArrayList<Resource> resourceBases = new ArrayList<Resource>();
        for (Overlay o : this.getOverlays()) {
            if (o.getConfig() != null && o.getConfig().isCurrentProject() && webApp.getBaseResource().exists()) {
                resourceBases.add(webApp.getBaseResource());
                continue;
            }
            resourceBases.add(this.unpackOverlay(o));
        }
        if (!resourceBases.contains(webApp.getBaseResource()) && webApp.getBaseResource().exists()) {
            if (webApp.getBaseAppFirst()) {
                resourceBases.add(0, webApp.getBaseResource());
            } else {
                resourceBases.add(webApp.getBaseResource());
            }
        }
        webApp.setBaseResource(ResourceFactory.combine(resourceBases));
    }

    protected List<Overlay> getOverlays() throws Exception {
        HashSet<Artifact> matchedWarArtifacts = new HashSet<Artifact>();
        ArrayList<Overlay> overlays = new ArrayList<Overlay>();
        for (OverlayConfig config : this.warPlugin.getMavenWarOverlayConfigs()) {
            if (config.isSkip()) continue;
            if (config.isCurrentProject()) {
                Overlay overlay = new Overlay(config, null);
                overlays.add(overlay);
                continue;
            }
            Artifact a = this.warPlugin.getWarArtifact(config.getGroupId(), config.getArtifactId(), config.getClassifier());
            if (a == null) continue;
            matchedWarArtifacts.add(a);
            Resource resource = ResourceFactory.root().newJarFileResource(a.getFile().toPath().toUri());
            SelectiveJarResource r = new SelectiveJarResource(resource);
            r.setIncludes(config.getIncludes());
            r.setExcludes(config.getExcludes());
            Overlay overlay = new Overlay(config, r);
            overlays.add(overlay);
        }
        for (Artifact a : this.warPlugin.getWarArtifacts()) {
            if (matchedWarArtifacts.contains(a)) continue;
            Resource resource = ResourceFactory.root().newJarFileResource(a.getFile().toPath().toUri());
            Overlay overlay = new Overlay(null, resource);
            overlays.add(overlay);
        }
        return overlays;
    }

    protected Resource unpackOverlay(Overlay overlay) throws IOException {
        File dir;
        if (overlay.getResource() == null) {
            return null;
        }
        String name = overlay.getResource().getFileName();
        name = name.replace('.', '_');
        File overlaysDir = new File(this.warPlugin.getProject().getBuild().getDirectory(), "jetty_overlays");
        File unpackDir = dir = new File(overlaysDir, name);
        if (overlay.getConfig() != null && overlay.getConfig().getTargetPath() != null) {
            unpackDir = new File(dir, overlay.getConfig().getTargetPath());
        }
        overlay.unpackTo(unpackDir);
        return ResourceFactory.root().newResource(unpackDir.getCanonicalPath());
    }
}

