/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee11.websocket.jakarta.common.encoders;

import jakarta.websocket.Encoder;
import java.lang.reflect.Type;
import org.eclipse.jetty.websocket.core.util.ReflectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisteredEncoder {
    private static final Logger LOG = LoggerFactory.getLogger(RegisteredEncoder.class);
    public final Class<? extends Encoder> encoder;
    public final Class<? extends Encoder> interfaceType;
    public final Type objectType;
    public final boolean primitive;
    public Encoder instance;

    public RegisteredEncoder(Class<? extends Encoder> encoder, Class<? extends Encoder> interfaceType, Type objectType) {
        this(encoder, interfaceType, objectType, false);
    }

    public RegisteredEncoder(Class<? extends Encoder> encoder, Class<? extends Encoder> interfaceType, Type objectType, boolean primitive) {
        this.encoder = encoder;
        this.interfaceType = interfaceType;
        this.objectType = objectType;
        this.primitive = primitive;
    }

    public boolean implementsInterface(Class<? extends Encoder> type) {
        return this.interfaceType.isAssignableFrom(type);
    }

    public boolean isType(Type type) {
        return ReflectUtils.isAssignableFrom((Type)this.objectType, (Type)type);
    }

    public void destroyInstance() {
        if (this.instance != null) {
            try {
                this.instance.destroy();
            }
            catch (Throwable t) {
                LOG.warn("Error destroying Decoder", t);
            }
            this.instance = null;
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(RegisteredEncoder.class.getSimpleName());
        str.append('[').append(this.encoder.getName());
        str.append(',').append(this.interfaceType.getName());
        str.append(',').append(this.objectType.getTypeName());
        if (this.primitive) {
            str.append(",PRIMITIVE");
        }
        str.append(']');
        return str.toString();
    }
}

