/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.ee10.servlet.AsyncContextEvent;
import org.eclipse.jetty.ee10.servlet.Dispatcher;
import org.eclipse.jetty.ee10.servlet.ErrorHandler;
import org.eclipse.jetty.ee10.servlet.HttpInput;
import org.eclipse.jetty.ee10.servlet.HttpOutput;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.servlet.ServletRequestState;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.QuietException;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.ResponseUtils;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletChannel {
    private static final Logger LOG = LoggerFactory.getLogger(ServletChannel.class);
    private final ServletRequestState _state;
    private final ServletContextHandler.ServletScopedContext _context;
    private final ServletContextHandler.ServletContextApi _servletContextApi;
    private final ConnectionMetaData _connectionMetaData;
    private final AtomicLong _requests = new AtomicLong();
    private final HttpInput _httpInput;
    private final HttpOutput _httpOutput;
    private ServletContextRequest _servletContextRequest;
    private Request _request;
    private Response _response;
    private Callback _callback;
    private boolean _expects100Continue;
    private long _written;

    public ServletChannel(ServletContextHandler servletContextHandler, Request request) {
        this(servletContextHandler, request.getConnectionMetaData());
    }

    public ServletChannel(ServletContextHandler servletContextHandler, ConnectionMetaData connectionMetaData) {
        this._context = servletContextHandler.getContext();
        this._servletContextApi = this._context.getServletContext();
        this._connectionMetaData = connectionMetaData;
        this._state = new ServletRequestState(this);
        this._httpInput = new HttpInput(this);
        this._httpOutput = new HttpOutput(this);
    }

    public ConnectionMetaData getConnectionMetaData() {
        return this._connectionMetaData;
    }

    public Callback getCallback() {
        return this._callback;
    }

    public void associate(ServletContextRequest servletContextRequest) {
        this._state.recycle();
        this._httpInput.reopen();
        this._httpOutput.recycle();
        this._servletContextRequest = servletContextRequest;
        this._request = this._servletContextRequest;
        this._response = this._servletContextRequest.getServletContextResponse();
        this._expects100Continue = servletContextRequest.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
        if (LOG.isDebugEnabled()) {
            LOG.debug("new {} -> {},{}", new Object[]{this, this._servletContextRequest, this._state});
        }
    }

    public void associate(Request request, Response response, Callback callback) {
        if (this._callback != null) {
            throw new IllegalStateException();
        }
        if (request != this._request && Request.as((Request)request, ServletContextRequest.class) != this._servletContextRequest) {
            throw new IllegalStateException();
        }
        this._request = request;
        this._response = response;
        this._callback = callback;
    }

    public ServletContextHandler.ServletScopedContext getContext() {
        return this._context;
    }

    public ServletContextHandler getServletContextHandler() {
        return (ServletContextHandler)this._context.getContextHandler();
    }

    public ServletContextHandler.ServletContextApi getServletContextApi() {
        return this._servletContextApi;
    }

    public HttpOutput getHttpOutput() {
        return this._httpOutput;
    }

    public HttpInput getHttpInput() {
        return this._httpInput;
    }

    public ServletContextHandler.ServletContextApi getServletContextContext() {
        return this._servletContextApi;
    }

    public boolean isSendError() {
        return this._state.isSendError();
    }

    protected String formatAddrOrHost(String addr) {
        return HostPort.normalizeHost((String)addr);
    }

    public ServletRequestState getServletRequestState() {
        return this._state;
    }

    public long getBytesWritten() {
        return this._written;
    }

    public long getIdleTimeout() {
        return this._connectionMetaData.getConnection().getEndPoint().getIdleTimeout();
    }

    public void setIdleTimeout(long timeoutMs) {
        this._connectionMetaData.getConnection().getEndPoint().setIdleTimeout(timeoutMs);
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._connectionMetaData.getHttpConfiguration();
    }

    public Server getServer() {
        return this._context.getContextHandler().getServer();
    }

    public ServletContextRequest getServletContextRequest() {
        return this._servletContextRequest;
    }

    public Request getRequest() {
        return this._request;
    }

    public ServletContextResponse getServletContextResponse() {
        ServletContextRequest request = this._servletContextRequest;
        return request == null ? null : request.getServletContextResponse();
    }

    public Response getResponse() {
        return this._response;
    }

    public Connection getConnection() {
        return this._connectionMetaData.getConnection();
    }

    public EndPoint getEndPoint() {
        return this.getConnection().getEndPoint();
    }

    public String getLocalName() {
        SocketAddress localAddress;
        HttpConfiguration httpConfiguration = this.getHttpConfiguration();
        if (httpConfiguration != null && (localAddress = httpConfiguration.getLocalAddress()) instanceof InetSocketAddress) {
            return ((InetSocketAddress)localAddress).getHostName();
        }
        InetSocketAddress local = this.getLocalAddress();
        if (local != null) {
            return local.getHostString();
        }
        return null;
    }

    public int getLocalPort() {
        SocketAddress localAddress;
        HttpConfiguration httpConfiguration = this.getHttpConfiguration();
        if (httpConfiguration != null && (localAddress = httpConfiguration.getLocalAddress()) instanceof InetSocketAddress) {
            return ((InetSocketAddress)localAddress).getPort();
        }
        InetSocketAddress local = this.getLocalAddress();
        return local == null ? 0 : local.getPort();
    }

    public InetSocketAddress getLocalAddress() {
        SocketAddress localAddress;
        HttpConfiguration httpConfiguration = this.getHttpConfiguration();
        if (httpConfiguration != null && (localAddress = httpConfiguration.getLocalAddress()) instanceof InetSocketAddress) {
            return (InetSocketAddress)localAddress;
        }
        SocketAddress local = this.getEndPoint().getLocalSocketAddress();
        if (local instanceof InetSocketAddress) {
            return (InetSocketAddress)local;
        }
        return null;
    }

    public InetSocketAddress getRemoteAddress() {
        SocketAddress remote = this.getEndPoint().getRemoteSocketAddress();
        if (remote instanceof InetSocketAddress) {
            return (InetSocketAddress)remote;
        }
        return null;
    }

    public HostPort getServerAuthority() {
        HttpConfiguration httpConfiguration = this.getHttpConfiguration();
        if (httpConfiguration != null) {
            return httpConfiguration.getServerAuthority();
        }
        return null;
    }

    public void continue100(int available) throws IOException {
        if (this.isExpecting100Continue()) {
            this._expects100Continue = false;
            if (available == 0) {
                if (this.isCommitted()) {
                    throw new IOException("Committed before 100 Continue");
                }
                try {
                    this.getServletContextResponse().writeInterim(100, HttpFields.EMPTY).get();
                }
                catch (Throwable x) {
                    throw IO.rethrow((Throwable)x);
                }
            }
        }
    }

    private void recycle() {
        this._httpInput.recycle();
        this._servletContextRequest = null;
        this._callback = null;
        this._written = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("handle {} {} ", (Object)this._servletContextRequest.getHttpURI(), (Object)this);
        }
        ServletRequestState.Action action = this._state.handling();
        block26: while (!this.getServer().isStopped()) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("action {} {}", (Object)action, (Object)this);
                }
                switch (action) {
                    case TERMINATED: {
                        this.onCompleted();
                        break block26;
                    }
                    case WAIT: {
                        break block26;
                    }
                    case DISPATCH: {
                        this.dispatch(() -> {
                            try {
                                this._context.getServletContextHandler().requestInitialized((Request)this._servletContextRequest, this._servletContextRequest.getServletApiRequest());
                                ServletHandler servletHandler = this._context.getServletContextHandler().getServletHandler();
                                ServletHandler.MappedServlet mappedServlet = (ServletHandler.MappedServlet)this._servletContextRequest.getMatchedResource().getResource();
                                mappedServlet.handle(servletHandler, Request.getPathInContext((Request)this._servletContextRequest), this._servletContextRequest.getServletApiRequest(), this._servletContextRequest.getHttpServletResponse());
                            }
                            finally {
                                this._context.getServletContextHandler().requestDestroyed((Request)this._servletContextRequest, this._servletContextRequest.getServletApiRequest());
                            }
                        });
                        break;
                    }
                    case ASYNC_DISPATCH: {
                        this.dispatch(() -> {
                            try {
                                HttpURI uri;
                                String pathInContext;
                                this._context.getServletContextHandler().requestInitialized((Request)this._servletContextRequest, this._servletContextRequest.getServletApiRequest());
                                AsyncContextEvent asyncContextEvent = this._state.getAsyncContextEvent();
                                String dispatchString = asyncContextEvent.getDispatchPath();
                                if (dispatchString != null) {
                                    String contextPath = this._context.getContextPath();
                                    HttpURI.Immutable dispatchUri = HttpURI.from((String)dispatchString);
                                    pathInContext = URIUtil.canonicalPath((String)dispatchUri.getPath());
                                    uri = HttpURI.build((HttpURI)this._servletContextRequest.getHttpURI()).path(URIUtil.addPaths((String)contextPath, (String)pathInContext)).query(dispatchUri.getQuery());
                                } else {
                                    uri = asyncContextEvent.getBaseURI();
                                    if (uri == null) {
                                        uri = this._servletContextRequest.getHttpURI();
                                        pathInContext = Request.getPathInContext((Request)this._servletContextRequest);
                                    } else {
                                        pathInContext = uri.getCanonicalPath();
                                        if (this._context.getContextPath().length() > 1) {
                                            pathInContext = pathInContext.substring(this._context.getContextPath().length());
                                        }
                                    }
                                }
                                String decodedPathInContext = URIUtil.decodePath((String)pathInContext);
                                Dispatcher dispatcher = new Dispatcher(this.getServletContextHandler(), uri, decodedPathInContext);
                                dispatcher.async(asyncContextEvent.getSuppliedRequest(), asyncContextEvent.getSuppliedResponse());
                            }
                            finally {
                                this._context.getServletContextHandler().requestDestroyed((Request)this._servletContextRequest, this._servletContextRequest.getServletApiRequest());
                            }
                        });
                        break;
                    }
                    case ASYNC_TIMEOUT: {
                        this._state.onTimeout();
                        break;
                    }
                    case SEND_ERROR: {
                        Throwable throwable;
                        Object errorException = this._servletContextRequest.getAttribute("jakarta.servlet.error.exception");
                        Throwable cause = errorException instanceof Throwable ? (throwable = (Throwable)errorException) : null;
                        try {
                            this.getServletContextResponse().resetContent();
                            Integer code = (Integer)this._servletContextRequest.getAttribute("jakarta.servlet.error.status_code");
                            if (code == null) {
                                code = 500;
                            }
                            this.getServletContextResponse().setStatus(code);
                            if (!this._httpInput.consumeAvailable()) {
                                ResponseUtils.ensureNotPersistent((Request)this._servletContextRequest, (Response)this._servletContextRequest.getServletContextResponse());
                            }
                            ContextHandler.ScopedContext context = (ContextHandler.ScopedContext)this._servletContextRequest.getAttribute("org.eclipse.jetty.server.error_context");
                            Request.Handler errorHandler = ErrorHandler.getErrorHandler(this.getServer(), context == null ? null : context.getContextHandler());
                            if (HttpStatus.hasNoBody((int)this.getServletContextResponse().getStatus()) || errorHandler == null) {
                                this.sendResponseAndComplete();
                                break;
                            }
                            try (Blocker.Callback blocker = Blocker.callback();){
                                this.dispatch(() -> errorHandler.handle((Request)this._servletContextRequest, (Response)this.getServletContextResponse(), (Callback)blocker));
                                blocker.block();
                                break;
                            }
                        }
                        catch (Throwable x) {
                            if (cause == null) {
                                cause = x;
                            } else if (ExceptionUtil.areNotAssociated((Throwable)cause, (Throwable)x)) {
                                cause.addSuppressed(x);
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Could not perform ERROR dispatch, aborting", cause);
                            }
                            if (this._state.isResponseCommitted()) {
                                this.abort(cause);
                            } else {
                                try {
                                    this.getServletContextResponse().resetContent();
                                    this.sendResponseAndComplete();
                                }
                                catch (Throwable t) {
                                    if (ExceptionUtil.areNotAssociated((Throwable)cause, (Throwable)t)) {
                                        cause.addSuppressed(t);
                                    }
                                    this.abort(cause);
                                }
                            }
                            break;
                        }
                        finally {
                            this._servletContextRequest.removeAttribute("org.eclipse.jetty.server.error_context");
                        }
                    }
                    case ASYNC_ERROR: {
                        throw this._state.getAsyncContextEvent().getThrowable();
                    }
                    case READ_CALLBACK: {
                        this._context.run(() -> this._servletContextRequest.getHttpInput().run());
                        break;
                    }
                    case WRITE_CALLBACK: {
                        this._context.run(() -> this._servletContextRequest.getHttpOutput().run());
                        break;
                    }
                    case COMPLETE: {
                        if (!this.getServletContextResponse().isCommitted() && this.getServletContextResponse().getStatus() >= 200) {
                            ResponseUtils.ensureConsumeAvailableOrNotPersistent((Request)this._servletContextRequest, (Response)this._servletContextRequest.getServletContextResponse());
                        }
                        if (!this._servletContextRequest.isHead() && this.getServletContextResponse().getStatus() != 304 && this.getServletContextResponse().isContentIncomplete(this._servletContextRequest.getHttpOutput().getWritten()) && this.sendErrorOrAbort("Insufficient content written") || this.checkAndPrepareUpgrade()) break;
                        this.getServletContextResponse().completeOutput(Callback.from((Invocable.InvocationType)Invocable.InvocationType.NON_BLOCKING, () -> this._state.completed(null), this._state::completed));
                        break;
                    }
                    default: {
                        throw new IllegalStateException(this.toString());
                    }
                }
            }
            catch (Throwable failure) {
                if ("org.eclipse.jetty.continuation.ContinuationThrowable".equals(failure.getClass().getName())) {
                    LOG.trace("IGNORED", failure);
                }
                this.handleException(failure);
            }
            action = this._state.unhandle();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("!handle {} {}", (Object)action, (Object)this);
        }
        boolean suspended = action == ServletRequestState.Action.WAIT;
        return !suspended;
    }

    public boolean sendErrorOrAbort(String message) {
        try {
            if (this.isCommitted()) {
                this.abort(new IOException(message));
                return false;
            }
            this.getServletContextResponse().getServletApiResponse().sendError(500, message);
            return true;
        }
        catch (Throwable x) {
            LOG.trace("IGNORED", x);
            this.abort(x);
            return false;
        }
    }

    private void dispatch(Dispatchable dispatchable) throws Exception {
        this._servletContextRequest.getServletContextResponse().getHttpOutput().reopen();
        this.getHttpOutput().reopen();
        dispatchable.dispatch();
    }

    protected void handleException(Throwable failure) {
        Throwable quiet = this.unwrap(failure, QuietException.class);
        Throwable noStack = this.unwrap(failure, BadMessageException.class, IOException.class, TimeoutException.class);
        if (quiet != null || !this.getServer().isRunning()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this._servletContextRequest.getServletApiRequest().getRequestURI(), failure);
            }
        } else if (noStack != null) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("handleException {}", (Object)this._servletContextRequest.getServletApiRequest().getRequestURI(), (Object)failure);
            } else {
                LOG.warn("handleException {} {}", (Object)this._servletContextRequest.getServletApiRequest().getRequestURI(), (Object)noStack.toString());
            }
        } else {
            ServletContextRequest request = this._servletContextRequest;
            LOG.warn(request == null ? "unknown request" : request.getServletApiRequest().getRequestURI(), failure);
        }
        if (this.isCommitted()) {
            this.abort(failure);
        } else {
            try {
                this._state.onError(failure);
            }
            catch (IllegalStateException e) {
                this.abort(failure);
            }
        }
    }

    protected Throwable unwrap(Throwable failure, Class<?> ... targets) {
        while (failure != null) {
            for (Class<?> x : targets) {
                if (!x.isInstance(failure)) continue;
                return failure;
            }
            failure = failure.getCause();
        }
        return null;
    }

    public void sendResponseAndComplete() {
        try {
            this._state.completing();
            this.getServletContextResponse().write(true, this.getServletContextResponse().getHttpOutput().getByteBuffer(), Callback.from(() -> this._state.completed(null), this._state::completed));
        }
        catch (Throwable x) {
            this.abort(x);
        }
    }

    public boolean isExpecting100Continue() {
        return this._expects100Continue;
    }

    public String toString() {
        if (this._servletContextRequest == null) {
            return String.format("%s@%x{null}", this.getClass().getSimpleName(), this.hashCode());
        }
        long timeStamp = Request.getTimeStamp((Request)this._servletContextRequest);
        return String.format("%s@%x{s=%s,r=%s,c=%b/%b,a=%s,uri=%s,age=%d}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state, this._requests, this.isRequestCompleted(), this.isResponseCompleted(), this._state.getState(), this._servletContextRequest.getHttpURI(), timeStamp == 0L ? 0L : System.currentTimeMillis() - timeStamp});
    }

    protected boolean checkAndPrepareUpgrade() {
        return false;
    }

    void onTrailers(HttpFields trailers) {
        this._servletContextRequest.setTrailers(trailers);
    }

    public void onCompleted() {
        ServletApiRequest apiRequest = this._servletContextRequest.getServletApiRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("onCompleted for {} written={}", (Object)apiRequest.getRequestURI(), (Object)this.getBytesWritten());
        }
        if (this.getServer().getRequestLog() instanceof CustomRequestLog) {
            CustomRequestLog.LogDetail logDetail = new CustomRequestLog.LogDetail(this._servletContextRequest.getServletName(), apiRequest.getServletContext().getRealPath(Request.getPathInContext((Request)this._servletContextRequest)));
            this._servletContextRequest.setAttribute(CustomRequestLog.LOG_DETAIL, logDetail);
        }
        Callback callback = this._callback;
        ServletContextRequest servletContextRequest = this._servletContextRequest;
        this.recycle();
        if (this._state.completeResponse()) {
            callback.succeeded();
        }
    }

    public boolean isCommitted() {
        return this._state.isResponseCommitted();
    }

    public boolean isRequestCompleted() {
        return this._state.isCompleted();
    }

    public boolean isResponseCompleted() {
        return this._state.isResponseCompleted();
    }

    protected void execute(Runnable task) {
        this._context.execute(task);
    }

    public void abort(Throwable failure) {
        if (this._state.abortResponse()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("abort {}", (Object)this, (Object)failure);
            }
            this._callback.failed(failure);
        }
    }

    static interface Dispatchable {
        public void dispatch() throws Exception;
    }
}

