/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet.security.authentication;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.Objects;
import org.eclipse.jetty.ee10.servlet.security.Authentication;
import org.eclipse.jetty.ee10.servlet.security.ServerAuthException;
import org.eclipse.jetty.ee10.servlet.security.UserAuthentication;
import org.eclipse.jetty.ee10.servlet.security.UserIdentity;
import org.eclipse.jetty.ee10.servlet.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.ee10.servlet.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SslClientCertAuthenticator
extends LoginAuthenticator {
    private final SslContextFactory sslContextFactory;
    private boolean validateCerts = true;

    public SslClientCertAuthenticator(SslContextFactory sslContextFactory) {
        this.sslContextFactory = Objects.requireNonNull(sslContextFactory);
    }

    @Override
    public String getAuthMethod() {
        return "CLIENT_CERT";
    }

    @Override
    public Authentication validateRequest(Request req, Response res, Callback callback, boolean mandatory) throws ServerAuthException {
        if (!mandatory) {
            return new DeferredAuthentication(this);
        }
        SecureRequestCustomizer.SslSessionData sslSessionData = (SecureRequestCustomizer.SslSessionData)req.getAttribute(SecureRequestCustomizer.DEFAULT_SSL_SESSION_DATA_ATTRIBUTE);
        if (sslSessionData == null) {
            Response.writeError((Request)req, (Response)res, (Callback)callback, (int)403);
            return Authentication.SEND_FAILURE;
        }
        X509Certificate[] certs = sslSessionData.peerCertificates();
        try {
            if (certs != null && certs.length > 0) {
                if (this.validateCerts) {
                    this.sslContextFactory.validateCerts(certs);
                }
                for (X509Certificate cert : certs) {
                    String username;
                    UserIdentity user;
                    if (cert == null) continue;
                    Principal principal = cert.getSubjectDN();
                    if (principal == null) {
                        principal = cert.getIssuerDN();
                    }
                    if ((user = this.login(username = principal == null ? "clientcert" : principal.getName(), "", req)) != null) {
                        return new UserAuthentication(this.getAuthMethod(), user);
                    }
                    user = this.login(username, null, req);
                    if (user != null) {
                        return new UserAuthentication(this.getAuthMethod(), user);
                    }
                    char[] credential = Base64.getEncoder().encodeToString(cert.getSignature()).toCharArray();
                    user = this.login(username, credential, req);
                    if (user == null) continue;
                    return new UserAuthentication(this.getAuthMethod(), user);
                }
            }
            if (!DeferredAuthentication.isDeferred(res)) {
                Response.writeError((Request)req, (Response)res, (Callback)callback, (int)403);
                return Authentication.SEND_FAILURE;
            }
            return Authentication.UNAUTHENTICATED;
        }
        catch (Exception e) {
            throw new ServerAuthException(e.getMessage());
        }
    }

    @Override
    public boolean secureResponse(Request req, Response res, Callback callback, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }

    public boolean isValidateCerts() {
        return this.validateCerts;
    }

    public void setValidateCerts(boolean validateCerts) {
        this.validateCerts = validateCerts;
    }
}

