/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet.security.authentication;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletApiResponse;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.security.Authenticator;
import org.eclipse.jetty.ee10.servlet.security.IdentityService;
import org.eclipse.jetty.ee10.servlet.security.LoginService;
import org.eclipse.jetty.ee10.servlet.security.UserIdentity;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LoginAuthenticator
implements Authenticator {
    private static final Logger LOG = LoggerFactory.getLogger(LoginAuthenticator.class);
    protected LoginService _loginService;
    protected IdentityService _identityService;
    private boolean _renewSession;

    protected LoginAuthenticator() {
    }

    @Override
    public void prepareRequest(Request request) {
    }

    public UserIdentity login(String username, Object password, Request request) {
        ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)request, ServletContextRequest.class);
        ServletApiRequest servletApiRequest = servletContextRequest.getServletApiRequest();
        ServletApiResponse servletApiResponse = servletContextRequest.getResponse().getServletApiResponse();
        UserIdentity user = this._loginService.login(username, password, (ServletRequest)servletApiRequest);
        if (user != null) {
            this.renewSession(servletApiRequest, servletApiResponse);
            return user;
        }
        return null;
    }

    public void logout(Request request) {
        ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)request, ServletContextRequest.class);
        ServletApiRequest servletApiRequest = servletContextRequest.getServletApiRequest();
        HttpSession session = servletApiRequest.getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute("org.eclipse.jetty.security.sessionCreatedSecure");
    }

    @Override
    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        this._loginService = configuration.getLoginService();
        if (this._loginService == null) {
            throw new IllegalStateException("No LoginService for " + String.valueOf(this) + " in " + String.valueOf(configuration));
        }
        this._identityService = configuration.getIdentityService();
        if (this._identityService == null) {
            throw new IllegalStateException("No IdentityService for " + String.valueOf(this) + " in " + String.valueOf(configuration));
        }
        this._renewSession = configuration.isSessionRenewedOnAuthentication();
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpSession renewSession(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        HttpSession httpSession = httpRequest.getSession(false);
        Session session = Session.getSession((Object)httpSession);
        if (this._renewSession && session != null) {
            Session session2 = session;
            synchronized (session2) {
                if (session.getAttribute("org.eclipse.jetty.security.sessionCreatedSecure") != Boolean.TRUE) {
                    session.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", (Object)Boolean.TRUE);
                    ServletContextRequest servletContextRequest = ServletContextRequest.getServletContextRequest((ServletRequest)httpRequest);
                    Response response = servletContextRequest.getResponse().getWrapped();
                    session.renewId((Request)servletContextRequest, response);
                    return httpSession;
                }
            }
        }
        return httpSession;
    }
}

