/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet.security.authentication;

import jakarta.servlet.http.HttpSession;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.security.Authentication;
import org.eclipse.jetty.ee10.servlet.security.Authenticator;
import org.eclipse.jetty.ee10.servlet.security.ServerAuthException;
import org.eclipse.jetty.ee10.servlet.security.UserAuthentication;
import org.eclipse.jetty.ee10.servlet.security.UserIdentity;
import org.eclipse.jetty.ee10.servlet.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.ee10.servlet.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.ee10.servlet.security.authentication.SessionAuthentication;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(FormAuthenticator.class);
    public static final String __FORM_LOGIN_PAGE = "org.eclipse.jetty.security.form_login_page";
    public static final String __FORM_ERROR_PAGE = "org.eclipse.jetty.security.form_error_page";
    public static final String __FORM_DISPATCH = "org.eclipse.jetty.security.dispatch";
    public static final String __J_URI = "org.eclipse.jetty.security.form_URI";
    public static final String __J_POST = "org.eclipse.jetty.security.form_POST";
    public static final String __J_METHOD = "org.eclipse.jetty.security.form_METHOD";
    public static final String __J_SECURITY_CHECK = "/j_security_check";
    public static final String __J_USERNAME = "j_username";
    public static final String __J_PASSWORD = "j_password";
    private String _formErrorPage;
    private String _formErrorPath;
    private String _formLoginPage;
    private String _formLoginPath;
    private boolean _dispatch;
    private boolean _alwaysSaveUri;

    public FormAuthenticator() {
    }

    public FormAuthenticator(String login, String error, boolean dispatch) {
        this();
        if (login != null) {
            this.setLoginPage(login);
        }
        if (error != null) {
            this.setErrorPage(error);
        }
        this._dispatch = dispatch;
    }

    public void setAlwaysSaveUri(boolean alwaysSave) {
        this._alwaysSaveUri = alwaysSave;
    }

    public boolean getAlwaysSaveUri() {
        return this._alwaysSaveUri;
    }

    @Override
    public void setConfiguration(Authenticator.AuthConfiguration configuration) {
        String dispatch;
        String error;
        super.setConfiguration(configuration);
        String login = configuration.getInitParameter(__FORM_LOGIN_PAGE);
        if (login != null) {
            this.setLoginPage(login);
        }
        if ((error = configuration.getInitParameter(__FORM_ERROR_PAGE)) != null) {
            this.setErrorPage(error);
        }
        this._dispatch = (dispatch = configuration.getInitParameter(__FORM_DISPATCH)) == null ? this._dispatch : Boolean.parseBoolean(dispatch);
    }

    @Override
    public String getAuthMethod() {
        return "FORM";
    }

    private void setLoginPage(String path) {
        if (!((String)path).startsWith("/")) {
            LOG.warn("form-login-page must start with /");
            path = "/" + (String)path;
        }
        this._formLoginPage = path;
        this._formLoginPath = path;
        if (this._formLoginPath.indexOf(63) > 0) {
            this._formLoginPath = this._formLoginPath.substring(0, this._formLoginPath.indexOf(63));
        }
    }

    private void setErrorPage(String path) {
        if (path == null || ((String)path).trim().length() == 0) {
            this._formErrorPath = null;
            this._formErrorPage = null;
        } else {
            if (!((String)path).startsWith("/")) {
                LOG.warn("form-error-page must start with /");
                path = "/" + (String)path;
            }
            this._formErrorPage = path;
            this._formErrorPath = path;
            if (this._formErrorPath.indexOf(63) > 0) {
                this._formErrorPath = this._formErrorPath.substring(0, this._formErrorPath.indexOf(63));
            }
        }
    }

    @Override
    public UserIdentity login(String username, Object password, Request request) {
        ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)request, ServletContextRequest.class);
        UserIdentity user = super.login(username, password, request);
        if (user != null) {
            HttpSession session = servletContextRequest.getServletApiRequest().getSession(true);
            SessionAuthentication cached = new SessionAuthentication(this.getAuthMethod(), user, password);
            session.setAttribute("org.eclipse.jetty.security.UserIdentity", (Object)cached);
        }
        return user;
    }

    @Override
    public void logout(Request request) {
        super.logout(request);
        ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)request, ServletContextRequest.class);
        HttpSession session = servletContextRequest.getServletApiRequest().getSession(false);
        if (session == null) {
            return;
        }
        session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
    }

    @Override
    public void prepareRequest(Request request) {
        ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)request, ServletContextRequest.class);
        HttpSession session = servletContextRequest.getServletApiRequest().getSession(false);
        if (session == null || session.getAttribute("org.eclipse.jetty.security.UserIdentity") == null) {
            return;
        }
        HttpURI juri = (HttpURI)session.getAttribute(__J_URI);
        if (juri == null) {
            return;
        }
        String method = (String)session.getAttribute(__J_METHOD);
        if (method == null || method.length() == 0) {
            return;
        }
        if (!juri.equals((Object)request.getHttpURI())) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Restoring original method {} for {} with method {}", new Object[]{method, juri, request.getMethod()});
        }
        servletContextRequest.getServletApiRequest().setMethod(method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Authentication validateRequest(Request req, Response res, Callback callback, boolean mandatory) throws ServerAuthException {
        Authentication authentication;
        ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)req, ServletContextRequest.class);
        ServletApiRequest servletApiRequest = servletContextRequest.getServletApiRequest();
        String pathInContext = servletContextRequest.getPathInContext();
        boolean jSecurityCheck = this.isJSecurityCheck(pathInContext);
        if (!(mandatory |= jSecurityCheck)) {
            return new DeferredAuthentication(this);
        }
        if (this.isLoginOrErrorPage(pathInContext) && !DeferredAuthentication.isDeferred(res)) {
            return new DeferredAuthentication(this);
        }
        if (jSecurityCheck) {
            String username = servletApiRequest.getParameter(__J_USERNAME);
            String password = servletApiRequest.getParameter(__J_PASSWORD);
            UserIdentity user = this.login(username, password, req);
            LOG.debug("jsecuritycheck {} {}", (Object)username, (Object)user);
            HttpSession session = servletApiRequest.getSession(false);
            if (user != null) {
                FormAuthentication formAuth;
                String nuri;
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    HttpURI savedURI = (HttpURI)session.getAttribute(__J_URI);
                    if (savedURI == null) {
                        nuri = servletApiRequest.getContextPath();
                        if (nuri.length() == 0) {
                            nuri = "/";
                        }
                    } else {
                        nuri = savedURI.asString();
                    }
                    formAuth = new FormAuthentication(this.getAuthMethod(), user);
                }
                LOG.debug("authenticated {}->{}", (Object)formAuth, (Object)nuri);
                res.getHeaders().putLongField(HttpHeader.CONTENT_LENGTH, 0L);
                Response.sendRedirect((Request)req, (Response)res, (Callback)callback, (int)302, (String)servletContextRequest.getHttpServletResponse().encodeRedirectURL(nuri), (boolean)true);
                return formAuth;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Form authentication FAILED for {}", (Object)StringUtil.printable((String)username));
            }
            if (this._formErrorPage == null) {
                LOG.debug("auth failed {}->403", (Object)username);
                Response.writeError((Request)req, (Response)res, (Callback)callback, (int)403);
            } else {
                LOG.debug("auth failed {}->{}", (Object)username, (Object)this._formErrorPage);
                Response.sendRedirect((Request)req, (Response)res, (Callback)callback, (int)302, (String)servletContextRequest.getHttpServletResponse().encodeRedirectURL(URIUtil.addPaths((String)req.getContext().getContextPath(), (String)this._formErrorPage)), (boolean)true);
            }
            return Authentication.SEND_FAILURE;
        }
        HttpSession session = servletApiRequest.getSession(false);
        Authentication authentication2 = authentication = session == null ? null : (Authentication)session.getAttribute("org.eclipse.jetty.security.UserIdentity");
        if (authentication != null) {
            if (authentication instanceof Authentication.User && this._loginService != null && !this._loginService.validate(((Authentication.User)authentication).getUserIdentity())) {
                LOG.debug("auth revoked {}", (Object)authentication);
                session.removeAttribute("org.eclipse.jetty.security.UserIdentity");
            } else {
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    HttpURI jUri = (HttpURI)session.getAttribute(__J_URI);
                    if (jUri != null) {
                        LOG.debug("auth retry {}->{}", (Object)authentication, (Object)jUri);
                        if (jUri.equals((Object)req.getHttpURI())) {
                            Fields jPost = (Fields)session.getAttribute(__J_POST);
                            if (jPost != null) {
                                LOG.debug("auth rePOST {}->{}", (Object)authentication, (Object)jUri);
                                servletApiRequest.setContentParameters(jPost);
                            }
                            session.removeAttribute(__J_URI);
                            session.removeAttribute(__J_METHOD);
                            session.removeAttribute(__J_POST);
                        }
                    }
                }
                LOG.debug("auth {}", (Object)authentication);
                return authentication;
            }
        }
        if (DeferredAuthentication.isDeferred(res)) {
            LOG.debug("auth deferred {}", (Object)(session == null ? null : session.getId()));
            return Authentication.UNAUTHENTICATED;
        }
        HttpSession httpSession = session = session != null ? session : servletApiRequest.getSession(true);
        synchronized (httpSession) {
            if (session.getAttribute(__J_URI) == null || this._alwaysSaveUri) {
                session.setAttribute(__J_URI, (Object)req.getHttpURI());
                session.setAttribute(__J_METHOD, (Object)req.getMethod());
                if (MimeTypes.Type.FORM_ENCODED.is(servletApiRequest.getContentType()) && HttpMethod.POST.is(req.getMethod())) {
                    session.setAttribute(__J_POST, (Object)servletApiRequest.getContentParameters());
                }
            }
        }
        LOG.debug("challenge {}->{}", (Object)session.getId(), (Object)this._formLoginPage);
        Response.sendRedirect((Request)req, (Response)res, (Callback)callback, (int)302, (String)servletContextRequest.getHttpServletResponse().encodeRedirectURL(URIUtil.addPaths((String)req.getContext().getContextPath(), (String)this._formLoginPage)), (boolean)true);
        return Authentication.SEND_CONTINUE;
    }

    public boolean isJSecurityCheck(String uri) {
        int jsc = uri.indexOf(__J_SECURITY_CHECK);
        if (jsc < 0) {
            return false;
        }
        int e = jsc + __J_SECURITY_CHECK.length();
        if (e == uri.length()) {
            return true;
        }
        char c = uri.charAt(e);
        return c == ';' || c == '#' || c == '/' || c == '?';
    }

    public boolean isLoginOrErrorPage(String pathInContext) {
        return pathInContext != null && (pathInContext.equals(this._formErrorPath) || pathInContext.equals(this._formLoginPath));
    }

    @Override
    public boolean secureResponse(Request req, Response res, Callback callback, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }

    public static class FormAuthentication
    extends UserAuthentication
    implements Authentication.ResponseSent {
        public FormAuthentication(String method, UserIdentity userIdentity) {
            super(method, userIdentity);
        }

        @Override
        public String toString() {
            return "Form" + super.toString();
        }
    }
}

