/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet.security.authentication;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.eclipse.jetty.ee10.servlet.security.Authentication;
import org.eclipse.jetty.ee10.servlet.security.IdentityService;
import org.eclipse.jetty.ee10.servlet.security.LoggedOutAuthentication;
import org.eclipse.jetty.ee10.servlet.security.LoginService;
import org.eclipse.jetty.ee10.servlet.security.SecurityHandler;
import org.eclipse.jetty.ee10.servlet.security.ServerAuthException;
import org.eclipse.jetty.ee10.servlet.security.UserAuthentication;
import org.eclipse.jetty.ee10.servlet.security.UserIdentity;
import org.eclipse.jetty.ee10.servlet.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeferredAuthentication
implements Authentication.Deferred {
    private static final Logger LOG = LoggerFactory.getLogger(DeferredAuthentication.class);
    protected final LoginAuthenticator _authenticator;
    private Object _previousAssociation;
    private static final Response __deferredResponse = new Response(){

        public Request getRequest() {
            return null;
        }

        public int getStatus() {
            return 0;
        }

        public void setStatus(int code) {
        }

        public HttpFields.Mutable getHeaders() {
            return null;
        }

        public Supplier<HttpFields> getTrailersSupplier() {
            return null;
        }

        public void setTrailersSupplier(Supplier<HttpFields> trailers) {
        }

        public void write(boolean last, ByteBuffer content, Callback callback) {
            callback.succeeded();
        }

        public boolean isCommitted() {
            return false;
        }

        public boolean isCompletedSuccessfully() {
            return false;
        }

        public void reset() {
        }

        public CompletableFuture<Void> writeInterim(int status, HttpFields headers) {
            return null;
        }
    };

    public DeferredAuthentication(LoginAuthenticator authenticator) {
        if (authenticator == null) {
            throw new NullPointerException("No Authenticator");
        }
        this._authenticator = authenticator;
    }

    @Override
    public Authentication authenticate(Request request) {
        try {
            Authentication authentication = this._authenticator.validateRequest(request, __deferredResponse, null, true);
            if (authentication != null && authentication instanceof Authentication.User && !(authentication instanceof Authentication.ResponseSent)) {
                LoginService loginService = this._authenticator.getLoginService();
                IdentityService identityService = loginService.getIdentityService();
                if (identityService != null) {
                    this._previousAssociation = identityService.associate(((Authentication.User)authentication).getUserIdentity());
                }
                return authentication;
            }
        }
        catch (ServerAuthException e) {
            LOG.debug("Unable to authenticate {}", (Object)request, (Object)e);
        }
        return this;
    }

    @Override
    public Authentication authenticate(Request request, Response response, Callback callback) {
        try {
            LoginService loginService = this._authenticator.getLoginService();
            IdentityService identityService = loginService.getIdentityService();
            Authentication authentication = this._authenticator.validateRequest(request, response, callback, true);
            if (authentication instanceof Authentication.User && identityService != null) {
                this._previousAssociation = identityService.associate(((Authentication.User)authentication).getUserIdentity());
            }
            return authentication;
        }
        catch (ServerAuthException e) {
            LOG.debug("Unable to authenticate {}", (Object)request, (Object)e);
            return this;
        }
    }

    @Override
    public Authentication login(String username, Object password, Request request) {
        if (username == null) {
            return null;
        }
        UserIdentity identity = this._authenticator.login(username, password, request);
        if (identity != null) {
            IdentityService identityService = this._authenticator.getLoginService().getIdentityService();
            UserAuthentication authentication = new UserAuthentication("API", identity);
            if (identityService != null) {
                this._previousAssociation = identityService.associate(identity);
            }
            return authentication;
        }
        return null;
    }

    @Override
    public Authentication logout(Request request) {
        SecurityHandler security = SecurityHandler.getCurrentSecurityHandler();
        if (security != null) {
            security.logout(null);
            this._authenticator.logout(request);
            return new LoggedOutAuthentication(this._authenticator);
        }
        return Authentication.UNAUTHENTICATED;
    }

    public Object getPreviousAssociation() {
        return this._previousAssociation;
    }

    public static boolean isDeferred(Response response) {
        return response == __deferredResponse;
    }
}

