/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet.security.authentication;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.security.Authentication;
import org.eclipse.jetty.ee10.servlet.security.ServerAuthException;
import org.eclipse.jetty.ee10.servlet.security.SpnegoUserIdentity;
import org.eclipse.jetty.ee10.servlet.security.SpnegoUserPrincipal;
import org.eclipse.jetty.ee10.servlet.security.UserAuthentication;
import org.eclipse.jetty.ee10.servlet.security.UserIdentity;
import org.eclipse.jetty.ee10.servlet.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.ee10.servlet.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableSpnegoAuthenticator
extends LoginAuthenticator {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableSpnegoAuthenticator.class);
    private final String _authMethod;
    private Duration _authenticationDuration = Duration.ofNanos(-1L);

    public ConfigurableSpnegoAuthenticator() {
        this("SPNEGO");
    }

    public ConfigurableSpnegoAuthenticator(String authMethod) {
        this._authMethod = authMethod;
    }

    @Override
    public String getAuthMethod() {
        return this._authMethod;
    }

    public Duration getAuthenticationDuration() {
        return this._authenticationDuration;
    }

    public void setAuthenticationDuration(Duration authenticationDuration) {
        this._authenticationDuration = authenticationDuration;
    }

    @Override
    public UserIdentity login(String username, Object password, Request request) {
        ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)request, ServletContextRequest.class);
        SpnegoUserIdentity user = (SpnegoUserIdentity)this._loginService.login(username, password, (ServletRequest)servletContextRequest.getServletApiRequest());
        if (user != null && user.isEstablished()) {
            this.renewSession(servletContextRequest.getServletApiRequest(), servletContextRequest.getResponse().getServletApiResponse());
        }
        return user;
    }

    @Override
    public Authentication validateRequest(Request req, Response res, Callback callback, boolean mandatory) throws ServerAuthException {
        Duration authnDuration;
        UserIdentity identity;
        UserIdentityHolder holder;
        if (!mandatory) {
            return new DeferredAuthentication(this);
        }
        ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)req, ServletContextRequest.class);
        String header = req.getHeaders().get(HttpHeader.AUTHORIZATION);
        String spnegoToken = this.getSpnegoToken(header);
        HttpSession httpSession = servletContextRequest.getServletApiRequest().getSession(false);
        if (header != null && spnegoToken != null) {
            SpnegoUserIdentity identity2 = (SpnegoUserIdentity)this.login(null, spnegoToken, req);
            if (identity2.isEstablished()) {
                Duration authnDuration2;
                if (!DeferredAuthentication.isDeferred(res)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Sending final token");
                    }
                    SpnegoUserPrincipal principal = (SpnegoUserPrincipal)identity2.getUserPrincipal();
                    this.setSpnegoToken(res, principal.getEncodedToken());
                }
                if (!(authnDuration2 = this.getAuthenticationDuration()).isNegative()) {
                    if (httpSession == null) {
                        httpSession = servletContextRequest.getServletApiRequest().getSession(true);
                    }
                    httpSession.setAttribute(UserIdentityHolder.ATTRIBUTE, (Object)new UserIdentityHolder(identity2));
                }
                return new UserAuthentication(this.getAuthMethod(), identity2);
            }
            if (DeferredAuthentication.isDeferred(res)) {
                return Authentication.UNAUTHENTICATED;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending intermediate challenge");
            }
            SpnegoUserPrincipal principal = (SpnegoUserPrincipal)identity2.getUserPrincipal();
            this.sendChallenge(req, res, callback, principal.getEncodedToken());
            return Authentication.SEND_CONTINUE;
        }
        if (httpSession != null && (holder = (UserIdentityHolder)httpSession.getAttribute(UserIdentityHolder.ATTRIBUTE)) != null && (identity = holder._userIdentity) != null && !(authnDuration = this.getAuthenticationDuration()).isNegative()) {
            boolean expired;
            boolean bl = expired = !authnDuration.isZero() && Instant.now().isAfter(holder._validFrom.plus(authnDuration));
            if (!expired || !HttpMethod.GET.is(req.getMethod())) {
                return new UserAuthentication(this.getAuthMethod(), identity);
            }
        }
        if (DeferredAuthentication.isDeferred(res)) {
            return Authentication.UNAUTHENTICATED;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending initial challenge");
        }
        this.sendChallenge(req, res, callback, null);
        return Authentication.SEND_CONTINUE;
    }

    private void sendChallenge(Request req, Response res, Callback callback, String token) throws ServerAuthException {
        this.setSpnegoToken(res, token);
        Response.writeError((Request)req, (Response)res, (Callback)callback, (int)401);
    }

    private void setSpnegoToken(Response response, String token) {
        Object value = HttpHeader.NEGOTIATE.asString();
        if (token != null) {
            value = (String)value + " " + token;
        }
        response.getHeaders().put(HttpHeader.WWW_AUTHENTICATE.asString(), (String)value);
    }

    private String getSpnegoToken(String header) {
        if (header == null) {
            return null;
        }
        String scheme = HttpHeader.NEGOTIATE.asString() + " ";
        if (header.regionMatches(true, 0, scheme, 0, scheme.length())) {
            return header.substring(scheme.length()).trim();
        }
        return null;
    }

    @Override
    public boolean secureResponse(Request request, Response response, Callback callback, boolean mandatory, Authentication.User validatedUser) {
        return true;
    }

    private static class UserIdentityHolder
    implements Serializable {
        private static final String ATTRIBUTE = UserIdentityHolder.class.getName();
        private final transient Instant _validFrom = Instant.now();
        private final transient UserIdentity _userIdentity;

        private UserIdentityHolder(UserIdentity userIdentity) {
            this._userIdentity = userIdentity;
        }
    }
}

