/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet.security.authentication;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.eclipse.jetty.ee10.servlet.security.Authentication;
import org.eclipse.jetty.ee10.servlet.security.ServerAuthException;
import org.eclipse.jetty.ee10.servlet.security.UserAuthentication;
import org.eclipse.jetty.ee10.servlet.security.UserIdentity;
import org.eclipse.jetty.ee10.servlet.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.ee10.servlet.security.authentication.LoginAuthenticator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class BasicAuthenticator
extends LoginAuthenticator {
    private Charset _charset;

    public Charset getCharset() {
        return this._charset;
    }

    public void setCharset(Charset charset) {
        this._charset = charset;
    }

    @Override
    public String getAuthMethod() {
        return "BASIC";
    }

    @Override
    public Authentication validateRequest(Request req, Response res, Callback callback, boolean mandatory) throws ServerAuthException {
        String method;
        int space;
        String credentials = req.getHeaders().get(HttpHeader.AUTHORIZATION);
        if (!mandatory) {
            return new DeferredAuthentication(this);
        }
        if (credentials != null && (space = credentials.indexOf(32)) > 0 && "basic".equalsIgnoreCase(method = credentials.substring(0, space))) {
            String password;
            String username;
            UserIdentity user;
            int i;
            credentials = credentials.substring(space + 1);
            Charset charset = this.getCharset();
            if (charset == null) {
                charset = StandardCharsets.ISO_8859_1;
            }
            if ((i = (credentials = new String(Base64.getDecoder().decode(credentials), charset)).indexOf(58)) > 0 && (user = this.login(username = credentials.substring(0, i), password = credentials.substring(i + 1), req)) != null) {
                return new UserAuthentication(this.getAuthMethod(), user);
            }
        }
        if (DeferredAuthentication.isDeferred(res)) {
            return Authentication.UNAUTHENTICATED;
        }
        String value = "basic realm=\"" + this._loginService.getName() + "\"";
        Charset charset = this.getCharset();
        if (charset != null) {
            value = value + ", charset=\"" + charset.name() + "\"";
        }
        res.getHeaders().put(HttpHeader.WWW_AUTHENTICATE.asString(), value);
        Response.writeError((Request)req, (Response)res, (Callback)callback, (int)401);
        return Authentication.SEND_CONTINUE;
    }

    @Override
    public boolean secureResponse(Request req, Response res, Callback callback, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }
}

