/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet.security;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.security.Authentication;
import org.eclipse.jetty.ee10.servlet.security.Authenticator;
import org.eclipse.jetty.ee10.servlet.security.DefaultAuthenticatorFactory;
import org.eclipse.jetty.ee10.servlet.security.DefaultIdentityService;
import org.eclipse.jetty.ee10.servlet.security.IdentityService;
import org.eclipse.jetty.ee10.servlet.security.LoginService;
import org.eclipse.jetty.ee10.servlet.security.RoleInfo;
import org.eclipse.jetty.ee10.servlet.security.ServerAuthException;
import org.eclipse.jetty.ee10.servlet.security.UserIdentity;
import org.eclipse.jetty.ee10.servlet.security.authentication.DeferredAuthentication;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecurityHandler
extends Handler.Wrapper
implements Authenticator.AuthConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityHandler.class);
    private static final List<Authenticator.Factory> __knownAuthenticatorFactories = new ArrayList<Authenticator.Factory>();
    private boolean _checkWelcomeFiles = false;
    private Authenticator _authenticator;
    private Authenticator.Factory _authenticatorFactory;
    private String _realmName;
    private String _authMethod;
    private final Map<String, String> _initParameters = new HashMap<String, String>();
    private LoginService _loginService;
    private IdentityService _identityService;
    private boolean _renewSession = true;
    public static final Principal __NO_USER;
    public static final Principal __NOBODY;

    protected SecurityHandler() {
        this.addBean(new DumpableCollection("knownAuthenticatorFactories", __knownAuthenticatorFactories));
    }

    @Override
    public IdentityService getIdentityService() {
        return this._identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this.updateBean(this._identityService, identityService);
        this._identityService = identityService;
    }

    @Override
    public LoginService getLoginService() {
        return this._loginService;
    }

    public void setLoginService(LoginService loginService) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this.updateBean(this._loginService, loginService);
        this._loginService = loginService;
    }

    public Authenticator getAuthenticator() {
        return this._authenticator;
    }

    public void setAuthenticator(Authenticator authenticator) {
        if (this.isStarted()) {
            throw new IllegalStateException("Started");
        }
        this.updateBean(this._authenticator, authenticator);
        this._authenticator = authenticator;
        if (this._authenticator != null) {
            this._authMethod = this._authenticator.getAuthMethod();
        }
    }

    public Authenticator.Factory getAuthenticatorFactory() {
        return this._authenticatorFactory;
    }

    public void setAuthenticatorFactory(Authenticator.Factory authenticatorFactory) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this.updateBean(this._authenticatorFactory, authenticatorFactory);
        this._authenticatorFactory = authenticatorFactory;
    }

    public List<Authenticator.Factory> getKnownAuthenticatorFactories() {
        return __knownAuthenticatorFactories;
    }

    @Override
    public String getRealmName() {
        return this._realmName;
    }

    public void setRealmName(String realmName) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._realmName = realmName;
    }

    @Override
    public String getAuthMethod() {
        return this._authMethod;
    }

    public void setAuthMethod(String authMethod) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._authMethod = authMethod;
    }

    public boolean isCheckWelcomeFiles() {
        return this._checkWelcomeFiles;
    }

    public void setCheckWelcomeFiles(boolean authenticateWelcomeFiles) {
        if (this.isRunning()) {
            throw new IllegalStateException("running");
        }
        this._checkWelcomeFiles = authenticateWelcomeFiles;
    }

    @Override
    public String getInitParameter(String key) {
        return this._initParameters.get(key);
    }

    @Override
    public Set<String> getInitParameterNames() {
        return this._initParameters.keySet();
    }

    public String setInitParameter(String key, String value) {
        if (this.isStarted()) {
            throw new IllegalStateException("started");
        }
        return this._initParameters.put(key, value);
    }

    protected LoginService findLoginService() throws Exception {
        Collection list = this.getServer().getBeans(LoginService.class);
        LoginService service = null;
        String realm = this.getRealmName();
        if (realm != null) {
            for (LoginService s : list) {
                if (s.getName() == null || !s.getName().equals(realm)) continue;
                service = s;
                break;
            }
        } else if (list.size() == 1) {
            service = (LoginService)list.iterator().next();
        }
        return service;
    }

    protected IdentityService findIdentityService() {
        return (IdentityService)this.getServer().getBean(IdentityService.class);
    }

    protected void doStart() throws Exception {
        block19: {
            ServletContext context;
            block20: {
                context = ServletContextHandler.getCurrentServletContext();
                if (context != null) {
                    Enumeration names = context.getInitParameterNames();
                    while (names != null && names.hasMoreElements()) {
                        String name = (String)names.nextElement();
                        if (!name.startsWith("org.eclipse.jetty.security.") || this.getInitParameter(name) != null) continue;
                        this.setInitParameter(name, context.getInitParameter(name));
                    }
                }
                if (this._loginService == null) {
                    this.setLoginService(this.findLoginService());
                    if (this._loginService != null) {
                        this.unmanage(this._loginService);
                    }
                }
                if (this._identityService == null) {
                    if (this._loginService != null) {
                        this.setIdentityService(this._loginService.getIdentityService());
                    }
                    if (this._identityService == null) {
                        this.setIdentityService(this.findIdentityService());
                    }
                    if (this._identityService == null) {
                        this.setIdentityService(new DefaultIdentityService());
                        this.manage(this._identityService);
                    } else {
                        this.unmanage(this._identityService);
                    }
                }
                if (this._loginService != null) {
                    if (this._loginService.getIdentityService() == null) {
                        this._loginService.setIdentityService(this._identityService);
                    } else if (this._loginService.getIdentityService() != this._identityService) {
                        throw new IllegalStateException("LoginService has different IdentityService to " + String.valueOf(this));
                    }
                }
                if (this._authenticator != null) break block19;
                if (this._authenticatorFactory == null) break block20;
                Authenticator authenticator = this._authenticatorFactory.getAuthenticator(this.getServer(), context, this, this._identityService, this._loginService);
                if (authenticator == null) break block19;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Created authenticator {} with {}", (Object)authenticator, (Object)this._authenticatorFactory);
                }
                this.setAuthenticator(authenticator);
                break block19;
            }
            for (Authenticator.Factory factory : this.getKnownAuthenticatorFactories()) {
                Authenticator authenticator = factory.getAuthenticator(this.getServer(), context, this, this._identityService, this._loginService);
                if (authenticator == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Created authenticator {} with {}", (Object)authenticator, (Object)factory);
                }
                this.setAuthenticator(authenticator);
                break;
            }
        }
        if (this._authenticator != null) {
            this._authenticator.setConfiguration(this);
        } else if (this._realmName != null) {
            LOG.warn("No Authenticator for {}", (Object)this);
            throw new IllegalStateException("No Authenticator");
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (!this.isManaged(this._identityService)) {
            this.removeBean(this._identityService);
            this._identityService = null;
        }
        if (!this.isManaged(this._loginService)) {
            this.removeBean(this._loginService);
            this._loginService = null;
        }
        super.doStop();
    }

    protected boolean checkSecurity(ServletRequest request) {
        switch (request.getDispatcherType()) {
            case REQUEST: 
            case ASYNC: {
                return true;
            }
            case FORWARD: {
                if (this.isCheckWelcomeFiles() && request.getAttribute("org.eclipse.jetty.server.welcome") != null) {
                    request.removeAttribute("org.eclipse.jetty.server.welcome");
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isSessionRenewedOnAuthentication() {
        return this._renewSession;
    }

    public void setSessionRenewedOnAuthentication(boolean renew) {
        this._renewSession = renew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        boolean bl;
        Object previousIdentity;
        block37: {
            boolean deferred2;
            block36: {
                boolean bl2;
                block35: {
                    boolean bl3;
                    block33: {
                        Handler next = this.getHandler();
                        if (next == null) {
                            return false;
                        }
                        ServletContextRequest servletContextRequest = (ServletContextRequest)Request.as((Request)request, ServletContextRequest.class);
                        if (servletContextRequest == null) {
                            return false;
                        }
                        ServletApiRequest servletApiRequest = servletContextRequest.getServletApiRequest();
                        Authenticator authenticator = this._authenticator;
                        if (!this.checkSecurity((ServletRequest)servletApiRequest)) {
                            return next.handle(request, response, callback);
                        }
                        if (authenticator != null) {
                            authenticator.prepareRequest(request);
                        }
                        RoleInfo roleInfo = this.prepareConstraintInfo(servletContextRequest.getPathInContext(), servletApiRequest);
                        if (!this.checkUserDataPermissions(servletContextRequest.getPathInContext(), (Request)servletContextRequest, response, callback, roleInfo)) {
                            return true;
                        }
                        boolean isAuthMandatory = this.isAuthMandatory(request, response, roleInfo);
                        if (isAuthMandatory && authenticator == null) {
                            LOG.warn("No authenticator for: {}", (Object)roleInfo);
                            Response.writeError((Request)request, (Response)response, (Callback)callback, (int)403);
                            return true;
                        }
                        previousIdentity = null;
                        try {
                            boolean processed;
                            Authentication authentication = servletApiRequest.getAuthentication();
                            if (authentication == null || authentication == Authentication.NOT_CHECKED) {
                                Authentication authentication2 = authentication = authenticator == null ? Authentication.UNAUTHENTICATED : authenticator.validateRequest(request, response, callback, isAuthMandatory);
                            }
                            if (authentication instanceof Authentication.ResponseSent) {
                                boolean bl4 = true;
                                return bl4;
                            }
                            if (authentication instanceof Authentication.User) {
                                boolean authorized;
                                Authentication.User userAuth = (Authentication.User)authentication;
                                servletApiRequest.setAuthentication(authentication);
                                if (this._identityService != null) {
                                    previousIdentity = this._identityService.associate(userAuth.getUserIdentity());
                                }
                                if (isAuthMandatory && !(authorized = this.checkWebResourcePermissions(Request.getPathInContext((Request)request), request, response, roleInfo, userAuth.getUserIdentity()))) {
                                    Response.writeError((Request)request, (Response)response, (Callback)callback, (int)403, (String)"!role");
                                    boolean bl5 = true;
                                    if (this._identityService == null) return bl5;
                                    this._identityService.disassociate(previousIdentity);
                                    return bl5;
                                }
                                boolean processed2 = next.handle(request, response, callback);
                                if (processed2 && authenticator != null) {
                                    authenticator.secureResponse(request, response, callback, isAuthMandatory, userAuth);
                                }
                                bl3 = processed2;
                                if (this._identityService == null) return bl3;
                                break block33;
                            }
                            if (authentication instanceof Authentication.Deferred) {
                                DeferredAuthentication deferred2 = (DeferredAuthentication)authentication;
                                servletApiRequest.setAuthentication(authentication);
                                boolean processed3 = false;
                                try {
                                    processed3 = next.handle(request, response, callback);
                                }
                                finally {
                                    previousIdentity = deferred2.getPreviousAssociation();
                                }
                                if (processed3 && authenticator != null) {
                                    Authentication auth = servletApiRequest.getAuthentication();
                                    if (auth instanceof Authentication.User) {
                                        Authentication.User userAuth = (Authentication.User)auth;
                                        authenticator.secureResponse(request, response, callback, isAuthMandatory, userAuth);
                                    } else {
                                        authenticator.secureResponse(request, response, callback, isAuthMandatory, null);
                                    }
                                }
                                bl2 = processed3;
                                if (this._identityService == null) return bl2;
                                break block35;
                            }
                            if (isAuthMandatory) {
                                Response.writeError((Request)request, (Response)response, (Callback)callback, (int)401, (String)"unauthenticated");
                                deferred2 = true;
                                if (this._identityService == null) return deferred2;
                                break block36;
                            }
                            servletApiRequest.setAuthentication(authentication);
                            if (this._identityService != null) {
                                previousIdentity = this._identityService.associate(null);
                            }
                            if ((processed = next.handle(request, response, callback)) && authenticator != null) {
                                authenticator.secureResponse(request, response, callback, isAuthMandatory, null);
                            }
                            bl = processed;
                            if (this._identityService == null) return bl;
                            break block37;
                        }
                        catch (ServerAuthException e) {
                            Response.writeError((Request)request, (Response)response, (Callback)callback, (int)500, (String)e.getMessage());
                            boolean bl6 = true;
                            return bl6;
                        }
                    }
                    this._identityService.disassociate(previousIdentity);
                    return bl3;
                }
                this._identityService.disassociate(previousIdentity);
                return bl2;
            }
            this._identityService.disassociate(previousIdentity);
            return deferred2;
        }
        this._identityService.disassociate(previousIdentity);
        return bl;
        finally {
            if (this._identityService != null) {
                this._identityService.disassociate(previousIdentity);
            }
        }
    }

    public static SecurityHandler getCurrentSecurityHandler() {
        ServletContextHandler contextHandler = ServletContextHandler.getCurrentServletContextHandler();
        if (contextHandler == null) {
            return null;
        }
        return (SecurityHandler)contextHandler.getDescendant(SecurityHandler.class);
    }

    public void logout(Authentication.User user) {
        IdentityService identityService;
        LOG.debug("logout {}", (Object)user);
        if (user == null) {
            return;
        }
        LoginService loginService = this.getLoginService();
        if (loginService != null) {
            loginService.logout(user.getUserIdentity());
        }
        if ((identityService = this.getIdentityService()) != null) {
            Object previous = null;
            identityService.disassociate(previous);
        }
    }

    protected abstract RoleInfo prepareConstraintInfo(String var1, HttpServletRequest var2);

    protected abstract boolean checkUserDataPermissions(String var1, Request var2, Response var3, Callback var4, RoleInfo var5) throws IOException;

    protected abstract boolean isAuthMandatory(Request var1, Response var2, Object var3);

    protected abstract boolean checkWebResourcePermissions(String var1, Request var2, Response var3, Object var4, UserIdentity var5) throws IOException;

    static {
        TypeUtil.serviceStream(ServiceLoader.load(Authenticator.Factory.class)).forEach(__knownAuthenticatorFactories::add);
        __knownAuthenticatorFactories.add(new DefaultAuthenticatorFactory());
        __NO_USER = new Principal(){

            @Override
            public String getName() {
                return null;
            }

            @Override
            public String toString() {
                return "No User";
            }
        };
        __NOBODY = new Principal(){

            @Override
            public String getName() {
                return "Nobody";
            }

            @Override
            public String toString() {
                return this.getName();
            }
        };
    }

    public class NotChecked
    implements Principal {
        @Override
        public String getName() {
            return null;
        }

        @Override
        public String toString() {
            return "NOT CHECKED";
        }

        public SecurityHandler getSecurityHandler() {
            return SecurityHandler.this;
        }
    }
}

