/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet.security;

import org.eclipse.jetty.ee10.servlet.QuietServletException;
import org.eclipse.jetty.ee10.servlet.security.UserIdentity;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public interface Authentication {
    public static final Authentication UNAUTHENTICATED = new Authentication(){

        public String toString() {
            return "UNAUTHENTICATED";
        }
    };
    public static final Authentication NOT_CHECKED = new Authentication(){

        public String toString() {
            return "NOT CHECKED";
        }
    };
    public static final Authentication SEND_CONTINUE = new Challenge(){

        public String toString() {
            return "CHALLENGE";
        }
    };
    public static final Authentication SEND_FAILURE = new Failure(){

        public String toString() {
            return "FAILURE";
        }
    };
    public static final Authentication SEND_SUCCESS = new SendSuccess(){

        public String toString() {
            return "SEND_SUCCESS";
        }
    };

    public static interface NonAuthenticated
    extends LoginAuthentication {
    }

    public static interface SendSuccess
    extends ResponseSent {
    }

    public static interface Failure
    extends ResponseSent {
    }

    public static interface Challenge
    extends ResponseSent {
    }

    public static interface ResponseSent
    extends Authentication {
    }

    public static interface Deferred
    extends LoginAuthentication,
    LogoutAuthentication {
        public Authentication authenticate(Request var1);

        public Authentication authenticate(Request var1, Response var2, Callback var3);
    }

    public static interface LogoutAuthentication
    extends Authentication {
        public Authentication logout(Request var1);
    }

    public static interface LoginAuthentication
    extends Authentication {
        public Authentication login(String var1, Object var2, Request var3);
    }

    public static interface User
    extends LogoutAuthentication {
        public String getAuthMethod();

        public UserIdentity getUserIdentity();

        public boolean isUserInRole(String var1);
    }

    public static class Failed
    extends QuietServletException {
        public Failed(String message) {
            super(message);
        }
    }
}

