/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.Part;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MultiPart;
import org.eclipse.jetty.http.MultiPartFormData;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;

public class ServletMultiPartFormData {
    public static Parts from(ServletApiRequest request) throws IOException {
        return ServletMultiPartFormData.from(request, 1000);
    }

    public static Parts from(ServletApiRequest request, int maxParts) throws IOException {
        try {
            MultiPartFormData.Parts parts = (MultiPartFormData.Parts)request.getAttribute(MultiPartFormData.Parts.class.getName());
            if (parts != null) {
                return new Parts(parts);
            }
            return new ServletMultiPartFormData().parse(request, maxParts);
        }
        catch (Throwable x) {
            throw IO.rethrow((Throwable)x);
        }
    }

    private Parts parse(ServletApiRequest request, int maxParts) throws IOException {
        int n;
        String fileLocation;
        MultipartConfigElement config = (MultipartConfigElement)request.getAttribute("org.eclipse.jetty.multipartConfig");
        if (config == null) {
            throw new IllegalStateException("No multipart configuration element");
        }
        String boundary = MultiPart.extractBoundary((String)request.getContentType());
        if (boundary == null) {
            throw new IllegalStateException("No multipart boundary parameter in Content-Type");
        }
        MultiPartFormData formData = new MultiPartFormData(boundary);
        formData.setMaxParts((long)maxParts);
        File tmpDirFile = (File)request.getServletContext().getAttribute("jakarta.servlet.context.tempdir");
        if (tmpDirFile == null) {
            tmpDirFile = new File(System.getProperty("java.io.tmpdir"));
        }
        if (!StringUtil.isBlank((String)(fileLocation = config.getLocation()))) {
            tmpDirFile = new File(fileLocation);
        }
        formData.setFilesDirectory(tmpDirFile.toPath());
        formData.setMaxMemoryFileSize((long)config.getFileSizeThreshold());
        formData.setMaxFileSize(config.getMaxFileSize());
        formData.setMaxLength(config.getMaxRequestSize());
        ConnectionMetaData connectionMetaData = request.getServletContextRequest().getConnectionMetaData();
        formData.setPartHeadersMaxLength(connectionMetaData.getHttpConfiguration().getRequestHeaderSize());
        ByteBufferPool byteBufferPool = request.getServletContextRequest().getComponents().getByteBufferPool();
        Connection connection = connectionMetaData.getConnection();
        if (connection instanceof AbstractConnection) {
            AbstractConnection c = (AbstractConnection)connection;
            n = c.getInputBufferSize();
        } else {
            n = 2048;
        }
        int bufferSize = n;
        ServletInputStream input = request.getInputStream();
        while (!formData.isDone()) {
            RetainableByteBuffer retainable = byteBufferPool.acquire(bufferSize, false);
            boolean readEof = false;
            ByteBuffer buffer = retainable.getByteBuffer();
            while (BufferUtil.space((ByteBuffer)buffer) > bufferSize / 2) {
                int read = BufferUtil.readFrom((InputStream)input, (ByteBuffer)buffer);
                if (read >= 0) continue;
                readEof = true;
                break;
            }
            formData.parse(Content.Chunk.from((ByteBuffer)buffer, (boolean)false, () -> ((RetainableByteBuffer)retainable).release()));
            if (!readEof) continue;
            formData.parse(Content.Chunk.EOF);
            break;
        }
        Parts parts = new Parts((MultiPartFormData.Parts)formData.join());
        request.setAttribute(Parts.class.getName(), parts);
        return parts;
    }

    public static class Parts {
        private final List<Part> parts = new ArrayList<Part>();

        public Parts(MultiPartFormData.Parts parts) {
            parts.forEach(part -> this.parts.add(new ServletPart(parts.getMultiPartFormData(), (MultiPart.Part)part)));
        }

        public Part getPart(String name) {
            return this.parts.stream().filter(part -> part.getName().equals(name)).findFirst().orElse(null);
        }

        public Collection<Part> getParts() {
            return List.copyOf(this.parts);
        }
    }

    private static class ServletPart
    implements Part {
        private final MultiPartFormData _formData;
        private final MultiPart.Part _part;

        private ServletPart(MultiPartFormData formData, MultiPart.Part part) {
            this._formData = formData;
            this._part = part;
        }

        public InputStream getInputStream() throws IOException {
            return Content.Source.asInputStream((Content.Source)this._part.newContentSource());
        }

        public String getContentType() {
            return this._part.getHeaders().get(HttpHeader.CONTENT_TYPE);
        }

        public String getName() {
            return this._part.getName();
        }

        public String getSubmittedFileName() {
            return this._part.getFileName();
        }

        public long getSize() {
            return this._part.getLength();
        }

        public void write(String fileName) throws IOException {
            Path filePath = Path.of(fileName, new String[0]);
            if (!filePath.isAbsolute()) {
                filePath = this._formData.getFilesDirectory().resolve(filePath).normalize();
            }
            this._part.writeTo(filePath);
        }

        public void delete() throws IOException {
            this._part.delete();
        }

        public String getHeader(String name) {
            return this._part.getHeaders().get(name);
        }

        public Collection<String> getHeaders(String name) {
            return this._part.getHeaders().getValuesList(name);
        }

        public Collection<String> getHeaderNames() {
            return this._part.getHeaders().getFieldNamesCollection();
        }

        public String toString() {
            return "%s@%x[part=%s]".formatted(this.getClass().getSimpleName(), this.hashCode(), this._part);
        }
    }
}

