/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.ServletResponse;
import jakarta.servlet.ServletResponseWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.eclipse.jetty.ee10.servlet.HttpOutput;
import org.eclipse.jetty.ee10.servlet.ServletApiResponse;
import org.eclipse.jetty.ee10.servlet.ServletChannel;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletRequestState;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.ee10.servlet.writer.ResponseWriter;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextResponse;
import org.eclipse.jetty.session.ManagedSession;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;

public class ServletContextResponse
extends ContextResponse {
    private final Response _response;
    private final HttpOutput _httpOutput;
    private final ServletChannel _servletChannel;
    private final ServletApiResponse _httpServletResponse;
    private final ServletContextRequest _request;
    private String _characterEncoding;
    private String _contentType;
    private MimeTypes.Type _mimeType;
    private Locale _locale;
    private EncodingFrom _encodingFrom = EncodingFrom.NOT_SET;
    private OutputType _outputType = OutputType.NONE;
    private ResponseWriter _writer;
    private long _contentLength = -1L;
    private Supplier<Map<String, String>> _trailers;

    public static ServletContextResponse getServletContextResponse(ServletResponse response) {
        if (response instanceof ServletApiResponse) {
            return ((ServletApiResponse)response).getResponse();
        }
        while (response instanceof ServletResponseWrapper) {
            response = ((ServletResponseWrapper)response).getResponse();
        }
        if (response instanceof ServletApiResponse) {
            return ((ServletApiResponse)response).getResponse();
        }
        throw new IllegalStateException("could not find %s for %s".formatted(ServletContextResponse.class.getSimpleName(), response));
    }

    public ServletContextResponse(ServletChannel servletChannel, ServletContextRequest request, Response response) {
        super((ContextHandler.ScopedContext)servletChannel.getContext(), response.getRequest(), response);
        this._request = request;
        this._response = response;
        this._httpOutput = new HttpOutput(response, servletChannel);
        this._servletChannel = servletChannel;
        this._httpServletResponse = this.newServletApiResponse();
    }

    protected ResponseWriter getWriter() {
        return this._writer;
    }

    protected void setWriter(ResponseWriter writer) {
        this._writer = writer;
    }

    protected Locale getLocale() {
        return this._locale;
    }

    protected void setLocale(Locale locale) {
        this._locale = locale;
    }

    protected EncodingFrom getEncodingFrom() {
        return this._encodingFrom;
    }

    protected MimeTypes.Type getMimeType() {
        return this._mimeType;
    }

    protected void setMimeType(MimeTypes.Type mimeType) {
        this._mimeType = mimeType;
    }

    protected Supplier<Map<String, String>> getTrailers() {
        return this._trailers;
    }

    public void setTrailers(Supplier<Map<String, String>> trailers) {
        this._trailers = trailers;
    }

    protected void setContentType(String contentType) {
        this._contentType = contentType;
    }

    protected String getCharacterEncoding() {
        return this._characterEncoding;
    }

    protected void setCharacterEncoding(String value) {
        this._characterEncoding = value;
    }

    protected void setOutputType(OutputType outputType) {
        this._outputType = outputType;
    }

    protected String getContentType() {
        return this._contentType;
    }

    protected OutputType getOutputType() {
        return this._outputType;
    }

    protected ServletContextRequest getServletContextRequest() {
        return this._request;
    }

    protected ServletApiResponse newServletApiResponse() {
        return new ServletApiResponse(this);
    }

    public HttpOutput getHttpOutput() {
        return this._httpOutput;
    }

    public ServletRequestState getState() {
        return this._servletChannel.getState();
    }

    public HttpServletResponse getHttpServletResponse() {
        return this._httpServletResponse;
    }

    public ServletApiResponse getServletApiResponse() {
        return this._httpServletResponse;
    }

    public void resetForForward() {
        this._httpServletResponse.resetBuffer();
        this._outputType = OutputType.NONE;
    }

    public void included() {
        if (this._outputType == OutputType.WRITER) {
            this._writer.reopen();
        }
        this._httpOutput.reopen();
    }

    public void completeOutput(Callback callback) {
        if (this._outputType == OutputType.WRITER) {
            this._writer.complete(callback);
        } else {
            this._httpOutput.complete(callback);
        }
    }

    public boolean isAllContentWritten(long written) {
        return this._contentLength >= 0L && written >= this._contentLength;
    }

    public boolean isContentComplete(long written) {
        return this._contentLength < 0L || written >= this._contentLength;
    }

    public void setContentLength(int len) {
        this.setContentLength((long)len);
    }

    public void setContentLength(long len) {
        if (this.isCommitted()) {
            return;
        }
        if (len > 0L) {
            long written = this._httpOutput.getWritten();
            if (written > len) {
                throw new IllegalArgumentException("setContentLength(" + len + ") when already written " + written);
            }
            this._contentLength = len;
            this.getHeaders().putLongField(HttpHeader.CONTENT_LENGTH, len);
            if (this.isAllContentWritten(written)) {
                try {
                    this.closeOutput();
                }
                catch (IOException e) {
                    throw new RuntimeIOException((Throwable)e);
                }
            }
        } else if (len == 0L) {
            long written = this._httpOutput.getWritten();
            if (written > 0L) {
                throw new IllegalArgumentException("setContentLength(0) when already written " + written);
            }
            this._contentLength = len;
            this.getHeaders().put(HttpHeader.CONTENT_LENGTH, "0");
        } else {
            this._contentLength = len;
            this.getHeaders().remove(HttpHeader.CONTENT_LENGTH);
        }
    }

    public long getContentLength() {
        return this._contentLength;
    }

    public void closeOutput() throws IOException {
        if (this._outputType == OutputType.WRITER) {
            this._writer.close();
        } else {
            this._httpOutput.close();
        }
    }

    public void reset() {
        SessionHandler sh;
        super.reset();
        this._httpServletResponse.resetBuffer();
        this._outputType = OutputType.NONE;
        this._contentLength = -1L;
        this._contentType = null;
        this._mimeType = null;
        this._characterEncoding = null;
        this._encodingFrom = EncodingFrom.NOT_SET;
        this._trailers = null;
        HttpFields.Mutable headers = this.getHeaders();
        headers.clear();
        for (String value : this.getRequest().getHeaders().getCSV(HttpHeader.CONNECTION, false)) {
            HttpHeaderValue cb = (HttpHeaderValue)HttpHeaderValue.CACHE.get(value);
            if (cb == null) continue;
            switch (cb) {
                case CLOSE: {
                    headers.put(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.toString());
                    break;
                }
                case KEEP_ALIVE: {
                    if (!HttpVersion.HTTP_1_0.is(this._request.getConnectionMetaData().getProtocol())) break;
                    headers.put(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.toString());
                    break;
                }
                case TE: {
                    headers.put(HttpHeader.CONNECTION, HttpHeaderValue.TE.toString());
                    break;
                }
            }
        }
        HttpSession session = this._request.getHttpServletRequest().getSession(false);
        if (session != null && session.isNew() && (sh = this._servletChannel.getContextHandler().getSessionHandler()) != null) {
            ManagedSession managedSession = SessionHandler.ServletSessionApi.getSession(session);
            if (managedSession != null) {
                HttpCookie c = sh.getSessionCookie(managedSession, this._request.isSecure());
                if (c != null) {
                    Response.addCookie((Response)this._response, (HttpCookie)c);
                }
            } else {
                throw new IllegalStateException();
            }
        }
    }

    public void resetContent() {
        this._httpOutput.resetBuffer();
        this._outputType = OutputType.NONE;
        this._contentLength = -1L;
        this._contentType = null;
        this._mimeType = null;
        this._characterEncoding = null;
        this._encodingFrom = EncodingFrom.NOT_SET;
        Iterator i = this.getHeaders().iterator();
        block4: while (i.hasNext()) {
            HttpField field = (HttpField)i.next();
            if (field.getHeader() == null) continue;
            switch (field.getHeader()) {
                case CONTENT_TYPE: 
                case CONTENT_LENGTH: 
                case CONTENT_ENCODING: 
                case CONTENT_LANGUAGE: 
                case CONTENT_RANGE: 
                case CONTENT_MD5: 
                case CONTENT_LOCATION: 
                case TRANSFER_ENCODING: 
                case CACHE_CONTROL: 
                case LAST_MODIFIED: 
                case EXPIRES: 
                case DATE: 
                case VARY: {
                    i.remove();
                    continue block4;
                }
                case ETAG: {
                    if (this.getStatus() == 304) continue block4;
                    i.remove();
                    continue block4;
                }
            }
        }
    }

    public String getRawCharacterEncoding() {
        return this._characterEncoding;
    }

    public String getCharacterEncoding(boolean setContentType) {
        if (this._characterEncoding != null) {
            return this._characterEncoding;
        }
        if (this._mimeType != null && this._mimeType.isCharsetAssumed()) {
            return this._mimeType.getCharsetString();
        }
        MimeTypes mimeTypes = this._request.getContext().getMimeTypes();
        String encoding = mimeTypes.getCharsetAssumedFromContentType(this._contentType);
        if (encoding != null) {
            return encoding;
        }
        encoding = mimeTypes.getCharsetInferredFromContentType(this._contentType);
        if (encoding != null) {
            if (setContentType) {
                this.setCharacterEncoding(encoding, EncodingFrom.INFERRED);
            }
            return encoding;
        }
        ServletContextHandler.ServletContextApi context = this._servletChannel.getServletContextRequest().getContext().getServletContext();
        if (context != null && (encoding = context.getResponseCharacterEncoding()) != null) {
            if (setContentType) {
                this.setCharacterEncoding(encoding, EncodingFrom.DEFAULT);
            }
            return encoding;
        }
        encoding = "iso-8859-1";
        if (setContentType) {
            this.setCharacterEncoding(encoding, EncodingFrom.DEFAULT);
        }
        return encoding;
    }

    protected void setRawCharacterEncoding(String encoding, EncodingFrom from) {
        this._characterEncoding = encoding;
        this._encodingFrom = from;
    }

    protected void setCharacterEncoding(String encoding, EncodingFrom from) {
        if (this.isWriting() || this.isCommitted()) {
            return;
        }
        if (encoding == null) {
            this._encodingFrom = EncodingFrom.NOT_SET;
            if (this._characterEncoding != null) {
                this._characterEncoding = null;
                if (this._mimeType != null) {
                    this._mimeType = this._mimeType.getBaseType();
                    this._contentType = this._mimeType.asString();
                    this._response.getHeaders().put(this._mimeType.getContentTypeField());
                } else if (this._contentType != null) {
                    this._contentType = MimeTypes.getContentTypeWithoutCharset((String)this._contentType);
                    this._response.getHeaders().put(HttpHeader.CONTENT_TYPE, this._contentType);
                }
            }
        } else {
            this._encodingFrom = from;
            String string = this._characterEncoding = HttpGenerator.__STRICT ? encoding : StringUtil.normalizeCharset((String)encoding);
            if (this._mimeType != null) {
                this._contentType = this._mimeType.getBaseType().asString() + ";charset=" + this._characterEncoding;
                this._mimeType = (MimeTypes.Type)MimeTypes.CACHE.get(this._contentType);
                if (this._mimeType == null || HttpGenerator.__STRICT) {
                    this._response.getHeaders().put(HttpHeader.CONTENT_TYPE, this._contentType);
                } else {
                    this._response.getHeaders().put(this._mimeType.getContentTypeField());
                }
            } else if (this._contentType != null) {
                this._contentType = MimeTypes.getContentTypeWithoutCharset((String)this._contentType) + ";charset=" + this._characterEncoding;
                this._response.getHeaders().put(HttpHeader.CONTENT_TYPE, this._contentType);
            }
        }
    }

    public boolean isWriting() {
        return this._outputType == OutputType.WRITER;
    }

    public boolean isStreaming() {
        return this._outputType == OutputType.STREAM;
    }

    public boolean isWritingOrStreaming() {
        return this.isWriting() || this.isStreaming();
    }

    protected static enum EncodingFrom {
        NOT_SET,
        DEFAULT,
        INFERRED,
        SET_LOCALE,
        SET_CONTENT_TYPE,
        SET_CHARACTER_ENCODING;

    }

    protected static enum OutputType {
        NONE,
        STREAM,
        WRITER;

    }
}

