/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestWrapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.eclipse.jetty.ee10.servlet.HttpInput;
import org.eclipse.jetty.ee10.servlet.HttpOutput;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletChannel;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.servlet.ServletRequestState;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.pathmap.MatchedPath;
import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextRequest;
import org.eclipse.jetty.session.AbstractSessionManager;
import org.eclipse.jetty.session.ManagedSession;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContextRequest
extends ContextRequest {
    public static final String MULTIPART_CONFIG_ELEMENT = "org.eclipse.jetty.multipartConfig";
    private static final Logger LOG = LoggerFactory.getLogger(ServletContextRequest.class);
    static final int INPUT_NONE = 0;
    static final int INPUT_STREAM = 1;
    static final int INPUT_READER = 2;
    static final Fields NO_PARAMS = new Fields(new Fields(), true);
    static final Fields BAD_PARAMS = new Fields(new Fields(), true);
    private final List<ServletRequestAttributeListener> _requestAttributeListeners = new ArrayList<ServletRequestAttributeListener>();
    private final ServletApiRequest _httpServletRequest;
    private final ServletContextResponse _response;
    final ServletHandler.MappedServlet _mappedServlet;
    private final HttpInput _httpInput;
    private final String _pathInContext;
    private final ServletChannel _servletChannel;
    private final PathSpec _pathSpec;
    private final SessionManager _sessionManager;
    final MatchedPath _matchedPath;
    private Charset _queryEncoding;
    private HttpFields _trailers;
    private ManagedSession _managedSession;
    AbstractSessionManager.RequestedSession _requestedSession;

    public static ServletContextRequest getServletContextRequest(ServletRequest request) {
        if (request instanceof ServletApiRequest) {
            return ((ServletApiRequest)request).getServletContextRequest();
        }
        Object channel = request.getAttribute(ServletChannel.class.getName());
        if (channel instanceof ServletChannel) {
            return ((ServletChannel)channel).getServletContextRequest();
        }
        while (request instanceof ServletRequestWrapper) {
            request = ((ServletRequestWrapper)request).getRequest();
        }
        if (request instanceof ServletApiRequest) {
            return ((ServletApiRequest)request).getServletContextRequest();
        }
        throw new IllegalStateException("could not find %s for %s".formatted(ServletContextRequest.class.getSimpleName(), request));
    }

    protected ServletContextRequest(ServletContextHandler.ServletContextApi servletContextApi, ServletChannel servletChannel, Request request, Response response, String pathInContext, MatchedResource<ServletHandler.MappedServlet> matchedResource, SessionManager sessionManager) {
        super((ContextHandler.ScopedContext)servletContextApi.getContext(), request);
        this._servletChannel = servletChannel;
        this._httpServletRequest = this.newServletApiRequest();
        this._mappedServlet = (ServletHandler.MappedServlet)matchedResource.getResource();
        this._httpInput = this._servletChannel.getHttpInput();
        this._pathInContext = pathInContext;
        this._pathSpec = matchedResource.getPathSpec();
        this._matchedPath = matchedResource.getMatchedPath();
        this._response = this.newServletContextResponse(response);
        this._sessionManager = sessionManager;
    }

    protected ServletApiRequest newServletApiRequest() {
        return new ServletApiRequest(this);
    }

    protected ServletContextResponse newServletContextResponse(Response response) {
        return new ServletContextResponse(this._servletChannel, this, response);
    }

    public String getPathInContext() {
        return this._pathInContext;
    }

    public PathSpec getPathSpec() {
        return this._pathSpec;
    }

    public MatchedPath getMatchedPath() {
        return this._matchedPath;
    }

    public HttpFields getTrailers() {
        return this._trailers;
    }

    void setTrailers(HttpFields trailers) {
        this._trailers = trailers;
    }

    public ServletRequestState getState() {
        return this._servletChannel.getState();
    }

    public ServletContextResponse getResponse() {
        return this._response;
    }

    public ServletContextHandler.ServletScopedContext getContext() {
        return (ServletContextHandler.ServletScopedContext)super.getContext();
    }

    public HttpInput getHttpInput() {
        return this._httpInput;
    }

    public HttpOutput getHttpOutput() {
        return this._response.getHttpOutput();
    }

    public void errorClose() {
        this._response.getHttpOutput().softClose();
    }

    public boolean isHead() {
        return HttpMethod.HEAD.is(this.getMethod());
    }

    public void setQueryEncoding(String queryEncoding) {
        this._queryEncoding = Charset.forName(queryEncoding);
    }

    public Charset getQueryEncoding() {
        return this._queryEncoding;
    }

    public Object getAttribute(String name) {
        return switch (name) {
            case "o.e.j.s.s.ServletScopedRequest.request" -> this._httpServletRequest;
            case "o.e.j.s.s.ServletScopedRequest.response" -> this._response.getHttpServletResponse();
            case "o.e.j.s.s.ServletScopedRequest.servlet" -> this._mappedServlet.getServletPathMapping(this.getPathInContext()).getServletName();
            case "o.e.j.s.s.ServletScopedRequest.url-pattern" -> this._mappedServlet.getServletPathMapping(this.getPathInContext()).getPattern();
            default -> super.getAttribute(name);
        };
    }

    public Object removeAttribute(String name) {
        return super.removeAttribute(name);
    }

    public Object setAttribute(String name, Object attribute) {
        return super.setAttribute(name, attribute);
    }

    public ServletContextHandler.ServletScopedContext getErrorContext() {
        return this._servletChannel.getContext();
    }

    ServletRequestState getServletRequestState() {
        return this._servletChannel.getState();
    }

    ServletChannel getServletChannel() {
        return this._servletChannel;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this._httpServletRequest;
    }

    public ServletApiRequest getServletApiRequest() {
        return this._httpServletRequest;
    }

    public HttpServletResponse getHttpServletResponse() {
        return this._response.getHttpServletResponse();
    }

    public ServletHandler.MappedServlet getMappedServlet() {
        return this._mappedServlet;
    }

    public String getServletName() {
        return this._mappedServlet.getServletHolder().getName();
    }

    public List<ServletRequestAttributeListener> getRequestAttributeListeners() {
        return this._requestAttributeListeners;
    }

    public void addEventListener(EventListener listener) {
        if (listener instanceof ServletRequestAttributeListener) {
            this._requestAttributeListeners.add((ServletRequestAttributeListener)listener);
        }
        if (listener instanceof AsyncListener) {
            throw new IllegalArgumentException(listener.getClass().toString());
        }
    }

    public void removeEventListener(EventListener listener) {
        this._requestAttributeListeners.remove(listener);
    }

    static boolean isNoParams(Fields fields) {
        boolean isNoParams = fields == NO_PARAMS;
        return isNoParams;
    }

    public ManagedSession getManagedSession() {
        return this._managedSession;
    }

    public void setManagedSession(ManagedSession managedSession) {
        this._managedSession = managedSession;
    }

    public SessionManager getSessionManager() {
        return this._sessionManager;
    }

    public void setRequestedSession(AbstractSessionManager.RequestedSession requestedSession) {
        if (this._requestedSession != null) {
            throw new IllegalStateException();
        }
        this._requestedSession = requestedSession;
        this._managedSession = requestedSession.session();
    }

    public AbstractSessionManager.RequestedSession getRequestedSession() {
        return this._requestedSession;
    }

    public Session getSession(boolean create) {
        if (this._managedSession != null) {
            if (this._sessionManager != null && !this._managedSession.isValid()) {
                this._managedSession = null;
            } else {
                return this._managedSession;
            }
        }
        if (!create) {
            return null;
        }
        if (this._response.isCommitted()) {
            throw new IllegalStateException("Response is committed");
        }
        if (this._sessionManager == null) {
            throw new IllegalStateException("No SessionManager");
        }
        this._sessionManager.newSession((Request)this, this._requestedSession.sessionId(), this::setManagedSession);
        if (this._managedSession == null) {
            throw new IllegalStateException("Create session failed");
        }
        HttpCookie cookie = this._sessionManager.getSessionCookie(this._managedSession, this.isSecure());
        if (cookie != null) {
            Response.replaceCookie((Response)this._response, (HttpCookie)cookie);
        }
        return this._managedSession;
    }
}

