/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.jetty.ee10.servlet.AsyncContextEvent;
import org.eclipse.jetty.ee10.servlet.Dispatcher;
import org.eclipse.jetty.ee10.servlet.ErrorHandler;
import org.eclipse.jetty.ee10.servlet.HttpInput;
import org.eclipse.jetty.ee10.servlet.HttpOutput;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.servlet.ServletRequestState;
import org.eclipse.jetty.ee10.servlet.security.Authentication;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.QuietException;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.ResponseUtils;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletChannel {
    private static final Logger LOG = LoggerFactory.getLogger(ServletChannel.class);
    private final ServletRequestState _state;
    private final ServletContextHandler.ServletScopedContext _context;
    private final ServletContextHandler.ServletContextApi _servletContextApi;
    private final AtomicLong _requests = new AtomicLong();
    private final Connector _connector;
    private final Executor _executor;
    private final HttpConfiguration _configuration;
    private final EndPoint _endPoint;
    private final HttpInput _httpInput;
    private final Listener _combinedListener;
    private volatile ServletContextRequest _servletContextRequest;
    private volatile boolean _expects100Continue;
    private volatile long _oldIdleTimeout;
    private volatile Callback _callback;
    private volatile long _written;

    public ServletChannel(ServletContextHandler servletContextHandler, Request request) {
        this._state = new ServletRequestState(this);
        this._context = servletContextHandler.getContext();
        this._servletContextApi = this._context.getServletContext();
        this._connector = request.getConnectionMetaData().getConnector();
        this._executor = request.getContext();
        this._configuration = request.getConnectionMetaData().getHttpConfiguration();
        this._endPoint = request.getConnectionMetaData().getConnection().getEndPoint();
        this._httpInput = new HttpInput(this);
        this._combinedListener = new Listeners(this._connector, servletContextHandler);
    }

    public void setCallback(Callback callback) {
        if (this._callback != null) {
            throw new IllegalStateException();
        }
        this._callback = callback;
    }

    public Callback getCallback() {
        return this._callback;
    }

    public void associate(ServletContextRequest servletContextRequest) {
        this._state.recycle();
        this._httpInput.reopen();
        this._servletContextRequest = servletContextRequest;
        this._expects100Continue = servletContextRequest.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
        if (LOG.isDebugEnabled()) {
            LOG.debug("new {} -> {},{}", new Object[]{this, this._servletContextRequest, this._state});
        }
    }

    public ServletContextHandler.ServletScopedContext getContext() {
        return this._context;
    }

    public ServletContextHandler getContextHandler() {
        return (ServletContextHandler)this._context.getContextHandler();
    }

    public ServletContextHandler.ServletContextApi getServletContext() {
        return this._servletContextApi;
    }

    public HttpOutput getHttpOutput() {
        return this._servletContextRequest.getHttpOutput();
    }

    public HttpInput getHttpInput() {
        return this._httpInput;
    }

    public ServletContextHandler.ServletContextApi getServletContextContext() {
        return this._servletContextApi;
    }

    public boolean isSendError() {
        return this._state.isSendError();
    }

    protected String formatAddrOrHost(String addr) {
        return HostPort.normalizeHost((String)addr);
    }

    public ServletRequestState getState() {
        return this._state;
    }

    public long getBytesWritten() {
        return this._written;
    }

    public long getIdleTimeout() {
        return this._endPoint.getIdleTimeout();
    }

    public void setIdleTimeout(long timeoutMs) {
        this._endPoint.setIdleTimeout(timeoutMs);
    }

    public HttpConfiguration getHttpConfiguration() {
        return this._configuration;
    }

    public Server getServer() {
        return this._connector.getServer();
    }

    public ServletContextRequest getServletContextRequest() {
        return this._servletContextRequest;
    }

    public ServletContextResponse getResponse() {
        ServletContextRequest request = this._servletContextRequest;
        return request == null ? null : request.getResponse();
    }

    public Connection getConnection() {
        return this._endPoint.getConnection();
    }

    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    public String getLocalName() {
        SocketAddress localAddress;
        HttpConfiguration httpConfiguration = this.getHttpConfiguration();
        if (httpConfiguration != null && (localAddress = httpConfiguration.getLocalAddress()) instanceof InetSocketAddress) {
            return ((InetSocketAddress)localAddress).getHostName();
        }
        InetSocketAddress local = this.getLocalAddress();
        if (local != null) {
            return local.getHostString();
        }
        return null;
    }

    public int getLocalPort() {
        SocketAddress localAddress;
        HttpConfiguration httpConfiguration = this.getHttpConfiguration();
        if (httpConfiguration != null && (localAddress = httpConfiguration.getLocalAddress()) instanceof InetSocketAddress) {
            return ((InetSocketAddress)localAddress).getPort();
        }
        InetSocketAddress local = this.getLocalAddress();
        return local == null ? 0 : local.getPort();
    }

    public InetSocketAddress getLocalAddress() {
        SocketAddress localAddress;
        HttpConfiguration httpConfiguration = this.getHttpConfiguration();
        if (httpConfiguration != null && (localAddress = httpConfiguration.getLocalAddress()) instanceof InetSocketAddress) {
            return (InetSocketAddress)localAddress;
        }
        SocketAddress local = this._endPoint.getLocalSocketAddress();
        if (local instanceof InetSocketAddress) {
            return (InetSocketAddress)local;
        }
        return null;
    }

    public InetSocketAddress getRemoteAddress() {
        SocketAddress remote = this._endPoint.getRemoteSocketAddress();
        if (remote instanceof InetSocketAddress) {
            return (InetSocketAddress)remote;
        }
        return null;
    }

    public HostPort getServerAuthority() {
        HttpConfiguration httpConfiguration = this.getHttpConfiguration();
        if (httpConfiguration != null) {
            return httpConfiguration.getServerAuthority();
        }
        return null;
    }

    public void continue100(int available) throws IOException {
        if (this.isExpecting100Continue()) {
            this._expects100Continue = false;
            if (available == 0) {
                if (this.isCommitted()) {
                    throw new IOException("Committed before 100 Continue");
                }
                try {
                    this.getResponse().writeInterim(100, HttpFields.EMPTY).get();
                }
                catch (Throwable x) {
                    throw IO.rethrow((Throwable)x);
                }
            }
        }
    }

    private void recycle() {
        this._httpInput.recycle();
        this._servletContextRequest = null;
        this._callback = null;
        this._written = 0L;
        this._oldIdleTimeout = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("handle {} {} ", (Object)this._servletContextRequest.getHttpURI(), (Object)this);
        }
        ServletRequestState.Action action = this._state.handling();
        block26: while (!this.getServer().isStopped()) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("action {} {}", (Object)action, (Object)this);
                }
                switch (action) {
                    case TERMINATED: {
                        this.onCompleted();
                        break block26;
                    }
                    case WAIT: {
                        break block26;
                    }
                    case DISPATCH: {
                        this.dispatch(() -> {
                            ServletHandler servletHandler = this._context.getServletContextHandler().getServletHandler();
                            ServletHandler.MappedServlet mappedServlet = this._servletContextRequest._mappedServlet;
                            mappedServlet.handle(servletHandler, Request.getPathInContext((Request)this._servletContextRequest), this._servletContextRequest.getHttpServletRequest(), this._servletContextRequest.getHttpServletResponse());
                        });
                        break;
                    }
                    case ASYNC_DISPATCH: {
                        this.dispatch(() -> {
                            HttpURI uri;
                            String pathInContext = Request.getPathInContext((Request)this._servletContextRequest);
                            AsyncContextEvent asyncContextEvent = this._state.getAsyncContextEvent();
                            String dispatchString = asyncContextEvent.getDispatchPath();
                            if (dispatchString != null) {
                                String contextPath = this._context.getContextPath();
                                HttpURI.Immutable dispatchUri = HttpURI.from((String)dispatchString);
                                pathInContext = URIUtil.canonicalPath((String)dispatchUri.getPath());
                                uri = HttpURI.build((HttpURI)this._servletContextRequest.getHttpURI()).path(URIUtil.addPaths((String)contextPath, (String)pathInContext)).query(dispatchUri.getQuery());
                            } else {
                                uri = asyncContextEvent.getBaseURI();
                                if (uri == null) {
                                    uri = this._servletContextRequest.getHttpURI();
                                } else {
                                    pathInContext = uri.getCanonicalPath();
                                    if (this._context.getContextPath().length() > 1) {
                                        pathInContext = pathInContext.substring(this._context.getContextPath().length());
                                    }
                                }
                            }
                            Dispatcher dispatcher = new Dispatcher(this.getContextHandler(), uri, pathInContext);
                            dispatcher.async(asyncContextEvent.getSuppliedRequest(), asyncContextEvent.getSuppliedResponse());
                        });
                        break;
                    }
                    case ASYNC_TIMEOUT: {
                        this._state.onTimeout();
                        break;
                    }
                    case SEND_ERROR: {
                        try {
                            this.getResponse().resetContent();
                            Integer code = (Integer)this._servletContextRequest.getAttribute("jakarta.servlet.error.status_code");
                            if (code == null) {
                                code = 500;
                            }
                            this.getResponse().setStatus(code);
                            if (!this._httpInput.consumeAvailable()) {
                                ResponseUtils.ensureNotPersistent((Request)this._servletContextRequest, (Response)this._servletContextRequest.getResponse());
                            }
                            ContextHandler.ScopedContext context = (ContextHandler.ScopedContext)this._servletContextRequest.getAttribute("org.eclipse.jetty.server.error_context");
                            Request.Handler errorHandler = ErrorHandler.getErrorHandler(this.getServer(), context == null ? null : context.getContextHandler());
                            if (HttpStatus.hasNoBody((int)this.getResponse().getStatus()) || errorHandler == null) {
                                this.sendResponseAndComplete();
                                break;
                            }
                            try (Blocker.Callback blocker = Blocker.callback();){
                                this.dispatch(() -> errorHandler.handle((Request)this._servletContextRequest, (Response)this.getResponse(), (Callback)blocker));
                                blocker.block();
                                break;
                            }
                        }
                        catch (Throwable x) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Could not perform ERROR dispatch, aborting", x);
                            }
                            if (this._state.isResponseCommitted()) {
                                this.abort(x);
                            } else {
                                try {
                                    this.getResponse().resetContent();
                                    this.sendResponseAndComplete();
                                }
                                catch (Throwable t) {
                                    if (x != t) {
                                        x.addSuppressed(t);
                                    }
                                    this.abort(x);
                                }
                            }
                            break;
                        }
                        finally {
                            this._servletContextRequest.removeAttribute("org.eclipse.jetty.server.error_context");
                        }
                    }
                    case ASYNC_ERROR: {
                        throw this._state.getAsyncContextEvent().getThrowable();
                    }
                    case READ_CALLBACK: {
                        this._context.run(() -> this._servletContextRequest.getHttpInput().run());
                        break;
                    }
                    case WRITE_CALLBACK: {
                        this._context.run(() -> this._servletContextRequest.getHttpOutput().run());
                        break;
                    }
                    case COMPLETE: {
                        if (!this.getResponse().isCommitted() && this.getResponse().getStatus() >= 200) {
                            ResponseUtils.ensureConsumeAvailableOrNotPersistent((Request)this._servletContextRequest, (Response)this._servletContextRequest.getResponse());
                        }
                        if (!this._servletContextRequest.isHead() && this.getResponse().getStatus() != 304 && !this.getResponse().isContentComplete(this._servletContextRequest.getHttpOutput().getWritten()) && this.sendErrorOrAbort("Insufficient content written") || this.checkAndPrepareUpgrade()) break;
                        this.getResponse().completeOutput(Callback.from((Invocable.InvocationType)Invocable.InvocationType.NON_BLOCKING, () -> this._state.completed(null), this._state::completed));
                        break;
                    }
                    default: {
                        throw new IllegalStateException(this.toString());
                    }
                }
            }
            catch (Throwable failure) {
                if ("org.eclipse.jetty.continuation.ContinuationThrowable".equals(failure.getClass().getName())) {
                    LOG.trace("IGNORED", failure);
                }
                this.handleException(failure);
            }
            action = this._state.unhandle();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("!handle {} {}", (Object)action, (Object)this);
        }
        boolean suspended = action == ServletRequestState.Action.WAIT;
        return !suspended;
    }

    public boolean sendErrorOrAbort(String message) {
        try {
            if (this.isCommitted()) {
                this.abort(new IOException(message));
                return false;
            }
            this.getResponse().getServletApiResponse().sendError(500, message);
            return true;
        }
        catch (Throwable x) {
            LOG.trace("IGNORED", x);
            this.abort(x);
            return false;
        }
    }

    private void dispatch(Dispatchable dispatchable) throws Exception {
        try {
            this._servletContextRequest.getResponse().getHttpOutput().reopen();
            this._context.getServletContextHandler().requestInitialized((Request)this._servletContextRequest, this._servletContextRequest.getHttpServletRequest());
            this.getHttpOutput().reopen();
            this._combinedListener.onBeforeDispatch((Request)this._servletContextRequest);
            dispatchable.dispatch();
        }
        catch (Throwable x) {
            this._combinedListener.onDispatchFailure((Request)this._servletContextRequest, x);
            throw x;
        }
        finally {
            this._combinedListener.onAfterDispatch((Request)this._servletContextRequest);
            this._context.getServletContextHandler().requestDestroyed((Request)this._servletContextRequest, this._servletContextRequest.getHttpServletRequest());
        }
    }

    protected void handleException(Throwable failure) {
        Throwable quiet = this.unwrap(failure, QuietException.class);
        Throwable noStack = this.unwrap(failure, BadMessageException.class, IOException.class, TimeoutException.class);
        if (quiet != null || !this.getServer().isRunning()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this._servletContextRequest.getHttpServletRequest().getRequestURI(), failure);
            }
        } else if (noStack != null) {
            if (LOG.isDebugEnabled()) {
                LOG.warn("handleException {}", (Object)this._servletContextRequest.getHttpServletRequest().getRequestURI(), (Object)failure);
            } else {
                LOG.warn("handleException {} {}", (Object)this._servletContextRequest.getHttpServletRequest().getRequestURI(), (Object)noStack.toString());
            }
        } else {
            ServletContextRequest request = this._servletContextRequest;
            LOG.warn(request == null ? "unknown request" : request.getHttpServletRequest().getRequestURI(), failure);
        }
        if (this.isCommitted()) {
            this.abort(failure);
        } else {
            try {
                this._state.onError(failure);
            }
            catch (IllegalStateException e) {
                this.abort(failure);
            }
        }
    }

    protected Throwable unwrap(Throwable failure, Class<?> ... targets) {
        while (failure != null) {
            for (Class<?> x : targets) {
                if (!x.isInstance(failure)) continue;
                return failure;
            }
            failure = failure.getCause();
        }
        return null;
    }

    public void sendResponseAndComplete() {
        try {
            this._state.completing();
            this.getResponse().write(true, this.getResponse().getHttpOutput().getByteBuffer(), Callback.from(() -> this._state.completed(null), this._state::completed));
        }
        catch (Throwable x) {
            this.abort(x);
        }
    }

    public boolean isExpecting100Continue() {
        return this._expects100Continue;
    }

    public String toString() {
        if (this._servletContextRequest == null) {
            return String.format("%s@%x{null}", this.getClass().getSimpleName(), this.hashCode());
        }
        long timeStamp = this._servletContextRequest.getTimeStamp();
        return String.format("%s@%x{s=%s,r=%s,c=%b/%b,a=%s,uri=%s,age=%d}", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this._state, this._requests, this.isRequestCompleted(), this.isResponseCompleted(), this._state.getState(), this._servletContextRequest.getHttpURI(), timeStamp == 0L ? 0L : System.currentTimeMillis() - timeStamp});
    }

    protected boolean checkAndPrepareUpgrade() {
        return false;
    }

    void onTrailers(HttpFields trailers) {
        this._servletContextRequest.setTrailers(trailers);
        this._combinedListener.onRequestTrailers((Request)this._servletContextRequest);
    }

    public void onCompleted() {
        long idleTO;
        ServletApiRequest apiRequest = this._servletContextRequest.getServletApiRequest();
        if (LOG.isDebugEnabled()) {
            LOG.debug("onCompleted for {} written={}", (Object)apiRequest.getRequestURI(), (Object)this.getBytesWritten());
        }
        if ((idleTO = this._configuration.getIdleTimeout()) >= 0L && this.getIdleTimeout() != this._oldIdleTimeout) {
            this.setIdleTimeout(this._oldIdleTimeout);
        }
        if (this.getServer().getRequestLog() != null) {
            Authentication authentication = apiRequest.getAuthentication();
            if (authentication instanceof Authentication.User) {
                Authentication.User userAuthentication = (Authentication.User)authentication;
                this._servletContextRequest.setAttribute(CustomRequestLog.USER_NAME, userAuthentication.getUserIdentity().getUserPrincipal().getName());
            }
            String realPath = apiRequest.getServletContext().getRealPath(Request.getPathInContext((Request)this._servletContextRequest));
            this._servletContextRequest.setAttribute(CustomRequestLog.REAL_PATH, realPath);
            String servletName = this._servletContextRequest.getServletName();
            this._servletContextRequest.setAttribute(CustomRequestLog.HANDLER_NAME, servletName);
        }
        Callback callback = this._callback;
        ServletContextRequest servletContextRequest = this._servletContextRequest;
        this.recycle();
        if (this._state.completeResponse()) {
            this._combinedListener.onComplete((Request)servletContextRequest);
            callback.succeeded();
        }
    }

    public boolean isCommitted() {
        return this._state.isResponseCommitted();
    }

    public boolean isRequestCompleted() {
        return this._state.isCompleted();
    }

    public boolean isResponseCompleted() {
        return this._state.isResponseCompleted();
    }

    protected void execute(Runnable task) {
        this._executor.execute(task);
    }

    public void abort(Throwable failure) {
        if (this._state.abortResponse()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("abort {}", (Object)this, (Object)failure);
            }
            Callback callback = this._callback;
            this._combinedListener.onResponseFailure((Request)this._servletContextRequest, failure);
            callback.failed(failure);
        }
    }

    private static class Listeners
    implements Listener {
        private final List<Listener> _listeners;

        private Listeners(Connector connector, ServletContextHandler servletContextHandler) {
            Collection connectorListeners = connector.getBeans(Listener.class);
            List<Listener> handlerListeners = servletContextHandler.getEventListeners().stream().filter(l -> l instanceof Listener).map(Listener.class::cast).toList();
            this._listeners = new ArrayList<Listener>(connectorListeners);
            this._listeners.addAll(handlerListeners);
        }

        @Override
        public void onRequestBegin(Request request) {
            this._listeners.forEach(l -> this.notify(l::onRequestBegin, request));
        }

        @Override
        public void onBeforeDispatch(Request request) {
            this._listeners.forEach(l -> this.notify(l::onBeforeDispatch, request));
        }

        @Override
        public void onDispatchFailure(Request request, Throwable failure) {
            this._listeners.forEach(l -> this.notify(l::onDispatchFailure, request, failure));
        }

        @Override
        public void onAfterDispatch(Request request) {
            this._listeners.forEach(l -> this.notify(l::onAfterDispatch, request));
        }

        @Override
        public void onRequestContent(Request request, ByteBuffer content) {
            this._listeners.forEach(l -> this.notify(l::onRequestContent, request, content));
        }

        @Override
        public void onRequestContentEnd(Request request) {
            this._listeners.forEach(l -> this.notify(l::onRequestContentEnd, request));
        }

        @Override
        public void onRequestTrailers(Request request) {
            this._listeners.forEach(l -> this.notify(l::onRequestTrailers, request));
        }

        @Override
        public void onRequestEnd(Request request) {
            this._listeners.forEach(l -> this.notify(l::onRequestEnd, request));
        }

        @Override
        public void onRequestFailure(Request request, Throwable failure) {
            this._listeners.forEach(l -> this.notify(l::onRequestFailure, request, failure));
        }

        @Override
        public void onResponseBegin(Request request) {
            this._listeners.forEach(l -> this.notify(l::onResponseBegin, request));
        }

        @Override
        public void onResponseCommit(Request request) {
            this._listeners.forEach(l -> this.notify(l::onResponseCommit, request));
        }

        @Override
        public void onResponseContent(Request request, ByteBuffer content) {
            this._listeners.forEach(l -> this.notify(l::onResponseContent, request, content));
        }

        @Override
        public void onResponseEnd(Request request) {
            this._listeners.forEach(l -> this.notify(l::onResponseEnd, request));
        }

        @Override
        public void onResponseFailure(Request request, Throwable failure) {
            this._listeners.forEach(l -> this.notify(l::onResponseFailure, request, failure));
        }

        @Override
        public void onComplete(Request request) {
            this._listeners.forEach(l -> this.notify(l::onComplete, request));
        }

        private void notify(Consumer<Request> consumer, Request request) {
            block2: {
                try {
                    consumer.accept(request);
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("failure while notifying %s event for %s".formatted(Listener.class.getSimpleName(), request));
                }
            }
        }

        private void notify(BiConsumer<Request, Throwable> consumer, Request request, Throwable failure) {
            block2: {
                try {
                    consumer.accept(request, failure);
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("failure while notifying %s event for %s".formatted(Listener.class.getSimpleName(), request));
                }
            }
        }

        private void notify(BiConsumer<Request, ByteBuffer> consumer, Request request, ByteBuffer byteBuffer) {
            block2: {
                try {
                    consumer.accept(request, byteBuffer.slice());
                }
                catch (Throwable x) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug("failure while notifying %s event for %s".formatted(Listener.class.getSimpleName(), request));
                }
            }
        }
    }

    public static interface Listener
    extends EventListener {
        default public void onRequestBegin(Request request) {
        }

        default public void onBeforeDispatch(Request request) {
        }

        default public void onDispatchFailure(Request request, Throwable failure) {
        }

        default public void onAfterDispatch(Request request) {
        }

        default public void onRequestContent(Request request, ByteBuffer content) {
        }

        default public void onRequestContentEnd(Request request) {
        }

        default public void onRequestTrailers(Request request) {
        }

        default public void onRequestEnd(Request request) {
        }

        default public void onRequestFailure(Request request, Throwable failure) {
        }

        default public void onResponseBegin(Request request) {
        }

        default public void onResponseCommit(Request request) {
        }

        default public void onResponseContent(Request request, ByteBuffer content) {
        }

        default public void onResponseEnd(Request request) {
        }

        default public void onResponseFailure(Request request, Throwable failure) {
        }

        default public void onComplete(Request request) {
        }
    }

    static interface Dispatchable {
        public void dispatch() throws Exception;
    }
}

