/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.IllegalSelectorException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.eclipse.jetty.ee10.servlet.ServletApiRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.ee10.servlet.SessionHandler;
import org.eclipse.jetty.ee10.servlet.writer.EncodingHttpWriter;
import org.eclipse.jetty.ee10.servlet.writer.Iso88591HttpWriter;
import org.eclipse.jetty.ee10.servlet.writer.ResponseWriter;
import org.eclipse.jetty.ee10.servlet.writer.Utf8HttpWriter;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.session.ManagedSession;
import org.eclipse.jetty.session.SessionManager;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;

public class ServletApiResponse
implements HttpServletResponse {
    private static final int MIN_BUFFER_SIZE = 1;
    private static final EnumSet<ServletContextResponse.EncodingFrom> LOCALE_OVERRIDE = EnumSet.of(ServletContextResponse.EncodingFrom.NOT_SET, ServletContextResponse.EncodingFrom.DEFAULT, ServletContextResponse.EncodingFrom.INFERRED, ServletContextResponse.EncodingFrom.SET_LOCALE);
    private final ServletContextResponse _response;

    protected ServletApiResponse(ServletContextResponse response) {
        this._response = response;
    }

    public ServletContextResponse getResponse() {
        return this._response;
    }

    public void addCookie(Cookie cookie) {
        if (StringUtil.isBlank((String)cookie.getName())) {
            throw new IllegalArgumentException("Cookie.name cannot be blank/null");
        }
        this.addCookie(new HttpCookieFacade(cookie));
    }

    public void addCookie(HttpCookie cookie) {
        Response.addCookie((Response)this._response, (HttpCookie)cookie);
    }

    public boolean containsHeader(String name) {
        return this._response.getHeaders().contains(name);
    }

    public String encodeURL(String url) {
        int prefix;
        String sessionURLPrefix;
        SessionHandler sessionManager = this._response.getServletContextRequest().getServletChannel().getContextHandler().getSessionHandler();
        if (sessionManager == null) {
            return url;
        }
        ServletContextRequest request = this._response.getServletContextRequest();
        HttpServletRequest httpServletRequest = request.getHttpServletRequest();
        HttpURI.Immutable uri = null;
        if (sessionManager.isCheckingRemoteSessionIdEncoding() && URIUtil.hasScheme((String)url)) {
            uri = HttpURI.from((String)url);
            String path = uri.getPath();
            path = path == null ? "" : path;
            int port = uri.getPort();
            if (port < 0) {
                port = HttpScheme.getDefaultPort((String)uri.getScheme());
            }
            if (!Request.getServerName((Request)request).equalsIgnoreCase(uri.getHost())) {
                return url;
            }
            if (Request.getServerPort((Request)request) != port) {
                return url;
            }
            if (request.getContext() != null && !path.startsWith(request.getContext().getContextPath())) {
                return url;
            }
        }
        if ((sessionURLPrefix = sessionManager.getSessionIdPathParameterNamePrefix()) == null) {
            return url;
        }
        if (url == null) {
            return null;
        }
        if (sessionManager.isUsingCookies() && httpServletRequest.isRequestedSessionIdFromCookie() || !sessionManager.isUsingURLs()) {
            int prefix2 = url.indexOf(sessionURLPrefix);
            if (prefix2 != -1) {
                int suffix = url.indexOf("?", prefix2);
                if (suffix < 0) {
                    suffix = url.indexOf("#", prefix2);
                }
                if (suffix <= prefix2) {
                    return url.substring(0, prefix2);
                }
                return url.substring(0, prefix2) + url.substring(suffix);
            }
            return url;
        }
        HttpSession session = httpServletRequest.getSession(false);
        if (session == null || !(session instanceof Session.API)) {
            return url;
        }
        Session.API api = (Session.API)session;
        if (!api.getSession().isValid()) {
            return url;
        }
        String id = api.getSession().getExtendedId();
        if (uri == null) {
            uri = HttpURI.from((String)url);
        }
        if ((prefix = url.indexOf(sessionURLPrefix)) != -1) {
            int suffix = url.indexOf("?", prefix);
            if (suffix < 0) {
                suffix = url.indexOf("#", prefix);
            }
            if (suffix <= prefix) {
                return url.substring(0, prefix + sessionURLPrefix.length()) + id;
            }
            return url.substring(0, prefix + sessionURLPrefix.length()) + id + url.substring(suffix);
        }
        int suffix = url.indexOf(63);
        if (suffix < 0) {
            suffix = url.indexOf(35);
        }
        if (suffix < 0) {
            return url + ((HttpScheme.HTTPS.is(uri.getScheme()) || HttpScheme.HTTP.is(uri.getScheme())) && uri.getPath() == null ? "/" : "") + sessionURLPrefix + id;
        }
        return url.substring(0, suffix) + ((HttpScheme.HTTPS.is(uri.getScheme()) || HttpScheme.HTTP.is(uri.getScheme())) && uri.getPath() == null ? "/" : "") + sessionURLPrefix + id + url.substring(suffix);
    }

    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    public void sendError(int sc, String msg) throws IOException {
        switch (sc) {
            case -1: {
                this._response.getServletContextRequest().getServletChannel().abort(new IOException(msg));
                break;
            }
            case 102: 
            case 103: {
                if (this.isCommitted()) break;
                try (Blocker.Callback blocker = Blocker.callback();){
                    CompletableFuture completable = this._response.writeInterim(sc, this._response.getHeaders().asImmutable());
                    blocker.completeWith(completable);
                    blocker.block();
                    break;
                }
            }
            default: {
                this._response.getState().sendError(sc, msg);
            }
        }
    }

    public void sendError(int sc) throws IOException {
        this.sendError(sc, null);
    }

    public void sendRedirect(String location) throws IOException {
        this.sendRedirect(302, location);
    }

    public void sendRedirect(int code, String location) throws IOException {
        this.resetBuffer();
        FutureCallback callback = new FutureCallback();
        Response.sendRedirect((Request)this._response.getServletContextRequest(), (Response)this._response, (Callback)callback, (int)code, (String)location, (boolean)false);
        callback.block();
    }

    public void setDateHeader(String name, long date) {
        this._response.getHeaders().putDateField(name, date);
    }

    public void addDateHeader(String name, long date) {
        this._response.getHeaders().addDateField(name, date);
    }

    public void setHeader(String name, String value) {
        this._response.getHeaders().put(name, value);
    }

    public void addHeader(String name, String value) {
        this._response.getHeaders().add(name, value);
    }

    public void setIntHeader(String name, int value) {
        this._response.getHeaders().putLongField(name, (long)value);
    }

    public void addIntHeader(String name, int value) {
        this._response.getHeaders().add(name, Integer.toString(value));
    }

    public void setStatus(int sc) {
        this._response.setStatus(sc);
    }

    public int getStatus() {
        return this._response.getStatus();
    }

    public String getHeader(String name) {
        return this._response.getHeaders().get(name);
    }

    public Collection<String> getHeaders(String name) {
        return this._response.getHeaders().getValuesList(name);
    }

    public Collection<String> getHeaderNames() {
        return this._response.getHeaders().getFieldNamesCollection();
    }

    public String getCharacterEncoding() {
        return this._response.getCharacterEncoding(false);
    }

    public String getContentType() {
        return this._response.getContentType();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._response.getOutputType() == ServletContextResponse.OutputType.WRITER) {
            throw new IllegalStateException("WRITER");
        }
        this._response.setOutputType(ServletContextResponse.OutputType.STREAM);
        return this._response.getHttpOutput();
    }

    public PrintWriter getWriter() throws IOException {
        if (this._response.getOutputType() == ServletContextResponse.OutputType.STREAM) {
            throw new IllegalStateException("STREAM");
        }
        if (this._response.getOutputType() == ServletContextResponse.OutputType.NONE) {
            String encoding = this._response.getCharacterEncoding(true);
            Locale locale = this.getLocale();
            if (this._response.getWriter() != null && this._response.getWriter().isFor(locale, encoding)) {
                this._response.getWriter().reopen();
            } else if ("iso-8859-1".equalsIgnoreCase(encoding)) {
                this._response.setWriter(new ResponseWriter(new Iso88591HttpWriter(this._response.getHttpOutput()), locale, encoding));
            } else if ("utf-8".equalsIgnoreCase(encoding)) {
                this._response.setWriter(new ResponseWriter(new Utf8HttpWriter(this._response.getHttpOutput()), locale, encoding));
            } else {
                this._response.setWriter(new ResponseWriter(new EncodingHttpWriter(this._response.getHttpOutput(), encoding), locale, encoding));
            }
            this._response.setOutputType(ServletContextResponse.OutputType.WRITER);
        }
        return this._response.getWriter();
    }

    public void setCharacterEncoding(String encoding) {
        this._response.setCharacterEncoding(encoding, ServletContextResponse.EncodingFrom.SET_CHARACTER_ENCODING);
    }

    public void setContentLength(int len) {
        if (this.isCommitted()) {
            return;
        }
        if (len > 0) {
            long written = this._response.getHttpOutput().getWritten();
            if (written > (long)len) {
                throw new IllegalArgumentException("setContentLength(" + len + ") when already written " + written);
            }
            this._response.setContentLength(len);
            this._response.getHeaders().putLongField(HttpHeader.CONTENT_LENGTH, (long)len);
            if (this._response.isAllContentWritten(written)) {
                try {
                    this._response.closeOutput();
                }
                catch (IOException e) {
                    throw new RuntimeIOException((Throwable)e);
                }
            }
        } else if (len == 0) {
            long written = this._response.getHttpOutput().getWritten();
            if (written > 0L) {
                throw new IllegalArgumentException("setContentLength(0) when already written " + written);
            }
            this._response.setContentLength(len);
            this._response.getHeaders().put(HttpHeader.CONTENT_LENGTH, "0");
        } else {
            this._response.setContentLength(len);
            this._response.getHeaders().remove(HttpHeader.CONTENT_LENGTH);
        }
    }

    public void setContentLengthLong(long len) {
        if (this.isCommitted()) {
            return;
        }
        this._response.setContentLength(len);
        this._response.getHeaders().putLongField(HttpHeader.CONTENT_LENGTH.toString(), len);
    }

    public void setContentType(String contentType) {
        block14: {
            block16: {
                String charset;
                block15: {
                    block13: {
                        if (this.isCommitted()) {
                            return;
                        }
                        if (contentType != null) break block13;
                        if (this._response.isWriting() && this._response.getCharacterEncoding() != null) {
                            throw new IllegalSelectorException();
                        }
                        if (this._response.getLocale() == null) {
                            this._response.setCharacterEncoding(null);
                        }
                        this._response.setMimeType(null);
                        this._response.setContentType(null);
                        this._response.getHeaders().remove(HttpHeader.CONTENT_TYPE);
                        break block14;
                    }
                    this._response.setContentType(contentType);
                    this._response.setMimeType((MimeTypes.Type)MimeTypes.CACHE.get(contentType));
                    charset = MimeTypes.getCharsetFromContentType((String)contentType);
                    if (charset == null && this._response.getMimeType() != null && this._response.getMimeType().isCharsetAssumed()) {
                        charset = this._response.getMimeType().getCharsetString();
                    }
                    if (charset != null) break block15;
                    switch (this._response.getEncodingFrom()) {
                        case NOT_SET: {
                            break block16;
                        }
                        case DEFAULT: 
                        case INFERRED: 
                        case SET_CONTENT_TYPE: 
                        case SET_LOCALE: 
                        case SET_CHARACTER_ENCODING: {
                            this._response.setContentType(contentType + ";charset=" + this._response.getCharacterEncoding());
                            this._response.setMimeType((MimeTypes.Type)MimeTypes.CACHE.get(this._response.getContentType()));
                            break block16;
                        }
                        default: {
                            throw new IllegalStateException(this._response.getEncodingFrom().toString());
                        }
                    }
                }
                if (this._response.isWriting() && !charset.equalsIgnoreCase(this._response.getCharacterEncoding())) {
                    this._response.setContentType(MimeTypes.getContentTypeWithoutCharset((String)this._response.getContentType()));
                    if (!(this._response.getCharacterEncoding() == null || this._response.getMimeType() != null && this._response.getMimeType().isCharsetAssumed())) {
                        this._response.setContentType(this._response.getContentType() + ";charset=" + this._response.getCharacterEncoding());
                    }
                    this._response.setMimeType((MimeTypes.Type)MimeTypes.CACHE.get(this._response.getContentType()));
                } else {
                    this._response.setRawCharacterEncoding(charset, ServletContextResponse.EncodingFrom.SET_CONTENT_TYPE);
                }
            }
            if (HttpGenerator.__STRICT || this._response.getMimeType() == null) {
                this._response.getHeaders().put(HttpHeader.CONTENT_TYPE, this._response.getContentType());
            } else {
                this._response.setContentType(this._response.getMimeType().asString());
                this._response.getHeaders().put(this._response.getMimeType().getContentTypeField());
            }
        }
    }

    public long getContentCount() {
        return this._response.getHttpOutput().getWritten();
    }

    public void setBufferSize(int size) {
        if (this.isCommitted()) {
            throw new IllegalStateException("cannot set buffer size after response is in committed state");
        }
        if (this.getContentCount() > 0L) {
            throw new IllegalStateException("cannot set buffer size after response has " + this.getContentCount() + " bytes already written");
        }
        if (size < 1) {
            size = 1;
        }
        this._response.getHttpOutput().setBufferSize(size);
    }

    public int getBufferSize() {
        return this._response.getHttpOutput().getBufferSize();
    }

    public void flushBuffer() throws IOException {
        if (!this._response.getHttpOutput().isClosed()) {
            this._response.getHttpOutput().flush();
        }
    }

    public void resetBuffer() {
        this._response.getHttpOutput().resetBuffer();
        this._response.getHttpOutput().reopen();
    }

    public boolean isCommitted() {
        if (this._response.getServletContextRequest().getServletChannel().isSendError()) {
            return true;
        }
        return this._response.getServletContextRequest().getServletChannel().isCommitted();
    }

    public void reset() {
        HttpCookie cookie;
        SessionManager sessionManager;
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        this._response.reset();
        ServletApiRequest servletApiRequest = this._response.getServletContextRequest().getServletApiRequest();
        ManagedSession session = servletApiRequest.getServletContextRequest().getManagedSession();
        if (session != null && session.isNew() && (sessionManager = servletApiRequest.getServletContextRequest().getSessionManager()) != null && (cookie = sessionManager.getSessionCookie(session, servletApiRequest.getServletConnection().isSecure())) != null) {
            this.addCookie(cookie);
        }
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        if (locale == null) {
            this._response.setLocale(null);
            this._response.getHeaders().remove(HttpHeader.CONTENT_LANGUAGE);
            if (this._response.getEncodingFrom() == ServletContextResponse.EncodingFrom.SET_LOCALE) {
                this._response.setCharacterEncoding(null, ServletContextResponse.EncodingFrom.NOT_SET);
            }
        } else {
            this._response.setLocale(locale);
            this._response.getHeaders().put(HttpHeader.CONTENT_LANGUAGE, StringUtil.replace((String)locale.toString(), (char)'_', (char)'-'));
            if (this._response.getOutputType() != ServletContextResponse.OutputType.NONE) {
                return;
            }
            ServletContextHandler.ServletScopedContext context = this._response.getServletContextRequest().getServletChannel().getContext();
            if (context == null) {
                return;
            }
            String charset = context.getServletContextHandler().getLocaleEncoding(locale);
            if (!StringUtil.isEmpty((String)charset) && LOCALE_OVERRIDE.contains((Object)this._response.getEncodingFrom())) {
                this._response.setCharacterEncoding(charset, ServletContextResponse.EncodingFrom.SET_LOCALE);
            }
        }
    }

    public Locale getLocale() {
        if (this._response.getLocale() == null) {
            return Locale.getDefault();
        }
        return this._response.getLocale();
    }

    public Supplier<Map<String, String>> getTrailerFields() {
        return this._response.getTrailers();
    }

    public void setTrailerFields(Supplier<Map<String, String>> trailers) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        HttpVersion version = HttpVersion.fromString((String)this._response.getServletContextRequest().getConnectionMetaData().getProtocol());
        if (version == null || version.compareTo((Enum)HttpVersion.HTTP_1_1) < 0) {
            throw new IllegalStateException("Trailers not supported in " + String.valueOf(version));
        }
        this._response.setTrailers(trailers);
        this._response.setTrailersSupplier(() -> {
            Map map = (Map)trailers.get();
            if (map == null) {
                return null;
            }
            HttpFields.Mutable fields = HttpFields.build((int)map.size());
            for (Map.Entry e : map.entrySet()) {
                fields.add((String)e.getKey(), (String)e.getValue());
            }
            return fields;
        });
    }

    static class HttpCookieFacade
    implements HttpCookie {
        private final Cookie _cookie;

        public HttpCookieFacade(Cookie cookie) {
            this._cookie = cookie;
        }

        public String getComment() {
            return this._cookie.getComment();
        }

        public String getDomain() {
            return this._cookie.getDomain();
        }

        public long getMaxAge() {
            return this._cookie.getMaxAge();
        }

        public String getPath() {
            return this._cookie.getPath();
        }

        public boolean isSecure() {
            return this._cookie.getSecure();
        }

        public String getName() {
            return this._cookie.getName();
        }

        public String getValue() {
            return this._cookie.getValue();
        }

        public int getVersion() {
            return this._cookie.getVersion();
        }

        public HttpCookie.SameSite getSameSite() {
            return HttpCookie.SameSite.from((String)this.getAttributes().get("SameSite"));
        }

        public boolean isHttpOnly() {
            return this._cookie.isHttpOnly();
        }

        public Map<String, String> getAttributes() {
            return Collections.emptyMap();
        }

        public int hashCode() {
            return HttpCookie.hashCode((HttpCookie)this);
        }

        public boolean equals(Object obj) {
            return HttpCookie.equals((HttpCookie)this, (Object)obj);
        }

        public String toString() {
            return HttpCookie.toString((HttpCookie)this);
        }
    }
}

