/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestAttributeEvent;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import jakarta.servlet.http.PushBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.eclipse.jetty.ee10.servlet.AsyncContextEvent;
import org.eclipse.jetty.ee10.servlet.AsyncContextState;
import org.eclipse.jetty.ee10.servlet.PushBuilderImpl;
import org.eclipse.jetty.ee10.servlet.ServletChannel;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletMultiPartFormData;
import org.eclipse.jetty.ee10.servlet.ServletRequestState;
import org.eclipse.jetty.ee10.servlet.security.Authentication;
import org.eclipse.jetty.ee10.servlet.security.UserIdentity;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.FormFields;
import org.eclipse.jetty.server.HttpCookieUtils;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Session;
import org.eclipse.jetty.session.AbstractSessionManager;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletApiRequest
implements HttpServletRequest {
    private static final Logger LOG = LoggerFactory.getLogger(ServletApiRequest.class);
    private final ServletContextRequest _request;
    private AsyncContextState _async;
    private String _characterEncoding;
    private int _inputState = 0;
    private BufferedReader _reader;
    private String _readerEncoding;
    private String _contentType;
    private boolean _contentParamsExtracted;
    private Fields _contentParameters;
    private Fields _parameters;
    private Fields _queryParameters;
    private Authentication _authentication;
    private String _method;
    private ServletMultiPartFormData.Parts _parts;
    private boolean _asyncSupported = true;

    protected ServletApiRequest(ServletContextRequest servletContextRequest) {
        this._request = servletContextRequest;
    }

    public Fields getQueryParams() {
        this.extractQueryParameters();
        return this._queryParameters;
    }

    public Fields getContentParams() {
        this.extractContentParameters();
        return this._contentParameters;
    }

    public void setAuthentication(Authentication authentication) {
        this._authentication = authentication;
    }

    public Authentication getAuthentication() {
        return this._authentication;
    }

    public String getMethod() {
        if (this._method == null) {
            return this.getServletContextRequest().getMethod();
        }
        return this._method;
    }

    public void setMethod(String method) {
        this._method = method;
    }

    public ServletContextRequest getServletContextRequest() {
        return this._request;
    }

    public HttpFields getFields() {
        return this._request.getHeaders();
    }

    public String getRequestId() {
        return this._request.getConnectionMetaData().getId() + "#" + this._request.getId();
    }

    public String getProtocolRequestId() {
        return this._request.getId();
    }

    public ServletConnection getServletConnection() {
        final ConnectionMetaData connectionMetaData = this._request.getConnectionMetaData();
        return new ServletConnection(){

            public String getConnectionId() {
                return connectionMetaData.getId();
            }

            public String getProtocol() {
                return connectionMetaData.getProtocol();
            }

            public String getProtocolConnectionId() {
                if (HttpVersion.HTTP_3.is(connectionMetaData.getProtocol())) {
                    return connectionMetaData.getId();
                }
                return "";
            }

            public boolean isSecure() {
                return connectionMetaData.isSecure();
            }
        };
    }

    public String getAuthType() {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((Request)this._request));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).getAuthMethod();
        }
        return null;
    }

    public Cookie[] getCookies() {
        List httpCookies = Request.getCookies((Request)this.getServletContextRequest());
        if (httpCookies.isEmpty()) {
            return null;
        }
        return (Cookie[])httpCookies.stream().map(this::convertCookie).toArray(Cookie[]::new);
    }

    public Cookie convertCookie(HttpCookie cookie) {
        Cookie result = new Cookie(cookie.getName(), cookie.getValue());
        if (CookieCompliance.RFC2965.equals(this.getServletContextRequest().getConnectionMetaData().getHttpConfiguration().getRequestCookieCompliance())) {
            result.setPath(cookie.getPath());
            result.setDomain(cookie.getDomain());
        }
        return result;
    }

    public long getDateHeader(String name) {
        HttpFields fields = this.getFields();
        return fields == null ? -1L : fields.getDateField(name);
    }

    public String getHeader(String name) {
        return this.getFields().get(name);
    }

    public Enumeration<String> getHeaders(String name) {
        return this.getFields().getValues(name);
    }

    public Enumeration<String> getHeaderNames() {
        return this.getFields().getFieldNames();
    }

    public int getIntHeader(String name) {
        HttpFields fields = this.getFields();
        return fields == null ? -1 : (int)fields.getLongField(name);
    }

    public String getPathInfo() {
        return this._request._matchedPath.getPathInfo();
    }

    public String getPathTranslated() {
        String pathInfo = this.getPathInfo();
        if (pathInfo == null || this._request.getContext() == null) {
            return null;
        }
        return this._request.getContext().getServletContext().getRealPath(pathInfo);
    }

    public String getContextPath() {
        return this._request.getContext().getServletContextHandler().getRequestContextPath();
    }

    public String getQueryString() {
        return this._request.getHttpURI().getQuery();
    }

    public String getRemoteUser() {
        Principal p = this.getUserPrincipal();
        if (p == null) {
            return null;
        }
        return p.getName();
    }

    public boolean isUserInRole(String role) {
        String linkedRole = this._request._mappedServlet.getServletHolder().getUserRoleLink(role);
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((Request)this._request));
        }
        if (this._authentication instanceof Authentication.User) {
            return ((Authentication.User)this._authentication).isUserInRole(linkedRole);
        }
        return false;
    }

    public Principal getUserPrincipal() {
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((Request)this._request));
        }
        if (this._authentication instanceof Authentication.User) {
            UserIdentity user = ((Authentication.User)this._authentication).getUserIdentity();
            return user.getUserPrincipal();
        }
        return null;
    }

    public String getRequestedSessionId() {
        AbstractSessionManager.RequestedSession requestedSession = this._request.getRequestedSession();
        return requestedSession == null ? null : requestedSession.sessionId();
    }

    public String getRequestURI() {
        HttpURI uri = this._request.getHttpURI();
        return uri == null ? null : uri.getPath();
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer(HttpURI.build((HttpURI)this._request.getHttpURI()).query(null).asString());
    }

    public String getServletPath() {
        return this._request._matchedPath.getPathMatch();
    }

    public HttpSession getSession(boolean create) {
        Session session = this._request.getSession(create);
        if (session == null) {
            return null;
        }
        if (session.isNew() && this.getAuthentication() instanceof Authentication.User) {
            session.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", (Object)Boolean.TRUE);
        }
        return (HttpSession)session.getApi();
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public String changeSessionId() {
        Session session = this._request.getSession(false);
        if (session == null) {
            throw new IllegalStateException("No session");
        }
        session.renewId((Request)this._request, (Response)this._request.getResponse());
        if (this.getRemoteUser() != null) {
            session.setAttribute("org.eclipse.jetty.security.sessionCreatedSecure", (Object)Boolean.TRUE);
        }
        return session.getId();
    }

    public boolean isRequestedSessionIdValid() {
        AbstractSessionManager.RequestedSession requestedSession = this._request.getRequestedSession();
        return requestedSession != null && requestedSession.sessionId() != null && !requestedSession.sessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromCookie() {
        AbstractSessionManager.RequestedSession requestedSession = this._request.getRequestedSession();
        return requestedSession != null && requestedSession.sessionId() != null && requestedSession.sessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        AbstractSessionManager.RequestedSession requestedSession = this._request.getRequestedSession();
        return requestedSession != null && requestedSession.sessionId() != null && !requestedSession.sessionIdFromCookie();
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (this.getUserPrincipal() != null && this.getRemoteUser() != null && this.getAuthType() != null) {
            return true;
        }
        if (this._authentication instanceof Authentication.Deferred) {
            this.setAuthentication(((Authentication.Deferred)this._authentication).authenticate((Request)this._request, (Response)this._request.getResponse(), this.getServletContextRequest().getServletChannel().getCallback()));
        }
        if (this._authentication instanceof Authentication.Deferred) {
            response.sendError(401);
        }
        if (!(this._authentication instanceof Authentication.ResponseSent)) {
            return false;
        }
        throw new ServletException("Authentication failed");
    }

    public void login(String username, String password) throws ServletException {
        Authentication auth;
        if (this._authentication instanceof Authentication.LoginAuthentication) {
            auth = ((Authentication.LoginAuthentication)this._authentication).login(username, password, (Request)this._request);
            if (auth == null) {
                throw new Authentication.Failed("Authentication failed for username '" + username + "'");
            }
        } else {
            throw new Authentication.Failed("Authenticated failed for username '" + username + "'. Already authenticated as " + String.valueOf(this._authentication));
        }
        this._authentication = auth;
    }

    public void logout() throws ServletException {
        if (this._authentication instanceof Authentication.LogoutAuthentication) {
            this._authentication = ((Authentication.LogoutAuthentication)this._authentication).logout((Request)this._request);
        }
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        if (this._parts == null) {
            String contentType = this.getContentType();
            if (contentType == null || !MimeTypes.Type.MULTIPART_FORM_DATA.is(HttpField.valueParameters((String)contentType, null))) {
                throw new ServletException("Unsupported Content-Type [%s], expected [%s]".formatted(contentType, MimeTypes.Type.MULTIPART_FORM_DATA.asString()));
            }
            MultipartConfigElement config = (MultipartConfigElement)this.getAttribute("org.eclipse.jetty.multipartConfig");
            if (config == null) {
                throw new IllegalStateException("No multipart config for servlet");
            }
            ServletContextHandler contextHandler = this._request.getContext().getServletContextHandler();
            int maxFormContentSize = contextHandler.getMaxFormContentSize();
            int maxFormKeys = contextHandler.getMaxFormKeys();
            this._parts = ServletMultiPartFormData.from(this, maxFormKeys);
            Collection<Part> parts = this._parts.getParts();
            String formCharset = null;
            Part charsetPart = this._parts.getPart("_charset_");
            if (charsetPart != null) {
                try (InputStream is = charsetPart.getInputStream();){
                    formCharset = IO.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                }
            }
            Charset defaultCharset = formCharset != null ? Charset.forName(formCharset) : (this.getCharacterEncoding() != null ? Charset.forName(this.getCharacterEncoding()) : StandardCharsets.UTF_8);
            long formContentSize = 0L;
            for (Part p : parts) {
                if (p.getSubmittedFileName() != null) continue;
                formContentSize = Math.addExact(formContentSize, p.getSize());
                if (maxFormContentSize >= 0 && formContentSize > (long)maxFormContentSize) {
                    throw new IllegalStateException("Form is larger than max length " + maxFormContentSize);
                }
                String charset = null;
                if (p.getContentType() != null) {
                    charset = MimeTypes.getCharsetFromContentType((String)p.getContentType());
                }
                InputStream is = p.getInputStream();
                try {
                    String content = IO.toString((InputStream)is, (Charset)(charset == null ? defaultCharset : Charset.forName(charset)));
                    if (this._contentParameters == null) {
                        this._contentParameters = new Fields();
                    }
                    this._contentParameters.add(p.getName(), content);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        return this._parts.getParts();
    }

    public Part getPart(String name) throws IOException, ServletException {
        this.getParts();
        return this._parts.getPart(name);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        return null;
    }

    public PushBuilder newPushBuilder() {
        String sessionId;
        HttpSession httpSession;
        if (!this._request.getConnectionMetaData().isPushSupported()) {
            return null;
        }
        HttpFields.Mutable pushHeaders = HttpFields.build((HttpFields)this._request.getHeaders(), EnumSet.of(HttpHeader.IF_MATCH, new HttpHeader[]{HttpHeader.IF_RANGE, HttpHeader.IF_UNMODIFIED_SINCE, HttpHeader.RANGE, HttpHeader.EXPECT, HttpHeader.IF_NONE_MATCH, HttpHeader.IF_MODIFIED_SINCE}));
        Object referrer = this.getRequestURL().toString();
        String query = this.getQueryString();
        if (query != null) {
            referrer = (String)referrer + "?" + query;
        }
        pushHeaders.put(HttpHeader.REFERER, (String)referrer);
        HttpFields.Mutable responseHeaders = this._request.getResponse().getHeaders();
        ArrayList setCookies = new ArrayList(responseHeaders.getValuesList(HttpHeader.SET_COOKIE));
        setCookies.addAll(responseHeaders.getValuesList(HttpHeader.SET_COOKIE2));
        String cookies = pushHeaders.get(HttpHeader.COOKIE);
        if (!setCookies.isEmpty()) {
            StringBuilder pushCookies = new StringBuilder();
            if (cookies != null) {
                pushCookies.append(cookies);
            }
            for (String setCookie : setCookies) {
                Map cookieFields = HttpCookieUtils.extractBasics((String)setCookie);
                String cookieName = (String)cookieFields.get("name");
                String cookieValue = (String)cookieFields.get("value");
                String cookieMaxAge = (String)cookieFields.get("max-age");
                long maxAge = cookieMaxAge != null ? Long.parseLong(cookieMaxAge) : -1L;
                if (maxAge <= 0L) continue;
                if (pushCookies.length() > 0) {
                    pushCookies.append("; ");
                }
                pushCookies.append(cookieName).append("=").append(cookieValue);
            }
            pushHeaders.put(HttpHeader.COOKIE, pushCookies.toString());
        }
        if ((httpSession = this.getSession(false)) != null) {
            try {
                httpSession.getLastAccessedTime();
                sessionId = httpSession.getId();
            }
            catch (Throwable x) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("invalid HTTP session", x);
                }
                sessionId = this.getRequestedSessionId();
            }
        } else {
            sessionId = this.getRequestedSessionId();
        }
        return new PushBuilderImpl(this._request, pushHeaders, sessionId);
    }

    public Object getAttribute(String name) {
        if (this._async != null) {
            switch (name) {
                case "jakarta.servlet.async.request_uri": {
                    return this.getRequestURI();
                }
                case "jakarta.servlet.async.context_path": {
                    return this.getContextPath();
                }
                case "jakarta.servlet.async.servlet_path": {
                    return this.getServletPath();
                }
                case "jakarta.servlet.async.path_info": {
                    return this.getPathInfo();
                }
                case "jakarta.servlet.async.query_string": {
                    return this.getQueryString();
                }
                case "jakarta.servlet.async.mapping": {
                    return this.getHttpServletMapping();
                }
            }
        }
        return this._request.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        HashSet<String> set = this._request.getAttributeNameSet();
        if (this._async != null) {
            set = new HashSet<String>(set);
            set.add("jakarta.servlet.async.request_uri");
            set.add("jakarta.servlet.async.context_path");
            set.add("jakarta.servlet.async.servlet_path");
            set.add("jakarta.servlet.async.path_info");
            set.add("jakarta.servlet.async.query_string");
            set.add("jakarta.servlet.async.mapping");
        }
        return Collections.enumeration(set);
    }

    public String getCharacterEncoding() {
        if (this._characterEncoding == null) {
            String contentType;
            if (this._request.getContext() != null) {
                this._characterEncoding = this._request.getContext().getServletContext().getRequestCharacterEncoding();
            }
            if (this._characterEncoding == null && (contentType = this.getContentType()) != null) {
                String charset;
                MimeTypes.Type mime = (MimeTypes.Type)MimeTypes.CACHE.get(contentType);
                String string = charset = mime == null || mime.getCharset() == null ? MimeTypes.getCharsetFromContentType((String)contentType) : mime.getCharset().toString();
                if (charset != null) {
                    this._characterEncoding = charset;
                }
            }
        }
        return this._characterEncoding;
    }

    public void setCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        if (this._inputState != 0) {
            return;
        }
        this._characterEncoding = encoding;
        if (!StringUtil.isUTF8((String)encoding)) {
            try {
                Charset.forName(encoding);
            }
            catch (UnsupportedCharsetException e) {
                throw new UnsupportedEncodingException(e.getMessage());
            }
        }
    }

    public int getContentLength() {
        long contentLength = this.getContentLengthLong();
        if (contentLength > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)contentLength;
    }

    public long getContentLengthLong() {
        if (this.getFields() == null) {
            return -1L;
        }
        return this.getFields().getLongField(HttpHeader.CONTENT_LENGTH);
    }

    public String getContentType() {
        if (this._contentType == null) {
            this._contentType = this.getFields().get(HttpHeader.CONTENT_TYPE);
        }
        return this._contentType;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this._inputState != 0 && this._inputState != 1) {
            throw new IllegalStateException("READER");
        }
        this._inputState = 1;
        if (this._request.getServletChannel().isExpecting100Continue()) {
            this._request.getServletChannel().continue100(this._request.getHttpInput().available());
        }
        return this._request.getHttpInput();
    }

    public String getParameter(String name) {
        return this.getParameters().getValue(name);
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameters().getNames());
    }

    public String[] getParameterValues(String name) {
        List vals = this.getParameters().getValues(name);
        if (vals == null) {
            return null;
        }
        return vals.toArray(new String[0]);
    }

    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.getParameters().toStringArrayMap());
    }

    public Fields getContentParameters() {
        this.getParameters();
        return this._contentParameters;
    }

    public void setContentParameters(Fields params) {
        this._contentParameters = params == null || params.getSize() == 0 ? ServletContextRequest.NO_PARAMS : params;
    }

    private Fields getParameters() {
        this.extractContentParameters();
        this.extractQueryParameters();
        if (ServletContextRequest.isNoParams(this._queryParameters) || this._queryParameters.getSize() == 0) {
            this._parameters = this._contentParameters;
        } else if (ServletContextRequest.isNoParams(this._contentParameters) || this._contentParameters.getSize() == 0) {
            this._parameters = this._queryParameters;
        } else if (this._parameters == null) {
            this._parameters = new Fields(this._queryParameters, false);
            this._contentParameters.forEach(arg_0 -> ((Fields)this._parameters).add(arg_0));
        }
        Fields parameters = this._parameters;
        return parameters == null ? ServletContextRequest.NO_PARAMS : parameters;
    }

    private void extractContentParameters() throws BadMessageException {
        if (!this._contentParamsExtracted) {
            this._contentParamsExtracted = true;
            if (this._contentParameters == null) {
                try {
                    int contentLength = this.getContentLength();
                    if (contentLength != 0 && this._inputState == 0) {
                        String baseType = HttpField.valueParameters((String)this.getContentType(), null);
                        if (MimeTypes.Type.FORM_ENCODED.is(baseType) && this._request.getConnectionMetaData().getHttpConfiguration().isFormEncodedMethod(this.getMethod())) {
                            try {
                                int maxKeys = this._request.getServletRequestState().getContextHandler().getMaxFormKeys();
                                int maxContentSize = this._request.getServletRequestState().getContextHandler().getMaxFormContentSize();
                                this._contentParameters = (Fields)FormFields.from((Request)this.getServletContextRequest(), (int)maxKeys, (int)maxContentSize).get();
                            }
                            catch (IllegalArgumentException | IllegalStateException | InterruptedException | ExecutionException e) {
                                LOG.warn(e.toString());
                                throw new BadMessageException("Unable to parse form content", (Throwable)e);
                            }
                        }
                        if (MimeTypes.Type.MULTIPART_FORM_DATA.is(baseType) && this.getAttribute("org.eclipse.jetty.multipartConfig") != null) {
                            try {
                                this.getParts();
                            }
                            catch (ServletException | IOException e) {
                                String msg = "Unable to extract content parameters";
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug(msg, e);
                                }
                                throw new RuntimeIOException(msg, e);
                            }
                        }
                    }
                    if (this._contentParameters == null || this._contentParameters.isEmpty()) {
                        this._contentParameters = ServletContextRequest.NO_PARAMS;
                    }
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    LOG.warn(e.toString());
                    throw new BadMessageException("Unable to parse form content", (Throwable)e);
                }
            }
        }
    }

    private void extractQueryParameters() throws BadMessageException {
        if (this._queryParameters == null) {
            HttpURI httpURI = this._request.getHttpURI();
            if (httpURI == null || StringUtil.isEmpty((String)httpURI.getQuery())) {
                this._queryParameters = ServletContextRequest.NO_PARAMS;
            } else {
                try {
                    this._queryParameters = Request.extractQueryParameters((Request)this._request, (Charset)this._request.getQueryEncoding());
                }
                catch (IllegalArgumentException | IllegalStateException e) {
                    this._queryParameters = ServletContextRequest.BAD_PARAMS;
                    throw new BadMessageException("Unable to parse URI query", (Throwable)e);
                }
            }
        }
    }

    public String getProtocol() {
        return this._request.getConnectionMetaData().getProtocol();
    }

    public String getScheme() {
        return this._request.getHttpURI().getScheme();
    }

    public String getServerName() {
        HttpURI uri = this._request.getHttpURI();
        if (uri != null && StringUtil.isNotBlank((String)uri.getAuthority())) {
            return this.formatAddrOrHost(uri.getHost());
        }
        return this.findServerName();
    }

    private String formatAddrOrHost(String name) {
        ServletChannel servletChannel = this._request.getServletChannel();
        return servletChannel == null ? HostPort.normalizeHost((String)name) : servletChannel.formatAddrOrHost(name);
    }

    private String findServerName() {
        HostPort serverAuthority;
        ServletChannel servletChannel = this._request.getServletChannel();
        if (servletChannel != null && (serverAuthority = servletChannel.getServerAuthority()) != null) {
            return this.formatAddrOrHost(serverAuthority.getHost());
        }
        String name = this.getLocalName();
        if (name != null) {
            return this.formatAddrOrHost(name);
        }
        return "";
    }

    public int getServerPort() {
        int port = -1;
        HttpURI uri = this._request.getHttpURI();
        port = uri != null && StringUtil.isNotBlank((String)uri.getAuthority()) ? uri.getPort() : this.findServerPort();
        if (port <= 0) {
            return HttpScheme.getDefaultPort((String)this.getScheme());
        }
        return port;
    }

    private int findServerPort() {
        HostPort serverAuthority;
        ServletChannel servletChannel = this._request.getServletChannel();
        if (servletChannel != null && (serverAuthority = servletChannel.getServerAuthority()) != null) {
            return serverAuthority.getPort();
        }
        return this.getLocalPort();
    }

    public BufferedReader getReader() throws IOException {
        if (this._inputState != 0 && this._inputState != 2) {
            throw new IllegalStateException("STREAMED");
        }
        if (this._inputState == 2) {
            return this._reader;
        }
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            encoding = "iso-8859-1";
        }
        if (this._reader == null || !encoding.equalsIgnoreCase(this._readerEncoding)) {
            final ServletInputStream in = this.getInputStream();
            this._readerEncoding = encoding;
            this._reader = new BufferedReader(new InputStreamReader((InputStream)in, encoding)){

                @Override
                public void close() throws IOException {
                    in.close();
                }
            };
        } else if (this._request.getServletChannel().isExpecting100Continue()) {
            this._request.getServletChannel().continue100(this._request.getHttpInput().available());
        }
        this._inputState = 2;
        return this._reader;
    }

    public String getRemoteAddr() {
        return Request.getRemoteAddr((Request)this._request);
    }

    public String getRemoteHost() {
        return Request.getRemoteAddr((Request)this._request);
    }

    public void setAttribute(String name, Object attribute) {
        Object oldValue = this._request.setAttribute(name, attribute);
        if ("org.eclipse.jetty.server.Request.queryEncoding".equals(name)) {
            this._request.setQueryEncoding(attribute == null ? null : attribute.toString());
        }
        if (!this._request.getRequestAttributeListeners().isEmpty()) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this._request.getContext().getServletContext(), (ServletRequest)this, name, oldValue == null ? attribute : oldValue);
            for (ServletRequestAttributeListener l : this._request.getRequestAttributeListeners()) {
                if (oldValue == null) {
                    l.attributeAdded(event);
                    continue;
                }
                if (attribute == null) {
                    l.attributeRemoved(event);
                    continue;
                }
                l.attributeReplaced(event);
            }
        }
    }

    public void removeAttribute(String name) {
        Object oldValue = this._request.removeAttribute(name);
        if (oldValue != null && !this._request.getRequestAttributeListeners().isEmpty()) {
            ServletRequestAttributeEvent event = new ServletRequestAttributeEvent((ServletContext)this._request.getContext().getServletContext(), (ServletRequest)this, name, oldValue);
            for (ServletRequestAttributeListener listener : this._request.getRequestAttributeListeners()) {
                listener.attributeRemoved(event);
            }
        }
    }

    public Locale getLocale() {
        return (Locale)Request.getLocales((Request)this._request).get(0);
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(Request.getLocales((Request)this._request));
    }

    public boolean isSecure() {
        return this._request.getConnectionMetaData().isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        ServletContextHandler.ServletScopedContext context = this._request.getContext();
        if (path == null || context == null) {
            return null;
        }
        if (!path.startsWith("/")) {
            String relTo = this._request.getPathInContext();
            int slash = relTo.lastIndexOf("/");
            relTo = slash > 1 ? relTo.substring(0, slash + 1) : "/";
            path = URIUtil.addPaths((String)relTo, (String)path);
        }
        return context.getServletContext().getRequestDispatcher(path);
    }

    public int getRemotePort() {
        return Request.getRemotePort((Request)this._request);
    }

    public String getLocalName() {
        ServletChannel servletChannel = this._request.getServletChannel();
        if (servletChannel != null) {
            String localName = servletChannel.getLocalName();
            return this.formatAddrOrHost(localName);
        }
        return "";
    }

    public String getLocalAddr() {
        return Request.getLocalAddr((Request)this._request);
    }

    public int getLocalPort() {
        return Request.getLocalPort((Request)this._request);
    }

    public ServletContext getServletContext() {
        return this._request.getServletChannel().getServletContext();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException("Async Not Supported");
        }
        ServletRequestState state = this._request.getState();
        if (this._async == null) {
            this._async = new AsyncContextState(state);
        }
        AsyncContextEvent event = new AsyncContextEvent(this._request.getContext(), this._async, state, (ServletRequest)this, (ServletResponse)this._request.getResponse().getHttpServletResponse());
        state.startAsync(event);
        return this._async;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException("Async Not Supported");
        }
        ServletRequestState state = this._request.getState();
        if (this._async == null) {
            this._async = new AsyncContextState(state);
        }
        AsyncContextEvent event = new AsyncContextEvent(this._request.getContext(), this._async, state, servletRequest, servletResponse);
        state.startAsync(event);
        return this._async;
    }

    public HttpServletMapping getHttpServletMapping() {
        return this._request._mappedServlet.getServletPathMapping(this._request.getPathInContext());
    }

    public boolean isAsyncStarted() {
        return this._request.getState().isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this._asyncSupported;
    }

    public void setAsyncSupported(boolean asyncSupported) {
        this._asyncSupported = asyncSupported;
    }

    public AsyncContext getAsyncContext() {
        ServletRequestState state = this._request.getServletChannel().getState();
        if (this._async == null || !state.isAsyncStarted()) {
            throw new IllegalStateException(state.getStatusString());
        }
        return this._async;
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    public Map<String, String> getTrailerFields() {
        HttpFields trailers = this._request.getTrailers();
        if (trailers == null) {
            return Map.of();
        }
        HashMap<String, String> trailersMap = new HashMap<String, String>();
        for (HttpField field : trailers) {
            String key = field.getLowerCaseName();
            trailersMap.merge(key, field.getValue(), (existing, value) -> existing + "," + value);
        }
        return trailersMap;
    }
}

