/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.ee10.servlet.AsyncContentProducer;
import org.eclipse.jetty.ee10.servlet.BlockingContentProducer;
import org.eclipse.jetty.ee10.servlet.ContentProducer;
import org.eclipse.jetty.ee10.servlet.ServletChannel;
import org.eclipse.jetty.ee10.servlet.ServletRequestState;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpInput
extends ServletInputStream
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpInput.class);
    final AutoLock _lock = new AutoLock();
    private final ServletChannel _servletChannel;
    private final ServletRequestState _channelState;
    private final byte[] _oneByteBuffer = new byte[1];
    private final BlockingContentProducer _blockingContentProducer;
    private final AsyncContentProducer _asyncContentProducer;
    private final LongAdder _contentConsumed = new LongAdder();
    private volatile ContentProducer _contentProducer;
    private volatile boolean _consumedEof;
    private volatile ReadListener _readListener;

    public HttpInput(ServletChannel channel) {
        this._servletChannel = channel;
        this._channelState = this._servletChannel.getState();
        this._asyncContentProducer = new AsyncContentProducer(this._servletChannel, this._lock);
        this._blockingContentProducer = new BlockingContentProducer(this._asyncContentProducer);
        this._contentProducer = this._blockingContentProducer;
    }

    public void recycle() {
        try (AutoLock lock = this._lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("recycle {}", (Object)this);
            }
            this._blockingContentProducer.recycle();
            this._contentProducer = this._blockingContentProducer;
        }
    }

    public void reopen() {
        try (AutoLock lock = this._lock.lock();){
            if (LOG.isDebugEnabled()) {
                LOG.debug("reopen {}", (Object)this);
            }
            this._blockingContentProducer.reopen();
            this._contentProducer = this._blockingContentProducer;
            this._consumedEof = false;
            this._readListener = null;
            this._contentConsumed.reset();
        }
    }

    private int get(Content.Chunk chunk, byte[] bytes, int offset, int length) {
        length = Math.min(chunk.remaining(), length);
        chunk.getByteBuffer().get(bytes, offset, length);
        this._contentConsumed.add(length);
        return length;
    }

    private int get(Content.Chunk chunk, ByteBuffer des) {
        int capacity = des.remaining();
        ByteBuffer src = chunk.getByteBuffer();
        if (src.remaining() > capacity) {
            int limit = src.limit();
            src.limit(src.position() + capacity);
            des.put(src);
            src.limit(limit);
        } else {
            des.put(src);
        }
        int consumed = capacity - des.remaining();
        this._contentConsumed.add(consumed);
        return consumed;
    }

    public long getContentConsumed() {
        return this._contentConsumed.sum();
    }

    public long getContentReceived() {
        try (AutoLock lock = this._lock.lock();){
            long l = this._contentProducer.getBytesArrived();
            return l;
        }
    }

    public boolean consumeAvailable() {
        try (AutoLock lock = this._lock.lock();){
            boolean atEof;
            if (LOG.isDebugEnabled()) {
                LOG.debug("consumeAll {}", (Object)this);
            }
            if (atEof = this._contentProducer.consumeAvailable()) {
                this._consumedEof = true;
            }
            if (this.isFinished()) {
                boolean bl = !this.isError();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public boolean isError() {
        try (AutoLock lock = this._lock.lock();){
            boolean error = this._contentProducer.isError();
            if (LOG.isDebugEnabled()) {
                LOG.debug("isError={} {}", (Object)error, (Object)this);
            }
            boolean bl = error;
            return bl;
        }
    }

    public boolean isAsync() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("isAsync read listener {} {}", (Object)this._readListener, (Object)this);
        }
        return this._readListener != null;
    }

    public boolean isFinished() {
        boolean finished = this._consumedEof;
        if (LOG.isDebugEnabled()) {
            LOG.debug("isFinished={} {}", (Object)finished, (Object)this);
        }
        return finished;
    }

    public boolean isReady() {
        try (AutoLock lock = this._lock.lock();){
            boolean ready = this._contentProducer.isReady();
            if (LOG.isDebugEnabled()) {
                LOG.debug("isReady={} {}", (Object)ready, (Object)this);
            }
            boolean bl = ready;
            return bl;
        }
    }

    public void setReadListener(ReadListener readListener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setting read listener to {} {}", (Object)readListener, (Object)this);
        }
        if (this._readListener != null) {
            throw new IllegalStateException("ReadListener already set");
        }
        if (!this._channelState.isAsyncStarted()) {
            throw new IllegalStateException("Async not started");
        }
        this._readListener = Objects.requireNonNull(readListener);
        this._contentProducer = this._asyncContentProducer;
        if (this.isReady() && this._channelState.onReadEof()) {
            this.scheduleReadListenerNotification();
        }
    }

    public boolean onContentProducible() {
        try (AutoLock lock = this._lock.lock();){
            boolean bl = this._contentProducer.onContentProducible();
            return bl;
        }
    }

    public int read() throws IOException {
        try (AutoLock lock = this._lock.lock();){
            int read = this.read(this._oneByteBuffer, 0, 1);
            if (read == 0) {
                throw new IOException("unready read=0");
            }
            int n = read < 0 ? -1 : this._oneByteBuffer[0] & 0xFF;
            return n;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.read(null, b, off, len);
    }

    public int read(ByteBuffer buffer) throws IOException {
        return this.read(buffer, null, -1, -1);
    }

    private int read(ByteBuffer buffer, byte[] b, int off, int len) throws IOException {
        try (AutoLock lock = this._lock.lock();){
            if (len == 0) {
                int n = 0;
                return n;
            }
            this._contentProducer.checkMinDataRate();
            Content.Chunk chunk = this._contentProducer.nextChunk();
            if (chunk == null) {
                throw new IllegalStateException("read on unready input");
            }
            if (chunk.hasRemaining()) {
                int read;
                int n = read = buffer == null ? this.get(chunk, b, off, len) : this.get(chunk, buffer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("read produced {} byte(s) {}", (Object)read, (Object)this);
                }
                if (!chunk.hasRemaining()) {
                    this._contentProducer.reclaim(chunk);
                }
                int n2 = read;
                return n2;
            }
            if (chunk instanceof Content.Chunk.Error) {
                Content.Chunk.Error errorChunk = (Content.Chunk.Error)chunk;
                Throwable error = errorChunk.getCause();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("read error={} {}", (Object)error, (Object)this);
                }
                if (error instanceof IOException) {
                    throw (IOException)error;
                }
                throw new IOException(error);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("read at EOF, setting consumed EOF to true {}", (Object)this);
            }
            this._consumedEof = true;
            if (this.onContentProducible()) {
                this.scheduleReadListenerNotification();
            }
            int n = -1;
            return n;
        }
    }

    private void scheduleReadListenerNotification() {
        this._servletChannel.execute(this._servletChannel::handle);
    }

    public boolean hasContent() {
        try (AutoLock lock = this._lock.lock();){
            boolean hasContent = this._contentProducer.hasChunk();
            if (LOG.isDebugEnabled()) {
                LOG.debug("hasContent={} {}", (Object)hasContent, (Object)this);
            }
            boolean bl = hasContent;
            return bl;
        }
    }

    public int available() {
        try (AutoLock lock = this._lock.lock();){
            int available = this._contentProducer.available();
            if (LOG.isDebugEnabled()) {
                LOG.debug("available={} {}", (Object)available, (Object)this);
            }
            int n = available;
            return n;
        }
    }

    @Override
    public void run() {
        Content.Chunk chunk;
        try (AutoLock lock = this._lock.lock();){
            if (!this._contentProducer.isReady()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("running but not ready {}", (Object)this);
                }
                return;
            }
            chunk = this._contentProducer.nextChunk();
            if (LOG.isDebugEnabled()) {
                LOG.debug("running on content {} {}", (Object)chunk, (Object)this);
            }
        }
        if (this._readListener == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("running without a read listener {}", (Object)this);
            }
            this.onContentProducible();
            return;
        }
        if (chunk instanceof Content.Chunk.Error) {
            Content.Chunk.Error errorChunk = (Content.Chunk.Error)chunk;
            Throwable error = errorChunk.getCause();
            if (LOG.isDebugEnabled()) {
                LOG.debug("running error={} {}", (Object)error, (Object)this);
            }
            this._servletChannel.getResponse().getHeaders().add(HttpFields.CONNECTION_CLOSE);
            this._readListener.onError(error);
        } else if (chunk.isLast() && !chunk.hasRemaining()) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("running at EOF {}", (Object)this);
                }
                this._readListener.onAllDataRead();
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("running failed onAllDataRead {}", (Object)this, (Object)x);
                }
                this._readListener.onError(x);
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("running has content {}", (Object)this);
            }
            try {
                this._readListener.onDataAvailable();
            }
            catch (Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("running failed onDataAvailable {}", (Object)this, (Object)x);
                }
                this._readListener.onError(x);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.hashCode() + " cs=" + String.valueOf(this._channelState) + " cp=" + String.valueOf(this._contentProducer) + " eof=" + this._consumedEof;
    }
}

