/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletMapping;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.ee10.servlet.ServletHandler;
import org.eclipse.jetty.ee10.servlet.ServletPathMapping;
import org.eclipse.jetty.ee10.servlet.ServletRequestHttpWrapper;
import org.eclipse.jetty.ee10.servlet.ServletResponseHttpWrapper;
import org.eclipse.jetty.ee10.servlet.util.ServletOutputStreamWrapper;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.pathmap.MatchedResource;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dispatcher
implements RequestDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(Dispatcher.class);
    public static final String __INCLUDE_PREFIX = "jakarta.servlet.include.";
    public static final String __FORWARD_PREFIX = "jakarta.servlet.forward.";
    public static final String __ORIGINAL_REQUEST = "org.eclipse.jetty.originalRequest";
    private final ServletContextHandler _contextHandler;
    private final HttpURI _uri;
    private final String _pathInContext;
    private final String _named;
    private final ServletHandler.MappedServlet _mappedServlet;
    private final ServletHandler _servletHandler;
    private final ServletPathMapping _servletPathMapping;

    public Dispatcher(ServletContextHandler contextHandler, HttpURI uri, String pathInContext) {
        this._contextHandler = contextHandler;
        this._uri = uri.asImmutable();
        this._pathInContext = pathInContext;
        this._named = null;
        this._servletHandler = this._contextHandler.getServletHandler();
        MatchedResource<ServletHandler.MappedServlet> matchedServlet = this._servletHandler.getMatchedServlet(pathInContext);
        this._mappedServlet = (ServletHandler.MappedServlet)matchedServlet.getResource();
        this._servletPathMapping = this._mappedServlet.getServletPathMapping(this._pathInContext, matchedServlet.getMatchedPath());
    }

    public Dispatcher(ServletContextHandler contextHandler, String name) throws IllegalStateException {
        this._contextHandler = contextHandler;
        this._uri = null;
        this._pathInContext = null;
        this._named = name;
        this._servletHandler = this._contextHandler.getServletHandler();
        this._mappedServlet = this._servletHandler.getMappedServlet(name);
        this._servletPathMapping = null;
    }

    public void error(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest httpRequest = request instanceof HttpServletRequest ? (HttpServletRequest)request : new ServletRequestHttpWrapper(request);
        HttpServletResponse httpResponse = response instanceof HttpServletResponse ? (HttpServletResponse)response : new ServletResponseHttpWrapper(response);
        this._mappedServlet.handle(this._servletHandler, this._pathInContext, (HttpServletRequest)new ErrorRequest(httpRequest), httpResponse);
    }

    public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest httpRequest = request instanceof HttpServletRequest ? (HttpServletRequest)request : new ServletRequestHttpWrapper(request);
        HttpServletResponse httpResponse = response instanceof HttpServletResponse ? (HttpServletResponse)response : new ServletResponseHttpWrapper(response);
        ServletContextRequest servletContextRequest = ServletContextRequest.getServletContextRequest(request);
        servletContextRequest.getResponse().resetForForward();
        this._mappedServlet.handle(this._servletHandler, this._pathInContext, (HttpServletRequest)new ForwardRequest(httpRequest), httpResponse);
        if (!servletContextRequest.getState().isAsync() && !servletContextRequest.getHttpOutput().isClosed()) {
            try {
                response.getOutputStream().close();
            }
            catch (IllegalStateException e) {
                response.getWriter().close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest httpRequest = request instanceof HttpServletRequest ? (HttpServletRequest)request : new ServletRequestHttpWrapper(request);
        HttpServletResponse httpResponse = response instanceof HttpServletResponse ? (HttpServletResponse)response : new ServletResponseHttpWrapper(response);
        ServletContextResponse servletContextResponse = ServletContextResponse.getServletContextResponse(response);
        try {
            this._mappedServlet.handle(this._servletHandler, this._pathInContext, (HttpServletRequest)new IncludeRequest(httpRequest), (HttpServletResponse)new IncludeResponse(httpResponse));
        }
        finally {
            servletContextResponse.included();
        }
    }

    public void async(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest httpRequest = request instanceof HttpServletRequest ? (HttpServletRequest)request : new ServletRequestHttpWrapper(request);
        HttpServletResponse httpResponse = response instanceof HttpServletResponse ? (HttpServletResponse)response : new ServletResponseHttpWrapper(response);
        this._mappedServlet.handle(this._servletHandler, this._pathInContext, (HttpServletRequest)new AsyncRequest(httpRequest), httpResponse);
    }

    public String toString() {
        return String.format("Dispatcher@0x%x{%s,%s}", this.hashCode(), this._named, this._uri);
    }

    private class ErrorRequest
    extends ParameterRequestWrapper {
        private final HttpServletRequest _httpServletRequest;

        public ErrorRequest(HttpServletRequest httpRequest) {
            super(httpRequest);
            this._httpServletRequest = httpRequest;
        }

        public DispatcherType getDispatcherType() {
            return DispatcherType.ERROR;
        }

        public String getPathInfo() {
            return Dispatcher.this._servletPathMapping.getPathInfo();
        }

        public String getServletPath() {
            return Dispatcher.this._servletPathMapping.getServletPath();
        }

        public String getQueryString() {
            String targetQuery;
            if (Dispatcher.this._uri != null && !StringUtil.isEmpty((String)(targetQuery = Dispatcher.this._uri.getQuery()))) {
                return targetQuery;
            }
            return this._httpServletRequest.getQueryString();
        }

        public String getRequestURI() {
            return Dispatcher.this._uri == null ? null : Dispatcher.this._uri.getPath();
        }

        public Object getAttribute(String name) {
            switch (name) {
                default: 
            }
            return super.getAttribute(name);
        }

        public Enumeration<String> getAttributeNames() {
            ArrayList names = new ArrayList(Collections.list(super.getAttributeNames()));
            return Collections.enumeration(names);
        }
    }

    private class ForwardRequest
    extends ParameterRequestWrapper {
        private final HttpServletRequest _httpServletRequest;

        public ForwardRequest(HttpServletRequest httpRequest) {
            super(httpRequest);
            this._httpServletRequest = httpRequest;
        }

        public DispatcherType getDispatcherType() {
            return DispatcherType.FORWARD;
        }

        public String getPathInfo() {
            if (Dispatcher.this._servletPathMapping == null) {
                return super.getPathInfo();
            }
            return Dispatcher.this._servletPathMapping.getPathInfo();
        }

        public String getServletPath() {
            if (Dispatcher.this._servletPathMapping == null) {
                return super.getServletPath();
            }
            return Dispatcher.this._servletPathMapping.getServletPath();
        }

        public HttpServletMapping getHttpServletMapping() {
            return Dispatcher.this._servletPathMapping;
        }

        public String getQueryString() {
            String targetQuery;
            if (Dispatcher.this._uri != null && !StringUtil.isEmpty((String)(targetQuery = Dispatcher.this._uri.getQuery()))) {
                return targetQuery;
            }
            return this._httpServletRequest.getQueryString();
        }

        public String getRequestURI() {
            return Dispatcher.this._uri == null ? super.getRequestURI() : Dispatcher.this._uri.getPath();
        }

        public Object getAttribute(String name) {
            if (name == null) {
                return null;
            }
            if (Dispatcher.this._named != null && name.startsWith(Dispatcher.__FORWARD_PREFIX)) {
                return null;
            }
            if (name.startsWith(Dispatcher.__FORWARD_PREFIX)) {
                HttpServletRequest originalRequest = (HttpServletRequest)super.getAttribute(Dispatcher.__ORIGINAL_REQUEST);
                if (originalRequest == null) {
                    originalRequest = this._httpServletRequest;
                }
                switch (name) {
                    case "jakarta.servlet.forward.request_uri": {
                        return originalRequest.getRequestURI();
                    }
                    case "jakarta.servlet.forward.servlet_path": {
                        return originalRequest.getServletPath();
                    }
                    case "jakarta.servlet.forward.path_info": {
                        return originalRequest.getPathInfo();
                    }
                    case "jakarta.servlet.forward.context_path": {
                        return originalRequest.getContextPath();
                    }
                    case "jakarta.servlet.forward.mapping": {
                        return originalRequest.getHttpServletMapping();
                    }
                    case "jakarta.servlet.forward.query_string": {
                        return originalRequest.getQueryString();
                    }
                }
                return super.getAttribute(name);
            }
            switch (name) {
                case "org.eclipse.jetty.originalRequest": {
                    HttpServletRequest originalRequest = (HttpServletRequest)super.getAttribute(name);
                    return originalRequest == null ? this._httpServletRequest : originalRequest;
                }
                case "jakarta.servlet.include.mapping": 
                case "jakarta.servlet.include.servlet_path": 
                case "jakarta.servlet.include.path_info": 
                case "jakarta.servlet.include.request_uri": 
                case "jakarta.servlet.include.context_path": 
                case "jakarta.servlet.include.query_string": {
                    return null;
                }
            }
            return super.getAttribute(name);
        }

        public Enumeration<String> getAttributeNames() {
            ArrayList names = new ArrayList(Collections.list(super.getAttributeNames()));
            if (Dispatcher.this._named != null) {
                return Collections.enumeration(names);
            }
            names.add("jakarta.servlet.forward.request_uri");
            names.add("jakarta.servlet.forward.servlet_path");
            names.add("jakarta.servlet.forward.path_info");
            names.add("jakarta.servlet.forward.context_path");
            names.add("jakarta.servlet.forward.mapping");
            names.add("jakarta.servlet.forward.query_string");
            return Collections.enumeration(names);
        }
    }

    private class IncludeRequest
    extends ParameterRequestWrapper {
        private final HttpServletRequest _httpServletRequest;

        public IncludeRequest(HttpServletRequest request) {
            super(request);
            this._httpServletRequest = request;
        }

        public DispatcherType getDispatcherType() {
            return DispatcherType.INCLUDE;
        }

        public Object getAttribute(String name) {
            if (name == null) {
                return null;
            }
            if (Dispatcher.this._named != null && name.startsWith(Dispatcher.__INCLUDE_PREFIX)) {
                return null;
            }
            switch (name) {
                case "jakarta.servlet.include.mapping": {
                    return Dispatcher.this._servletPathMapping;
                }
                case "jakarta.servlet.include.servlet_path": {
                    return Dispatcher.this._servletPathMapping.getServletPath();
                }
                case "jakarta.servlet.include.path_info": {
                    return Dispatcher.this._servletPathMapping.getPathInfo();
                }
                case "jakarta.servlet.include.request_uri": {
                    return Dispatcher.this._uri == null ? null : Dispatcher.this._uri.getPath();
                }
                case "jakarta.servlet.include.context_path": {
                    return this._httpServletRequest.getContextPath();
                }
                case "jakarta.servlet.include.query_string": {
                    return Dispatcher.this._uri == null ? null : Dispatcher.this._uri.getQuery();
                }
            }
            return super.getAttribute(name);
        }

        public Enumeration<String> getAttributeNames() {
            ArrayList names = new ArrayList(Collections.list(super.getAttributeNames()));
            if (Dispatcher.this._named != null) {
                return Collections.enumeration(names);
            }
            names.add("jakarta.servlet.include.mapping");
            names.add("jakarta.servlet.include.servlet_path");
            names.add("jakarta.servlet.include.path_info");
            names.add("jakarta.servlet.include.request_uri");
            names.add("jakarta.servlet.include.context_path");
            names.add("jakarta.servlet.include.query_string");
            return Collections.enumeration(names);
        }
    }

    private static class IncludeResponse
    extends HttpServletResponseWrapper {
        public static final String JETTY_INCLUDE_HEADER_PREFIX = "org.eclipse.jetty.server.include.";

        public IncludeResponse(HttpServletResponse response) {
            super(response);
        }

        public ServletOutputStream getOutputStream() throws IOException {
            return new ServletOutputStreamWrapper(this.getResponse().getOutputStream()){

                @Override
                public void close() throws IOException {
                }
            };
        }

        public void setCharacterEncoding(String charset) {
        }

        public void setContentLength(int len) {
        }

        public void setContentLengthLong(long len) {
        }

        public void setContentType(String type) {
        }

        public void reset() {
            super.reset();
        }

        public void resetBuffer() {
            super.resetBuffer();
        }

        public void setDateHeader(String name, long date) {
        }

        public void addDateHeader(String name, long date) {
        }

        public void setHeader(String name, String value) {
            if (!StringUtil.isBlank((String)name) && name.startsWith(JETTY_INCLUDE_HEADER_PREFIX)) {
                super.setHeader(name.substring(JETTY_INCLUDE_HEADER_PREFIX.length()), value);
            }
        }

        public void addHeader(String name, String value) {
            if (!StringUtil.isBlank((String)name) && name.startsWith(JETTY_INCLUDE_HEADER_PREFIX)) {
                super.addHeader(name.substring(JETTY_INCLUDE_HEADER_PREFIX.length()), value);
            }
        }

        public void setIntHeader(String name, int value) {
        }

        public void addIntHeader(String name, int value) {
        }

        public void setStatus(int sc) {
        }
    }

    private class AsyncRequest
    extends ParameterRequestWrapper {
        private final HttpServletRequest _httpServletRequest;

        public AsyncRequest(HttpServletRequest httpRequest) {
            super(httpRequest);
            this._httpServletRequest = httpRequest;
            Objects.requireNonNull(Dispatcher.this._servletPathMapping);
        }

        public DispatcherType getDispatcherType() {
            return DispatcherType.ASYNC;
        }

        public String getPathInfo() {
            return Objects.requireNonNull(Dispatcher.this._servletPathMapping).getPathInfo();
        }

        public String getServletPath() {
            return Objects.requireNonNull(Dispatcher.this._servletPathMapping).getServletPath();
        }

        public HttpServletMapping getHttpServletMapping() {
            return Objects.requireNonNull(Dispatcher.this._servletPathMapping);
        }

        public String getQueryString() {
            String targetQuery;
            if (Dispatcher.this._uri != null && !StringUtil.isEmpty((String)(targetQuery = Dispatcher.this._uri.getQuery()))) {
                return targetQuery;
            }
            return this._httpServletRequest.getQueryString();
        }

        public String getRequestURI() {
            return Dispatcher.this._uri == null ? null : Dispatcher.this._uri.getPath();
        }

        public StringBuffer getRequestURL() {
            return Dispatcher.this._uri == null ? null : new StringBuffer(Dispatcher.this._uri.asString());
        }

        public Object getAttribute(String name) {
            switch (name) {
                case "jakarta.servlet.async.request_uri": {
                    return this._httpServletRequest.getRequestURI();
                }
                case "jakarta.servlet.async.context_path": {
                    return this._httpServletRequest.getContextPath();
                }
                case "jakarta.servlet.async.mapping": {
                    return this._httpServletRequest.getHttpServletMapping();
                }
                case "jakarta.servlet.async.path_info": {
                    return this._httpServletRequest.getPathInfo();
                }
                case "jakarta.servlet.async.servlet_path": {
                    return this._httpServletRequest.getServletPath();
                }
                case "jakarta.servlet.async.query_string": {
                    return this._httpServletRequest.getQueryString();
                }
            }
            return super.getAttribute(name);
        }

        public Enumeration<String> getAttributeNames() {
            ArrayList names = new ArrayList(Collections.list(super.getAttributeNames()));
            names.add("jakarta.servlet.forward.request_uri");
            names.add("jakarta.servlet.forward.servlet_path");
            names.add("jakarta.servlet.forward.path_info");
            names.add("jakarta.servlet.forward.context_path");
            names.add("jakarta.servlet.forward.mapping");
            names.add("jakarta.servlet.forward.query_string");
            return Collections.enumeration(names);
        }
    }

    public class ParameterRequestWrapper
    extends HttpServletRequestWrapper {
        private final MultiMap<String> _params;
        private boolean decodedParams;
        private final ServletContextRequest _request;

        public ParameterRequestWrapper(HttpServletRequest request) {
            String targetQuery;
            super(request);
            this._params = new MultiMap();
            this.decodedParams = false;
            String string = targetQuery = Dispatcher.this._uri == null ? null : Dispatcher.this._uri.getQuery();
            if (targetQuery != null) {
                UrlEncoded.decodeTo((String)targetQuery, this._params, (Charset)UrlEncoded.ENCODING);
            }
            this._request = ServletContextRequest.getServletContextRequest((ServletRequest)request);
            Fields queryParams = this._request.getServletApiRequest().getQueryParams();
            for (Fields.Field field : queryParams) {
                this._params.addValues(field.getName(), field.getValues());
            }
        }

        private MultiMap<String> getParams() {
            if (this.decodedParams) {
                return this._params;
            }
            this.decodedParams = true;
            Fields contentParams = this._request.getServletApiRequest().getContentParams();
            for (Fields.Field field : contentParams) {
                this._params.addValues(field.getName(), field.getValues());
            }
            return this._params;
        }

        public String getParameter(String name) {
            return (String)this.getParams().getValue(name);
        }

        public Map<String, String[]> getParameterMap() {
            return Collections.unmodifiableMap(this.getParams().toStringArrayMap());
        }

        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this.getParams().keySet());
        }

        public String[] getParameterValues(String name) {
            List vals = this.getParams().getValues(name);
            if (vals == null) {
                return null;
            }
            return vals.toArray(new String[0]);
        }
    }
}

