/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.EventListener;
import java.util.Locale;
import org.eclipse.jetty.ee10.servlet.AsyncContextEvent;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletContextRequest;
import org.eclipse.jetty.ee10.servlet.ServletContextResponse;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="Debug Listener")
public class DebugListener
extends AbstractLifeCycle
implements ServletContextListener {
    private static final Logger LOG = LoggerFactory.getLogger(DebugListener.class);
    private static final DateCache __date = new DateCache("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
    private final String _attr = String.format("__R%s@%x", ((Object)((Object)this)).getClass().getSimpleName(), System.identityHashCode((Object)this));
    private final PrintStream _out;
    private boolean _renameThread;
    private boolean _showHeaders;
    private boolean _dumpContext;
    final AsyncListener _asyncListener = new AsyncListener(){

        public void onTimeout(AsyncEvent event) throws IOException {
            String cname = DebugListener.this.findContextName(((AsyncContextEvent)event).getServletContext());
            String rname = DebugListener.this.findRequestName(event.getAsyncContext().getRequest());
            DebugListener.this.log("!  ctx=%s r=%s onTimeout %s", cname, rname, ((AsyncContextEvent)event).getServletRequestState());
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            String cname = DebugListener.this.findContextName(((AsyncContextEvent)event).getServletContext());
            String rname = DebugListener.this.findRequestName(event.getAsyncContext().getRequest());
            DebugListener.this.log("!  ctx=%s r=%s onStartAsync %s", cname, rname, ((AsyncContextEvent)event).getServletRequestState());
        }

        public void onError(AsyncEvent event) throws IOException {
            String cname = DebugListener.this.findContextName(((AsyncContextEvent)event).getServletContext());
            String rname = DebugListener.this.findRequestName(event.getAsyncContext().getRequest());
            DebugListener.this.log("!! ctx=%s r=%s onError %s %s", cname, rname, event.getThrowable(), ((AsyncContextEvent)event).getServletRequestState());
        }

        public void onComplete(AsyncEvent event) throws IOException {
            AsyncContextEvent ace = (AsyncContextEvent)event;
            String cname = DebugListener.this.findContextName(ace.getServletContext());
            String rname = DebugListener.this.findRequestName(ace.getAsyncContext().getRequest());
            ServletContextRequest request = ServletContextRequest.getServletContextRequest(ace.getAsyncContext().getRequest());
            ServletContextResponse response = request.getResponse();
            String headers = DebugListener.this._showHeaders ? "\n" + response.getHeaders().toString() : "";
            DebugListener.this.log("!  ctx=%s r=%s onComplete %s %d%s", cname, rname, ace.getServletRequestState(), response.getStatus(), headers);
        }
    };
    final ServletRequestListener _servletRequestListener = new ServletRequestListener(){

        public void requestInitialized(ServletRequestEvent sre) {
            String cname = DebugListener.this.findContextName(sre.getServletContext());
            HttpServletRequest r = (HttpServletRequest)sre.getServletRequest();
            String rname = DebugListener.this.findRequestName((ServletRequest)r);
            DispatcherType d = r.getDispatcherType();
            if (d == DispatcherType.REQUEST) {
                ServletContextRequest request = ServletContextRequest.getServletContextRequest((ServletRequest)r);
                String headers = DebugListener.this._showHeaders ? "\n" + request.getHeaders().toString() : "";
                StringBuffer url = r.getRequestURL();
                if (r.getQueryString() != null) {
                    url.append('?').append(r.getQueryString());
                }
                DebugListener.this.log(">> %s ctx=%s r=%s %s %s %s %s %s%s", d, cname, rname, d, r.getMethod(), url.toString(), r.getProtocol(), request.getConnectionMetaData(), headers);
            } else {
                DebugListener.this.log(">> %s ctx=%s r=%s", d, cname, rname);
            }
        }

        public void requestDestroyed(ServletRequestEvent sre) {
            String cname = DebugListener.this.findContextName(sre.getServletContext());
            HttpServletRequest r = (HttpServletRequest)sre.getServletRequest();
            String rname = DebugListener.this.findRequestName((ServletRequest)r);
            DispatcherType d = r.getDispatcherType();
            if (sre.getServletRequest().isAsyncStarted()) {
                sre.getServletRequest().getAsyncContext().addListener(DebugListener.this._asyncListener);
                DebugListener.this.log("<< %s ctx=%s r=%s async=true", d, cname, rname);
            } else {
                ServletContextRequest request = ServletContextRequest.getServletContextRequest((ServletRequest)r);
                String headers = DebugListener.this._showHeaders ? "\n" + request.getResponse().getHeaders().toString() : "";
                DebugListener.this.log("<< %s ctx=%s r=%s async=false %d%s", d, cname, rname, request.getResponse().getStatus(), headers);
            }
        }
    };
    final ServletContextHandler.ServletContextScopeListener _contextScopeListener = new ServletContextHandler.ServletContextScopeListener(){

        @Override
        public void enterScope(ServletContextHandler.ServletScopedContext context, ServletContextRequest request) {
            String cname = DebugListener.this.findContextName(context.getServletContext());
            if (request == null) {
                DebugListener.this.log(">  ctx=%s", cname);
            } else {
                String rname = DebugListener.this.findRequestName((ServletRequest)request.getHttpServletRequest());
                if (DebugListener.this._renameThread) {
                    Thread thread = Thread.currentThread();
                    thread.setName(String.format("%s#%s", thread.getName(), rname));
                }
                DebugListener.this.log(">  ctx=%s r=%s", cname, rname);
            }
        }

        @Override
        public void exitScope(ServletContextHandler.ServletScopedContext context, ServletContextRequest request) {
            String cname = DebugListener.this.findContextName(context.getServletContext());
            if (request == null) {
                DebugListener.this.log("<  ctx=%s", cname);
            } else {
                Thread thread;
                String rname = DebugListener.this.findRequestName((ServletRequest)request.getHttpServletRequest());
                DebugListener.this.log("<  ctx=%s r=%s", cname, rname);
                if (DebugListener.this._renameThread && (thread = Thread.currentThread()).getName().endsWith(rname)) {
                    thread.setName(thread.getName().substring(0, thread.getName().length() - rname.length() - 1));
                }
            }
        }
    };

    public DebugListener() {
        this(null, false, false, false);
    }

    public DebugListener(@Name(value="renameThread") boolean renameThread, @Name(value="showHeaders") boolean showHeaders, @Name(value="dumpContext") boolean dumpContext) {
        this(null, renameThread, showHeaders, dumpContext);
    }

    public DebugListener(@Name(value="outputStream") OutputStream out, @Name(value="renameThread") boolean renameThread, @Name(value="showHeaders") boolean showHeaders, @Name(value="dumpContext") boolean dumpContext) {
        this._out = out == null ? null : new PrintStream(out);
        this._renameThread = renameThread;
        this._showHeaders = showHeaders;
        this._dumpContext = dumpContext;
    }

    @ManagedAttribute(value="Rename thread within context scope")
    public boolean isRenameThread() {
        return this._renameThread;
    }

    public void setRenameThread(boolean renameThread) {
        this._renameThread = renameThread;
    }

    @ManagedAttribute(value="Show request headers")
    public boolean isShowHeaders() {
        return this._showHeaders;
    }

    public void setShowHeaders(boolean showHeaders) {
        this._showHeaders = showHeaders;
    }

    @ManagedAttribute(value="Dump contexts at start")
    public boolean isDumpContext() {
        return this._dumpContext;
    }

    public void setDumpContext(boolean dumpContext) {
        this._dumpContext = dumpContext;
    }

    public void contextInitialized(ServletContextEvent sce) {
        sce.getServletContext().addListener((EventListener)this._servletRequestListener);
        ServletContextHandler handler = ServletContextHandler.getServletContextHandler(sce.getServletContext());
        handler.addEventListener(this._contextScopeListener);
        String cname = this.findContextName(sce.getServletContext());
        this.log("^  ctx=%s %s", cname, sce.getServletContext());
        if (this._dumpContext) {
            if (this._out == null) {
                handler.dumpStdErr();
                System.err.println("key: +- bean, += managed, +~ unmanaged, +? auto, +: iterable, +] array, +@ map, +> undefined");
            } else {
                try {
                    handler.dump(this._out);
                    this._out.println("key: +- bean, += managed, +~ unmanaged, +? auto, +: iterable, +] array, +@ map, +> undefined");
                }
                catch (Exception e) {
                    LOG.warn("Unable to dump {}", (Object)handler, (Object)e);
                }
            }
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        String cname = this.findContextName(sce.getServletContext());
        this.log("v  ctx=%s %s", cname, sce.getServletContext());
    }

    protected String findContextName(ServletContext context) {
        if (context == null) {
            return null;
        }
        String n = (String)context.getAttribute(this._attr);
        if (n == null) {
            n = String.format("%s@%x", context.getContextPath(), context.hashCode());
            context.setAttribute(this._attr, (Object)n);
        }
        return n;
    }

    protected String findRequestName(ServletRequest request) {
        if (request == null) {
            return null;
        }
        HttpServletRequest r = (HttpServletRequest)request;
        String n = (String)request.getAttribute(this._attr);
        if (n == null) {
            n = String.format("%s@%x", r.getRequestURI(), request.hashCode());
            request.setAttribute(this._attr, (Object)n);
        }
        return n;
    }

    protected void log(String format, Object ... arg) {
        if (!this.isRunning()) {
            return;
        }
        String s = String.format(format, arg);
        long now = System.currentTimeMillis();
        long ms = now % 1000L;
        if (this._out != null) {
            this._out.printf("%s.%03d:%s%n", __date.formatNow(now), ms, s);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(s);
        }
    }
}

