/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.blueprint.mock;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.gemini.blueprint.mock.DefaultBundleContextProperties;
import org.eclipse.gemini.blueprint.mock.MockBundle;
import org.eclipse.gemini.blueprint.mock.MockFilter;
import org.eclipse.gemini.blueprint.mock.MockServiceReference;
import org.eclipse.gemini.blueprint.mock.MockServiceRegistration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class MockBundleContext
implements BundleContext {
    public static final Properties DEFAULT_PROPERTIES = new DefaultBundleContextProperties();
    private Bundle bundle;
    private Properties properties;
    protected Set<ServiceListener> serviceListeners;
    protected Set<BundleListener> bundleListeners;

    public MockBundleContext() {
        this(null, null);
    }

    public MockBundleContext(Bundle bundle) {
        this(bundle, null);
    }

    public MockBundleContext(Bundle bundle, Properties props) {
        this.bundle = bundle == null ? new MockBundle(this) : bundle;
        this.properties = new Properties(DEFAULT_PROPERTIES);
        if (props != null) {
            this.properties.putAll((Map<?, ?>)props);
        }
        this.serviceListeners = new LinkedHashSet<ServiceListener>(2);
        this.bundleListeners = new LinkedHashSet<BundleListener>(2);
    }

    public void addBundleListener(BundleListener listener) {
        this.bundleListeners.add(listener);
    }

    public void addFrameworkListener(FrameworkListener listener) {
    }

    public void addServiceListener(ServiceListener listener) {
        try {
            this.addServiceListener(listener, null);
        }
        catch (InvalidSyntaxException ex) {
            throw new IllegalStateException("exception should not occur");
        }
    }

    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        if (listener == null) {
            throw new IllegalArgumentException("non-null listener required");
        }
        this.serviceListeners.add(listener);
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        return new MockFilter(filter);
    }

    public Bundle getBundle(String location) {
        return null;
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return new ServiceReference[0];
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public Bundle getBundle(long id) {
        return this.bundle;
    }

    public Bundle[] getBundles() {
        return new Bundle[]{this.bundle};
    }

    public File getDataFile(String filename) {
        return null;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public <S> S getService(ServiceReference<S> reference) {
        Class<?> type = MockBundleContext.getClass(reference.getClass().getGenericSuperclass());
        try {
            Object result = type.newInstance();
            return (S)result;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return MockBundleContext.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = MockBundleContext.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public ServiceReference getServiceReference(String clazz) {
        return new MockServiceReference(this.getBundle(), new String[]{clazz});
    }

    public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
        ServiceReference result = this.getServiceReference(clazz.getName());
        return result;
    }

    public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
        ServiceReference[] refs = this.getServiceReferences(clazz.getName(), filter);
        if (refs == null) {
            return Collections.emptyList();
        }
        ArrayList<ServiceReference<S>> result = new ArrayList<ServiceReference<S>>(refs.length);
        for (ServiceReference r : refs) {
            result.add(r);
        }
        return result;
    }

    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        if (clazz == null) {
            if (filter != null) {
                String flattenFilter = filter.toLowerCase();
                int i = flattenFilter.indexOf("objectClass".toLowerCase() + "=");
                if (i > 0) {
                    clazz = filter.substring(i + "objectClass".length() + 1);
                    clazz = clazz.substring(0, clazz.indexOf(")"));
                }
            } else {
                clazz = Object.class.getName();
            }
        }
        return new ServiceReference[]{new MockServiceReference(this.getBundle(), new String[]{clazz})};
    }

    public Bundle installBundle(String location) throws BundleException {
        MockBundle bundle = new MockBundle();
        bundle.setLocation(location);
        return bundle;
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        try {
            input.close();
        }
        catch (IOException ex) {
            throw new BundleException("cannot close stream", (Throwable)ex);
        }
        return this.installBundle(location);
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        MockServiceRegistration reg = new MockServiceRegistration(properties);
        return reg;
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        return this.registerService(new String[]{clazz}, service, properties);
    }

    public void removeBundleListener(BundleListener listener) {
        this.bundleListeners.remove(listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
    }

    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        ServiceRegistration registration = this.registerService(clazz.getName(), service, properties);
        return registration;
    }

    public void removeServiceListener(ServiceListener listener) {
        this.serviceListeners.remove(listener);
    }

    public boolean ungetService(ServiceReference reference) {
        return false;
    }

    public void setBundle(Bundle bundle) {
        this.bundle = bundle;
    }

    public Set<ServiceListener> getServiceListeners() {
        return this.serviceListeners;
    }

    public Set<BundleListener> getBundleListeners() {
        return this.bundleListeners;
    }
}

