/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl.trace;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.epsilon.common.concurrent.ConcurrencyUtils;
import org.eclipse.epsilon.evl.dom.Constraint;
import org.eclipse.epsilon.evl.trace.ConstraintTraceItem;

public class ConstraintTrace
implements Iterable<ConstraintTraceItem> {
    protected final Set<Constraint> storageOptimised;
    protected final Map<Object, Set<ConstraintTraceItem>> objectItemsMap;
    protected boolean concurrent = false;

    public ConstraintTrace() {
        this(false);
    }

    public ConstraintTrace(boolean concurrent) {
        this.concurrent = concurrent;
        this.storageOptimised = concurrent ? ConcurrencyUtils.concurrentSet() : new LinkedHashSet();
        this.objectItemsMap = concurrent ? ConcurrencyUtils.concurrentMap() : new LinkedHashMap();
    }

    public void addAll(Collection<? extends ConstraintTrace> others) {
        for (ConstraintTrace constraintTrace : others) {
            this.storageOptimised.addAll(constraintTrace.storageOptimised);
            for (ConstraintTraceItem cti : constraintTrace.getItems()) {
                this.addChecked(cti.getConstraint(), cti.getInstance(), cti.getResult());
            }
        }
    }

    public void addAll(ConstraintTrace ... others) {
        this.addAll(Arrays.asList(others));
    }

    public void addCheckedOptimised(Constraint constraint) {
        this.storageOptimised.add(constraint);
    }

    public synchronized void addChecked(Constraint constraint, Object object, boolean result) {
        ConstraintTraceItem cti = new ConstraintTraceItem(object, constraint, result);
        Set items = this.objectItemsMap.get(object);
        if (items == null) {
            items = this.concurrent ? ConcurrencyUtils.concurrentSet() : new LinkedHashSet();
            this.objectItemsMap.put(object, items);
        }
        items.add((ConstraintTraceItem)cti);
    }

    public boolean isChecked(Constraint constraint, Object instance) {
        if (this.storageOptimised.contains((Object)constraint)) {
            return true;
        }
        Set<ConstraintTraceItem> items = this.objectItemsMap.get(instance);
        if (items == null) {
            return false;
        }
        return items.stream().anyMatch(cti -> cti.equals(constraint, instance));
    }

    public boolean isSatisfied(Constraint constraint, Object instance) {
        if (this.storageOptimised.contains((Object)constraint)) {
            return true;
        }
        ConstraintTraceItem cti = new ConstraintTraceItem(instance, constraint, true);
        Set<ConstraintTraceItem> items = this.objectItemsMap.get(instance);
        if (items == null) {
            return false;
        }
        return items.stream().anyMatch(cti::equals);
    }

    public void clear() {
        if (this.storageOptimised != null) {
            this.storageOptimised.clear();
        }
        if (this.objectItemsMap != null) {
            this.objectItemsMap.clear();
        }
    }

    public Set<ConstraintTraceItem> getItems() {
        LinkedHashSet<ConstraintTraceItem> items = new LinkedHashSet<ConstraintTraceItem>();
        for (Set<ConstraintTraceItem> objectItems : this.objectItemsMap.values()) {
            items.addAll(objectItems);
        }
        return items;
    }

    public Stream<ConstraintTraceItem> stream() {
        return this.getItems().stream();
    }

    @Override
    public Iterator<ConstraintTraceItem> iterator() {
        return this.getItems().iterator();
    }

    public int hashCode() {
        return Objects.hash(this.storageOptimised, this.objectItemsMap);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConstraintTrace)) {
            return false;
        }
        ConstraintTrace ct = (ConstraintTrace)other;
        return Objects.equals(this.storageOptimised, ct.storageOptimised) && Objects.equals(this.objectItemsMap, ct.objectItemsMap);
    }
}

