/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl.parse;

import org.eclipse.epsilon.eol.dom.AnnotatableModuleElement;
import org.eclipse.epsilon.eol.dom.IEolVisitor;
import org.eclipse.epsilon.erl.parse.ErlUnparser;
import org.eclipse.epsilon.evl.EvlModule;
import org.eclipse.epsilon.evl.dom.Constraint;
import org.eclipse.epsilon.evl.dom.ConstraintContext;
import org.eclipse.epsilon.evl.dom.Fix;
import org.eclipse.epsilon.evl.dom.IEvlVisitor;

public class EvlUnparser
extends ErlUnparser
implements IEvlVisitor {
    protected void unparseRules() {
        ((EvlModule)this.module).getDeclaredConstraintContexts().forEach(c -> {
            c.accept(this);
            this.newline();
        });
    }

    @Override
    public void visit(ConstraintContext constraintContext) {
        if (constraintContext.getTypeExpression() != null) {
            this.unparseAnnotations(constraintContext);
            this.buffer.append("context ");
            constraintContext.getTypeExpression().accept((IEolVisitor)this);
            this.spaceCurlybraceNewlineIndent();
            this.print("guard", constraintContext.getGuardBlock());
            constraintContext.getConstraints().forEach(c -> {
                c.accept(this);
                this.newline();
            });
            this.newlineUnindentCurlybrace();
            this.newline();
        } else {
            constraintContext.getConstraints().forEach(c -> {
                c.accept(this);
                this.newline();
            });
        }
    }

    @Override
    public void visit(Constraint constraint) {
        this.unparseAnnotations((AnnotatableModuleElement)constraint);
        this.indent();
        this.buffer.append(constraint.isCritique() ? "critique" : "constraint");
        this.space();
        this.buffer.append(constraint.getName());
        this.spaceCurlybraceNewlineIndent();
        this.print("guard", constraint.getGuardBlock());
        this.print("check", constraint.getCheckBlock());
        this.print("message", constraint.getMessageBlock());
        constraint.getFixes().forEach(f -> f.accept(this));
        this.newlineUnindentCurlybrace();
    }

    @Override
    public void visit(Fix fix) {
        this.newline();
        this.indent();
        this.buffer.append("fix {");
        ++this.indentation;
        this.print("guard", fix.getGuardBlock());
        this.print("title", fix.getTitleBlock());
        this.print("do", fix.getBodyBlock());
        this.newlineUnindentCurlybrace();
    }
}

