/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl.launch;

import java.util.Collection;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.launch.EolRunConfiguration;
import org.eclipse.epsilon.erl.launch.ErlRunConfiguration;
import org.eclipse.epsilon.evl.EvlModule;
import org.eclipse.epsilon.evl.IEvlModule;
import org.eclipse.epsilon.evl.concurrent.EvlModuleParallelAnnotation;
import org.eclipse.epsilon.evl.concurrent.EvlModuleParallelElements;
import org.eclipse.epsilon.evl.execute.UnsatisfiedConstraint;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;
import org.eclipse.epsilon.evl.execute.context.concurrent.EvlContextParallel;

public class EvlRunConfiguration
extends ErlRunConfiguration {
    public static Builder<? extends EvlRunConfiguration, ?> Builder() {
        return new Builder(EvlRunConfiguration.class);
    }

    public EvlRunConfiguration(ErlRunConfiguration.Builder<? extends EvlRunConfiguration, ?> builder) {
        super(builder);
    }

    public EvlRunConfiguration(Builder<? extends EvlRunConfiguration, ?> builder) {
        super(builder);
        IEvlModule module = this.getModule();
        if (module instanceof EvlModule) {
            ((EvlModule)module).setOptimizeConstraints(builder.optimizeConstraints);
        }
        module.getContext().setShortCircuit(builder.shortCircuit);
        module.getContext().setOptimizeConstraintTrace(builder.optimizeTrace);
    }

    public EvlRunConfiguration(EvlRunConfiguration other) {
        super((EolRunConfiguration)other);
        IEvlModule module = this.getModule();
        IEvlModule otherModule = other.getModule();
        if (module instanceof EvlModule && otherModule instanceof EvlModule) {
            ((EvlModule)module).setOptimizeConstraints(((EvlModule)otherModule).isOptimizeConstraints());
        }
        IEvlContext context = module.getContext();
        IEvlContext otherContext = otherModule.getContext();
        context.setShortCircuit(otherContext.isShortCircuiting());
        context.setOptimizeConstraintTrace(otherContext.isOptimizeConstraintTrace());
    }

    public IEvlModule getModule() {
        return (IEvlModule)super.getModule();
    }

    public void preExecute() throws Exception {
        super.preExecute();
    }

    public Collection<UnsatisfiedConstraint> getResult() {
        return (Collection)super.getResult();
    }

    public Collection<UnsatisfiedConstraint> execute() throws EolRuntimeException {
        return (Collection)super.execute();
    }

    public void postExecute() throws Exception {
        super.postExecute();
        if (this.showResults || this.profileExecution) {
            IEvlContext context = this.getModule().getContext();
            int numUnsatisfied = context.getUnsatisfiedConstraints().size();
            if (numUnsatisfied > 0) {
                this.writeOut(new Object[]{String.valueOf(numUnsatisfied) + " constraint" + (numUnsatisfied > 1 ? "s have" : " has") + " not been satisfied" + (this.showResults ? (char)':' : '.')});
                if (this.showResults) {
                    this.writeOut(context.getUnsatisfiedConstraintsBySize().entrySet());
                }
            } else {
                this.writeOut(new Object[]{"All constraints have been satisfied."});
            }
            this.writeOut(new Object[]{this.printMarker});
        }
    }

    public static class Builder<R extends EvlRunConfiguration, B extends Builder<R, B>>
    extends ErlRunConfiguration.Builder<R, B> {
        public boolean optimizeTrace = true;
        public boolean optimizeConstraints = false;
        public boolean shortCircuit = false;

        public B shortCircuiting() {
            return this.shortCircuiting(true);
        }

        public B shortCircuiting(boolean sc) {
            this.shortCircuit = sc;
            return (B)((Object)this);
        }

        public B optimizeConstraints() {
            return this.optimizeConstraints(true);
        }

        public B optimizeConstraints(boolean optimize) {
            this.optimizeConstraints = optimize;
            return (B)((Object)this);
        }

        public B eagerConstraintTrace() {
            return this.optimizeConstraintTrace(false);
        }

        public B optimizeConstraintTrace(boolean optimize) {
            this.optimizeTrace = optimize;
            return (B)((Object)this);
        }

        protected Builder() {
        }

        protected Builder(Class<R> runConfigClass) {
            super(runConfigClass);
        }

        protected IEvlModule createModule() {
            if (this.isSequential()) {
                return new EvlModule();
            }
            EvlContextParallel context = new EvlContextParallel(this.parallelism);
            return this.isParallel() ? new EvlModuleParallelElements(context) : new EvlModuleParallelAnnotation(context);
        }
    }
}

