/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl.execute.operations;

import java.util.List;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.operations.simple.SimpleOperation;
import org.eclipse.epsilon.eol.types.EolNoType;
import org.eclipse.epsilon.evl.IEvlModule;
import org.eclipse.epsilon.evl.dom.Constraint;
import org.eclipse.epsilon.evl.dom.GlobalConstraintContext;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;
import org.eclipse.epsilon.evl.trace.ConstraintTrace;

public class SatisfiesOperation
extends SimpleOperation {
    protected boolean all = true;

    public SatisfiesOperation(boolean all) {
        this.all = all;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public Boolean execute(Object source, List<?> parameters, IEolContext context_, ModuleElement ast) throws EolRuntimeException {
        if (source == null) {
            return false;
        }
        IEvlContext context = (IEvlContext)context_;
        IEvlModule module = context.getModule();
        ConstraintTrace constraintTrace = context.getConstraintTrace();
        assert (constraintTrace != null);
        for (Object parameter : parameters) {
            boolean valid;
            String constraintName = context.getPrettyPrinterManager().toString(parameter);
            Constraint constraint = module.getConstraint(constraintName, null, source, ast);
            if (constraint.getConstraintContext() instanceof GlobalConstraintContext) {
                source = EolNoType.Instance;
            }
            if (constraint.isDependedOn() && constraintTrace.isChecked(constraint, source)) {
                valid = constraintTrace.isSatisfied(constraint, source);
            } else {
                boolean bl = valid = constraint.appliesTo(source, context) && !constraint.check(source, context).isPresent();
                if (context.isOptimizeConstraintTrace()) {
                    constraintTrace.addChecked(constraint, source, valid);
                }
                constraint.setAsDependency();
            }
            if (this.all && !valid) {
                return false;
            }
            if (!valid) continue;
            return true;
        }
        return true;
    }
}

