/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl.execute.context.concurrent;

import java.util.Collection;
import java.util.Set;
import org.eclipse.epsilon.common.concurrent.ConcurrencyUtils;
import org.eclipse.epsilon.common.util.SizeCachingConcurrentQueue;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.erl.execute.context.concurrent.ErlContextParallel;
import org.eclipse.epsilon.evl.IEvlModule;
import org.eclipse.epsilon.evl.dom.Constraint;
import org.eclipse.epsilon.evl.execute.UnsatisfiedConstraint;
import org.eclipse.epsilon.evl.execute.context.EvlContext;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;
import org.eclipse.epsilon.evl.execute.context.concurrent.IEvlContextParallel;
import org.eclipse.epsilon.evl.trace.ConstraintTrace;

public class EvlContextParallel
extends ErlContextParallel
implements IEvlContextParallel {
    protected Collection<UnsatisfiedConstraint> unsatisfiedConstraints;
    protected ConstraintTrace constraintTrace;
    protected boolean optimizeConstraintTrace = false;
    protected boolean shortCircuiting = false;
    protected boolean terminate = false;

    public EvlContextParallel() {
        this(0);
    }

    public EvlContextParallel(int parallelism) {
        super(parallelism);
        this.unsatisfiedConstraints = new SizeCachingConcurrentQueue();
        this.constraintTrace = new ConstraintTrace(true);
    }

    protected EvlContextParallel(IEolContext other) {
        super(other);
        if (other instanceof IEvlContext) {
            IEvlContext evlContext = (IEvlContext)other;
            this.unsatisfiedConstraints = evlContext.getUnsatisfiedConstraints();
            this.optimizeConstraintTrace = evlContext.isOptimizeConstraintTrace();
            this.shortCircuiting = evlContext.isShortCircuiting();
            this.constraintTrace = evlContext.getConstraintTrace();
        }
    }

    protected IEvlContext createShadowThreadLocalContext() {
        return new EvlContext(this);
    }

    public IEvlContext getShadow() {
        return (IEvlContext)super.getShadow();
    }

    @Override
    public synchronized Set<UnsatisfiedConstraint> uniqueUnsatisfiedConstraints() {
        if (!(this.unsatisfiedConstraints instanceof Set)) {
            this.unsatisfiedConstraints = ConcurrencyUtils.concurrentSet(this.unsatisfiedConstraints);
        }
        return (Set)this.unsatisfiedConstraints;
    }

    @Override
    public Collection<UnsatisfiedConstraint> getUnsatisfiedConstraints() {
        return this.unsatisfiedConstraints;
    }

    @Override
    public ConstraintTrace getConstraintTrace() {
        return this.constraintTrace;
    }

    @Override
    public void setOptimizeConstraintTrace(boolean optimize) {
        this.optimizeConstraintTrace = optimize;
    }

    @Override
    public boolean isOptimizeConstraintTrace() {
        return this.optimizeConstraintTrace;
    }

    @Override
    public boolean isShortCircuiting() {
        return this.shortCircuiting;
    }

    @Override
    public void setShortCircuit(boolean shortCircuit) {
        this.shortCircuiting = shortCircuit;
    }

    @Override
    public boolean shouldShortCircuit(Constraint constraint) throws EolRuntimeException {
        if (!this.terminate) {
            this.terminate = IEvlContextParallel.super.shouldShortCircuit(constraint);
        }
        return this.terminate;
    }

    @Override
    public IEvlModule getModule() {
        return (IEvlModule)super.getModule();
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.unsatisfiedConstraints != null) {
            this.unsatisfiedConstraints.clear();
        }
        if (this.constraintTrace != null) {
            this.constraintTrace.clear();
        }
        this.terminate = false;
    }
}

