/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl.execute.context;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.erl.execute.context.IErlContext;
import org.eclipse.epsilon.evl.IEvlModule;
import org.eclipse.epsilon.evl.dom.Constraint;
import org.eclipse.epsilon.evl.execute.UnsatisfiedConstraint;
import org.eclipse.epsilon.evl.trace.ConstraintTrace;

public interface IEvlContext
extends IErlContext {
    public static final String OPTIMIZE_CONSTRAINT_TRACE = "optimizeConstraintTrace";
    public static final String SHORT_CIRCUIT = "shortCircuit";

    public IEvlModule getModule();

    public Collection<UnsatisfiedConstraint> getUnsatisfiedConstraints();

    default public Set<UnsatisfiedConstraint> uniqueUnsatisfiedConstraints() {
        Collection<UnsatisfiedConstraint> uc = this.getUnsatisfiedConstraints();
        if (uc instanceof Set) {
            return (Set)uc;
        }
        return new LinkedHashSet<UnsatisfiedConstraint>(uc);
    }

    public ConstraintTrace getConstraintTrace();

    public boolean isOptimizeConstraintTrace();

    public void setOptimizeConstraintTrace(boolean var1);

    public boolean isShortCircuiting();

    public void setShortCircuit(boolean var1);

    default public boolean shouldShortCircuit(Constraint constraint) throws EolRuntimeException {
        if (this.isShortCircuiting() && !this.getUnsatisfiedConstraints().isEmpty()) {
            return true;
        }
        if (constraint.getBooleanAnnotationValue("terminate", (IEolContext)this)) {
            return this.getUnsatisfiedConstraints().stream().map(UnsatisfiedConstraint::getConstraint).filter(constraint::equals).findAny().isPresent();
        }
        return false;
    }

    default public boolean hasFixes() {
        return this.getUnsatisfiedConstraints().stream().map(UnsatisfiedConstraint::getFixes).anyMatch(fixes -> !fixes.isEmpty());
    }

    default public Map<Constraint, Set<Object>> sortUnsatisfiedConstraints() {
        return this.getUnsatisfiedConstraints().stream().collect(Collectors.groupingBy(UnsatisfiedConstraint::getConstraint, LinkedHashMap::new, Collectors.mapping(UnsatisfiedConstraint::getInstance, Collectors.toSet())));
    }

    default public Map<Constraint, Integer> getUnsatisfiedConstraintsBySize() {
        return this.sortUnsatisfiedConstraints().entrySet().stream().map(entry -> new AbstractMap.SimpleEntry<Constraint, Integer>((Constraint)((Object)((Object)entry.getKey())), ((Set)entry.getValue()).size())).sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
    }

    default public Set<Constraint> getConstraintsDependedOn() {
        return this.getModule().getConstraints().stream().filter(Constraint::isDependedOn).collect(Collectors.toSet());
    }
}

