/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl.execute.context;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.erl.execute.context.ErlContext;
import org.eclipse.epsilon.evl.IEvlModule;
import org.eclipse.epsilon.evl.dom.Constraint;
import org.eclipse.epsilon.evl.execute.UnsatisfiedConstraint;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;
import org.eclipse.epsilon.evl.trace.ConstraintTrace;

public class EvlContext
extends ErlContext
implements IEvlContext {
    protected Collection<UnsatisfiedConstraint> unsatisfiedConstraints;
    protected ConstraintTrace constraintTrace;
    protected boolean optimizeConstraintTrace = false;
    protected boolean shortCircuiting = false;
    protected boolean terminate = false;

    public EvlContext() {
        this.constraintTrace = new ConstraintTrace();
        this.unsatisfiedConstraints = new LinkedHashSet<UnsatisfiedConstraint>();
    }

    public EvlContext(IEvlContext other) {
        super((IEolContext)other);
        this.optimizeConstraintTrace = other.isOptimizeConstraintTrace();
        this.shortCircuiting = other.isShortCircuiting();
        this.unsatisfiedConstraints = other.getUnsatisfiedConstraints();
        this.constraintTrace = other.getConstraintTrace();
    }

    @Override
    public ConstraintTrace getConstraintTrace() {
        return this.constraintTrace;
    }

    @Override
    public Set<UnsatisfiedConstraint> uniqueUnsatisfiedConstraints() {
        if (!(this.unsatisfiedConstraints instanceof LinkedHashSet) && !(this.unsatisfiedConstraints instanceof SortedSet)) {
            this.unsatisfiedConstraints = new LinkedHashSet<UnsatisfiedConstraint>(this.unsatisfiedConstraints);
        }
        return (Set)this.unsatisfiedConstraints;
    }

    @Override
    public Collection<UnsatisfiedConstraint> getUnsatisfiedConstraints() {
        return this.unsatisfiedConstraints;
    }

    @Override
    public IEvlModule getModule() {
        return (IEvlModule)super.getModule();
    }

    @Override
    public void setOptimizeConstraintTrace(boolean optimize) {
        this.optimizeConstraintTrace = optimize;
    }

    @Override
    public boolean isOptimizeConstraintTrace() {
        return this.optimizeConstraintTrace;
    }

    @Override
    public boolean isShortCircuiting() {
        return this.shortCircuiting;
    }

    @Override
    public void setShortCircuit(boolean shortCircuit) {
        this.shortCircuiting = shortCircuit;
    }

    @Override
    public boolean shouldShortCircuit(Constraint constraint) throws EolRuntimeException {
        if (!this.terminate) {
            this.terminate = IEvlContext.super.shouldShortCircuit(constraint);
        }
        return this.terminate;
    }

    public void dispose() {
        super.dispose();
        if (this.unsatisfiedConstraints != null) {
            this.unsatisfiedConstraints.clear();
        }
        if (this.constraintTrace != null) {
            this.constraintTrace.clear();
        }
        this.terminate = false;
    }
}

