/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl.execute.atoms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.epsilon.eol.dom.IExecutableModuleElementParameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.erl.execute.RuleExecutorFactory;
import org.eclipse.epsilon.evl.IEvlModule;
import org.eclipse.epsilon.evl.dom.Constraint;
import org.eclipse.epsilon.evl.dom.ConstraintContext;
import org.eclipse.epsilon.evl.execute.UnsatisfiedConstraint;
import org.eclipse.epsilon.evl.execute.atoms.ConstraintAtom;
import org.eclipse.epsilon.evl.execute.atoms.EvlAtom;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;

public class ConstraintContextAtom
extends EvlAtom<ConstraintContext> {
    public ConstraintContextAtom(ConstraintContext constraintContext, Object modelElement, IEvlContext context) {
        super(constraintContext, modelElement, context);
    }

    public ConstraintContextAtom(ConstraintContext constraintContext, Object modelElement) {
        super(constraintContext, modelElement);
    }

    public Collection<UnsatisfiedConstraint> executeWithResults() throws EolRuntimeException {
        return this.executeWithResults(this.getContext());
    }

    public Collection<UnsatisfiedConstraint> executeWithResults(IEvlContext context) throws EolRuntimeException {
        if (((ConstraintContext)this.rule).shouldBeChecked(this.element, context)) {
            RuleExecutorFactory executorFactory = context.getExecutorFactory();
            List<Constraint> constraints = ((ConstraintContext)this.rule).getConstraints();
            ArrayList<UnsatisfiedConstraint> results = new ArrayList<UnsatisfiedConstraint>(constraints.size());
            for (Constraint constraint : constraints) {
                Object result = executorFactory.execute((IExecutableModuleElementParameter)constraint, (IEolContext)context, this.element);
                if (result instanceof Optional) {
                    ((Optional)result).ifPresent(results::add);
                    continue;
                }
                if (!(result instanceof UnsatisfiedConstraint)) continue;
                results.add((UnsatisfiedConstraint)result);
            }
            return results;
        }
        return Collections.emptyList();
    }

    public List<ConstraintAtom> toConstraintAtoms() {
        return ((ConstraintContext)this.rule).getConstraints().stream().map(c -> new ConstraintAtom((Constraint)((Object)c), this.element)).collect(Collectors.toList());
    }

    public static ArrayList<ConstraintContextAtom> getAllJobs(IEvlModule module) throws EolModelElementTypeNotFoundException, EolModelNotFoundException {
        IEvlContext context = module.getContext();
        ArrayList<ConstraintContextAtom> atoms = new ArrayList<ConstraintContextAtom>();
        for (ConstraintContext constraintContext : module.getConstraintContexts()) {
            Collection<?> allOfKind = constraintContext.getAllOfSourceKind((IEolContext)context);
            atoms.ensureCapacity(atoms.size() + allOfKind.size());
            for (Object element : allOfKind) {
                atoms.add(new ConstraintContextAtom(constraintContext, element, context));
            }
        }
        return atoms;
    }
}

