/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl.execute;

import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.FrameStack;
import org.eclipse.epsilon.eol.models.transactions.ModelRepositoryTransactionSupport;
import org.eclipse.epsilon.evl.dom.Fix;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;

public class FixInstance {
    protected Fix fix;
    protected Object self;
    protected IEvlContext context;
    protected FrameStack scope;
    protected String title;

    public FixInstance(IEvlContext context, Fix fix) {
        this.context = context;
        this.fix = fix;
        this.scope = context.getFrameStack().clone();
    }

    public IEvlContext getContext() {
        return this.context;
    }

    public Fix getFix() {
        return this.fix;
    }

    public Object getSelf() {
        return this.self;
    }

    public void setSelf(Object self) {
        this.self = self;
    }

    public String getTitle() throws EolRuntimeException {
        if (this.title == null) {
            try {
                FrameStack oldScope = this.context.getFrameStack();
                this.context.setFrameStack(this.scope);
                this.title = this.fix.getTitle(this.self, this.context);
                this.context.setFrameStack(oldScope);
            }
            catch (EolRuntimeException ex) {
                this.title = "<error>";
                throw ex;
            }
        }
        return this.title;
    }

    public void perform() throws EolRuntimeException {
        FrameStack oldScope = this.context.getFrameStack();
        this.context.setFrameStack(this.scope);
        ModelRepositoryTransactionSupport transactionSupport = this.context.getModelRepository().getTransactionSupport();
        try {
            try {
                transactionSupport.startTransaction();
                this.fix.execute(this.self, this.context);
                transactionSupport.commitTransaction();
            }
            catch (EolRuntimeException ex) {
                transactionSupport.rollbackTransaction();
                throw ex;
            }
        }
        finally {
            this.context.setFrameStack(oldScope);
        }
    }

    public String toString() {
        try {
            return this.getTitle();
        }
        catch (EolRuntimeException erx) {
            this.context.getErrorStream().println(erx.getMessage());
            return "An exception occured while evaluating the title of the fix";
        }
    }
}

