/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl.dom;

import java.util.Collection;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.dom.AndOperatorExpression;
import org.eclipse.epsilon.eol.dom.ExecutableBlock;
import org.eclipse.epsilon.eol.dom.Expression;
import org.eclipse.epsilon.eol.dom.FirstOrderOperationCallExpression;
import org.eclipse.epsilon.eol.dom.IExecutableModuleElement;
import org.eclipse.epsilon.eol.dom.NameExpression;
import org.eclipse.epsilon.eol.dom.NotOperatorExpression;
import org.eclipse.epsilon.eol.dom.OperationCallExpression;
import org.eclipse.epsilon.eol.dom.Parameter;
import org.eclipse.epsilon.eol.dom.PropertyCallExpression;
import org.eclipse.epsilon.eol.dom.ReturnStatement;
import org.eclipse.epsilon.eol.dom.StatementBlock;
import org.eclipse.epsilon.eol.dom.TypeExpression;
import org.eclipse.epsilon.evl.dom.Constraint;
import org.eclipse.epsilon.evl.dom.ConstraintContext;

public class ConstraintSelectTransfomer {
    public boolean canBeTransformed(Constraint constraint) {
        ConstraintContext constraintContext = constraint.getConstraintContext();
        return constraintContext != null && constraintContext.getTypeName() != null && ConstraintSelectTransfomer.isOptimisableExpression(constraintContext.guardBlock) && ConstraintSelectTransfomer.isOptimisableExpression(constraint.guardBlock) && ConstraintSelectTransfomer.isOptimisableExpression(constraint.checkBlock);
    }

    private static boolean isOptimisableExpression(ExecutableBlock<Boolean> block) {
        if (block == null) {
            return true;
        }
        if (ConstraintSelectTransfomer.isDependentOnOtherRules(block)) {
            return false;
        }
        IExecutableModuleElement expressionOrBlock = block.getBody();
        if (expressionOrBlock instanceof StatementBlock) {
            return ConstraintSelectTransfomer.isSimpleBlock((StatementBlock)expressionOrBlock);
        }
        return true;
    }

    private static boolean isSimpleBlock(StatementBlock block) {
        if (block.getStatements().size() != 1) {
            return false;
        }
        return block.getStatements().get(0) instanceof ReturnStatement;
    }

    private static boolean isDependentOnOtherRules(ModuleElement node) {
        String functionName;
        OperationCallExpression opCall;
        if (node instanceof OperationCallExpression && (opCall = (OperationCallExpression)node).getParameterExpressions().size() > 0 && ("satisfies".equals(functionName = opCall.getName()) || "satisfiesAll".equals(functionName) || "satisfiesOne".equals(functionName))) {
            return true;
        }
        for (ModuleElement child : node.getChildren()) {
            if (!ConstraintSelectTransfomer.isDependentOnOtherRules(child)) continue;
            return true;
        }
        return false;
    }

    public ExecutableBlock<?> transformIntoSelect(Constraint constraint) {
        assert (this.canBeTransformed(constraint)) : "The constraint is optimisable";
        Expression contextGuardExpression = ConstraintSelectTransfomer.getExpressionFromBlock(constraint.getConstraintContext().guardBlock);
        Expression constraintGuardExpression = ConstraintSelectTransfomer.getExpressionFromBlock(constraint.guardBlock);
        Expression checkExpression = ConstraintSelectTransfomer.getExpressionFromBlock(constraint.checkBlock);
        NotOperatorExpression selectExpression = new NotOperatorExpression(checkExpression);
        if (constraintGuardExpression != null) {
            selectExpression = new AndOperatorExpression(constraintGuardExpression, (Expression)selectExpression);
        }
        if (contextGuardExpression != null) {
            selectExpression = new AndOperatorExpression(contextGuardExpression, (Expression)selectExpression);
        }
        String typeName = constraint.getConstraintContext().getTypeName();
        FirstOrderOperationCallExpression optimisedExpression = new FirstOrderOperationCallExpression((Expression)new PropertyCallExpression((Expression)new TypeExpression(typeName), new NameExpression("all")), new NameExpression("select"), new Parameter(new NameExpression("self"), new TypeExpression(typeName)), (Expression)selectExpression);
        ExecutableBlock newBlock = new ExecutableBlock(Collection.class);
        newBlock.setBody((IExecutableModuleElement)optimisedExpression);
        return newBlock;
    }

    private static Expression getExpressionFromBlock(ExecutableBlock<Boolean> guardBlock) {
        if (guardBlock != null) {
            if (guardBlock.getBody() instanceof Expression) {
                return (Expression)guardBlock.getBody();
            }
            if (guardBlock.getBody() instanceof StatementBlock) {
                StatementBlock statementBlock = (StatementBlock)guardBlock.getBody();
                ReturnStatement returnStatement = (ReturnStatement)statementBlock.getStatements().get(0);
                return returnStatement.getReturnedExpression();
            }
        }
        return null;
    }
}

