/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.eol.dom.AnnotatableModuleElement;
import org.eclipse.epsilon.eol.dom.ExecutableBlock;
import org.eclipse.epsilon.eol.dom.IExecutableModuleElement;
import org.eclipse.epsilon.eol.dom.IExecutableModuleElementParameter;
import org.eclipse.epsilon.eol.dom.TypeExpression;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.eol.types.EolModelElementType;
import org.eclipse.epsilon.erl.execute.RuleExecutorFactory;
import org.eclipse.epsilon.evl.dom.Constraint;
import org.eclipse.epsilon.evl.dom.IEvlVisitor;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;

public class ConstraintContext
extends AnnotatableModuleElement
implements IExecutableModuleElement,
IExecutableModuleElementParameter {
    protected final ArrayList<Constraint> constraints = new ArrayList(0);
    protected TypeExpression typeExpression;
    protected ExecutableBlock<Boolean> guardBlock;
    protected EolModelElementType type;
    Boolean isLazy;

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        this.typeExpression = (TypeExpression)module.createAst(cst.getFirstChild(), (ModuleElement)this);
        this.guardBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)86), (ModuleElement)this);
        List constraintASTs = AstUtil.getChildren((AST)cst, (int[])new int[]{87, 88});
        this.constraints.ensureCapacity(constraintASTs.size());
        for (AST constraintAst : constraintASTs) {
            Constraint constraint = (Constraint)module.createAst(constraintAst, (ModuleElement)this);
            constraint.setConstraintContext(this);
            this.constraints.add(constraint);
        }
    }

    public boolean shouldBeChecked(Object modelElement, IEvlContext context) throws EolRuntimeException {
        return !this.isLazy(context) && this.appliesTo(modelElement, context);
    }

    public boolean isOfSourceType(Object modelElement, IEvlContext context) throws EolRuntimeException {
        return context.getModelRepository().getOwningModel(modelElement).isOfType(modelElement, this.getType((IEolContext)context).getTypeName());
    }

    public boolean isOfSourceKind(Object modelElement, IEvlContext context) throws EolRuntimeException {
        return context.getModelRepository().getOwningModel(modelElement).isOfKind(modelElement, this.getType((IEolContext)context).getTypeName());
    }

    public final boolean appliesTo(Object object, IEvlContext context) throws EolRuntimeException {
        return this.appliesTo(object, context, false);
    }

    public boolean appliesTo(Object object, IEvlContext context, boolean checkType) throws EolRuntimeException {
        if (checkType && !this.isOfSourceType(object, context)) {
            return false;
        }
        if (this.guardBlock != null) {
            return (Boolean)this.guardBlock.execute((IEolContext)context, new Variable[]{Variable.createReadOnlyVariable((String)"self", (Object)object)});
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLazy(IEvlContext context) throws EolRuntimeException {
        if (this.isLazy == null) {
            ConstraintContext constraintContext = this;
            synchronized (constraintContext) {
                if (this.isLazy != null) {
                    return this.isLazy;
                }
                boolean lazy = this.getBooleanAnnotationValue("lazy", (IEolContext)context);
                if (!lazy && !this.constraints.isEmpty()) {
                    lazy = true;
                    Iterator<Constraint> iter = this.constraints.iterator();
                    while (lazy && iter.hasNext()) {
                        lazy = iter.next().isLazy(context);
                    }
                }
                this.isLazy = lazy;
            }
        }
        return this.isLazy;
    }

    public String getTypeName() {
        return this.typeExpression != null ? this.typeExpression.getName() : null;
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public TypeExpression getTypeExpression() {
        return this.typeExpression;
    }

    public Collection<?> getAllOfSourceType(IEolContext context) throws EolModelElementTypeNotFoundException, EolModelNotFoundException {
        return this.getType(context).getAllOfType();
    }

    public Collection<?> getAllOfSourceKind(IEolContext context) throws EolModelElementTypeNotFoundException, EolModelNotFoundException {
        return this.getType(context).getAllOfKind();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EolModelElementType getType(IEolContext context) throws EolModelNotFoundException, EolModelElementTypeNotFoundException {
        if (this.type == null) {
            ConstraintContext constraintContext = this;
            synchronized (constraintContext) {
                if (this.type == null) {
                    this.type = new EolModelElementType(this.getTypeName(), context);
                }
            }
        }
        return this.type;
    }

    public boolean execute(Collection<Constraint> constraintsToCheck, Object modelElement, IEvlContext context) throws EolRuntimeException {
        if (this.shouldBeChecked(modelElement, context)) {
            RuleExecutorFactory executorFactory = context.getExecutorFactory();
            for (Constraint constraint : constraintsToCheck) {
                executorFactory.execute((IExecutableModuleElementParameter)constraint, (IEolContext)context, modelElement);
            }
            return true;
        }
        return false;
    }

    public void execute(Collection<Constraint> constraintsToCheck, IEvlContext context) throws EolRuntimeException {
        if (!this.isLazy(context)) {
            RuleExecutorFactory executorFactory = context.getExecutorFactory();
            for (Object modelElement : this.getAllOfSourceKind((IEolContext)context)) {
                if (!this.appliesTo(modelElement, context)) continue;
                for (Constraint constraint : constraintsToCheck) {
                    executorFactory.execute((IExecutableModuleElementParameter)constraint, (IEolContext)context, modelElement);
                }
            }
        }
    }

    public boolean execute(Object modelElement, IEvlContext context) throws EolRuntimeException {
        return this.execute(this.getConstraints(), modelElement, context);
    }

    public Object execute(IEolContext context_, Object self) throws EolRuntimeException {
        IEvlContext context = (IEvlContext)context_;
        return this.execute(this.getConstraints(), self, context);
    }

    public Object execute(IEolContext context) throws EolRuntimeException {
        this.execute(this.getConstraints(), (IEvlContext)context);
        return null;
    }

    public String toString() {
        return this.getTypeName();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTypeName(), this.constraints.size());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        ConstraintContext cc = (ConstraintContext)((Object)other);
        return Objects.equals(this.getTypeName(), cc.getTypeName()) && this.constraints.size() == cc.constraints.size();
    }

    public void accept(IEvlVisitor visitor) {
        visitor.visit(this);
    }

    public ExecutableBlock<Boolean> getGuardBlock() {
        return this.guardBlock;
    }

    public void setGuardBlock(ExecutableBlock<Boolean> guardBlock) {
        this.guardBlock = guardBlock;
    }
}

