/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.eol.dom.ExecutableBlock;
import org.eclipse.epsilon.eol.dom.IExecutableModuleElementParameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.erl.dom.NamedRule;
import org.eclipse.epsilon.evl.dom.ConstraintContext;
import org.eclipse.epsilon.evl.dom.Fix;
import org.eclipse.epsilon.evl.dom.IEvlVisitor;
import org.eclipse.epsilon.evl.execute.FixInstance;
import org.eclipse.epsilon.evl.execute.UnsatisfiedConstraint;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;

public class Constraint
extends NamedRule
implements IExecutableModuleElementParameter {
    protected boolean isCritique = false;
    protected List<Fix> fixes = new ArrayList<Fix>();
    protected ConstraintContext constraintContext;
    protected ExecutableBlock<Boolean> guardBlock;
    protected ExecutableBlock<Boolean> checkBlock;
    protected ExecutableBlock<String> messageBlock;
    protected boolean isDependedOn = false;

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        if (cst.getType() == 88) {
            this.isCritique = true;
        }
        this.guardBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)86), (ModuleElement)this);
        this.checkBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)91), (ModuleElement)this);
        this.messageBlock = (ExecutableBlock)module.createAst(AstUtil.getChild((AST)cst, (int)94), (ModuleElement)this);
        List fixASTs = AstUtil.getChildren((AST)cst, (int[])new int[]{90});
        this.fixes = new ArrayList<Fix>(fixASTs.size());
        for (AST fixAst : fixASTs) {
            this.fixes.add((Fix)module.createAst(fixAst, (ModuleElement)this));
        }
    }

    public boolean isInfo() {
        return this.isCritique() && this.hasAnnotation("info");
    }

    public boolean isLazy(IEvlContext context) throws EolRuntimeException {
        return this.getBooleanAnnotationValue("lazy", (IEolContext)context);
    }

    public boolean shouldBeChecked(Object modelElement, IEvlContext context) throws EolRuntimeException {
        return !context.shouldShortCircuit(this) && !this.isLazy(context) && this.appliesTo(modelElement, context);
    }

    public Optional<UnsatisfiedConstraint> execute(IEolContext context_, Object self) throws EolRuntimeException {
        IEvlContext context = (IEvlContext)context_;
        if (this.shouldBeChecked(self, context)) {
            return this.check(self, context);
        }
        return Optional.empty();
    }

    public boolean appliesTo(Object object, IEvlContext context) throws EolRuntimeException {
        if (this.guardBlock != null) {
            return (Boolean)this.guardBlock.execute((IEolContext)context, new Variable[]{Variable.createReadOnlyVariable((String)"self", (Object)object)});
        }
        return true;
    }

    public boolean optimisedCheck(Object self, IEvlContext context, boolean result) throws EolRuntimeException {
        return this.postprocessCheck(self, context, this.preprocessCheck(self, context), result);
    }

    public Optional<UnsatisfiedConstraint> check(Object self, IEvlContext context) throws EolRuntimeException {
        boolean result;
        UnsatisfiedConstraint unsatisfiedConstraint = this.preprocessCheck(self, context);
        if (this.isDependedOn && context.getConstraintTrace().isChecked(this, self)) {
            result = context.getConstraintTrace().isSatisfied(this, self);
        } else {
            result = this.executeCheckBlock(self, context);
            if (!context.isOptimizeConstraintTrace()) {
                context.getConstraintTrace().addChecked(this, self, result);
            }
        }
        result = this.postprocessCheck(self, context, unsatisfiedConstraint, result);
        return result ? Optional.empty() : Optional.of(unsatisfiedConstraint);
    }

    protected UnsatisfiedConstraint preprocessCheck(Object self, IEvlContext context) {
        UnsatisfiedConstraint unsatisfiedConstraint = new UnsatisfiedConstraint();
        context.getFrameStack().enterLocal(FrameType.UNPROTECTED, (ModuleElement)this.checkBlock.getBody(), new Variable[0]).put(new Variable[]{Variable.createReadOnlyVariable((String)"self", (Object)self), Variable.createReadOnlyVariable((String)"extras", unsatisfiedConstraint.getExtras())});
        return unsatisfiedConstraint;
    }

    protected boolean executeCheckBlock(Object self, IEvlContext context) throws EolRuntimeException {
        return (Boolean)this.checkBlock.execute((IEolContext)context, false, new Variable[0]);
    }

    protected boolean postprocessCheck(Object self, IEvlContext context, UnsatisfiedConstraint unsatisfiedConstraint, boolean result) throws EolRuntimeException {
        if (!result) {
            unsatisfiedConstraint.setInstance(self);
            unsatisfiedConstraint.setConstraint(this);
            String messageResult = this.getUnsatisfiedMessage(self, context);
            unsatisfiedConstraint.setMessage(messageResult);
            context.getUnsatisfiedConstraints().add(unsatisfiedConstraint);
            List<FixInstance> unsatisfiedConstraintFixes = unsatisfiedConstraint.getFixes();
            for (Fix fix : this.fixes) {
                if (!fix.appliesTo(self, context)) continue;
                FixInstance fixInstance = new FixInstance(context, fix);
                fixInstance.setSelf(self);
                unsatisfiedConstraintFixes.add(fixInstance);
            }
            context.shouldShortCircuit(this);
        }
        context.getFrameStack().leaveLocal((ModuleElement)this.checkBlock.getBody(), result || this.fixes.isEmpty() && this.messageBlock == null);
        return result;
    }

    public String getUnsatisfiedMessage(Object self, IEvlContext context) throws EolRuntimeException {
        return this.messageBlock != null ? (String)this.messageBlock.execute((IEolContext)context, false, new Variable[0]) : "Invariant " + this.getName() + " failed for " + context.getPrettyPrinterManager().toString(self);
    }

    public boolean guardBlockUsesSatisfies() {
        return this.guardBlock != null && this.guardBlock.getText().contains("satisfies");
    }

    public ConstraintContext getConstraintContext() {
        return this.constraintContext;
    }

    public void setConstraintContext(ConstraintContext constraintContext) {
        this.constraintContext = constraintContext;
        this.setParent((ModuleElement)this.constraintContext);
    }

    public boolean isCritique() {
        return this.isCritique;
    }

    public void setCritique(boolean isCritique) {
        this.isCritique = isCritique;
    }

    public boolean isDependedOn() {
        return this.isDependedOn;
    }

    public void setAsDependency() {
        this.isDependedOn = true;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.constraintContext, this.isCritique});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        Constraint constraint = (Constraint)((Object)other);
        return Objects.equals((Object)this.constraintContext, (Object)constraint.constraintContext) && Objects.equals(this.isCritique, constraint.isCritique);
    }

    public ExecutableBlock<Boolean> getGuardBlock() {
        return this.guardBlock;
    }

    public void setGuardBlock(ExecutableBlock<Boolean> guardBlock) {
        this.guardBlock = guardBlock;
    }

    public ExecutableBlock<Boolean> getCheckBlock() {
        return this.checkBlock;
    }

    public void setCheckBlock(ExecutableBlock<Boolean> checkBlock) {
        this.checkBlock = checkBlock;
    }

    public ExecutableBlock<String> getMessageBlock() {
        return this.messageBlock;
    }

    public void setMessageBlock(ExecutableBlock<String> messageBlock) {
        this.messageBlock = messageBlock;
    }

    public List<Fix> getFixes() {
        return this.fixes;
    }

    public void accept(IEvlVisitor visitor) {
        visitor.visit(this);
    }
}

