/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl.concurrent;

import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.eol.dom.AnnotatableModuleElement;
import org.eclipse.epsilon.eol.dom.IExecutableModuleElementParameter;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.erl.concurrent.IErlModuleParallelAnnotation;
import org.eclipse.epsilon.erl.execute.RuleExecutorFactory;
import org.eclipse.epsilon.evl.concurrent.EvlModuleParallel;
import org.eclipse.epsilon.evl.dom.Constraint;
import org.eclipse.epsilon.evl.dom.ConstraintContext;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;
import org.eclipse.epsilon.evl.execute.context.concurrent.EvlContextParallel;

public class EvlModuleParallelAnnotation
extends EvlModuleParallel
implements IErlModuleParallelAnnotation {
    public EvlModuleParallelAnnotation() {
    }

    public EvlModuleParallelAnnotation(EvlContextParallel context) {
        super(context);
    }

    @Override
    protected void checkConstraints() throws EolRuntimeException {
        EvlContextParallel pContext = (EvlContextParallel)this.getContext();
        for (ConstraintContext constraintContext : this.getConstraintContexts()) {
            Collection<Constraint> constraintsToCheck = this.preProcessConstraintContext(constraintContext);
            Collection<?> allOfKind = constraintContext.getAllOfSourceKind((IEolContext)pContext);
            LinkedList<Callable<Object>> jobs = new LinkedList<Callable<Object>>();
            if (constraintContext.hasAnnotation("parallel")) {
                for (Object object : allOfKind) {
                    if (this.shouldBeParallel(constraintContext, object)) {
                        jobs.add(() -> constraintContext.execute(constraintsToCheck, object, pContext.getShadow()));
                        continue;
                    }
                    constraintContext.execute(constraintsToCheck, object, pContext);
                }
                pContext.executeAll((ModuleElement)constraintContext, jobs);
                continue;
            }
            RuleExecutorFactory executorFactory = pContext.getExecutorFactory();
            for (Constraint constraint : constraintsToCheck) {
                for (Object object : allOfKind) {
                    if (!constraintContext.shouldBeChecked(object, pContext)) continue;
                    if (this.shouldBeParallel((AnnotatableModuleElement)constraint, object)) {
                        jobs.add(() -> {
                            IEvlContext sContext = pContext.getShadow();
                            return sContext.getExecutorFactory().execute((IExecutableModuleElementParameter)constraint, (IEolContext)sContext, object);
                        });
                        continue;
                    }
                    executorFactory.execute((IExecutableModuleElementParameter)constraint, (IEolContext)pContext, object);
                }
                pContext.executeAll((ModuleElement)constraint, jobs);
            }
        }
    }
}

