/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl;

import java.util.List;
import java.util.Set;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.erl.IErlModule;
import org.eclipse.epsilon.evl.IEvlFixer;
import org.eclipse.epsilon.evl.dom.Constraint;
import org.eclipse.epsilon.evl.dom.ConstraintContext;
import org.eclipse.epsilon.evl.dom.GlobalConstraintContext;
import org.eclipse.epsilon.evl.execute.UnsatisfiedConstraint;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;
import org.eclipse.epsilon.evl.execute.exceptions.EvlConstraintNotFoundException;

public interface IEvlModule
extends IErlModule {
    public List<Constraint> getConstraints();

    public List<ConstraintContext> getDeclaredConstraintContexts();

    public List<ConstraintContext> getConstraintContexts();

    public Set<UnsatisfiedConstraint> execute() throws EolRuntimeException;

    public void setUnsatisfiedConstraintFixer(IEvlFixer var1);

    public IEvlFixer getUnsatisfiedConstraintFixer();

    default public IEvlContext getContext() {
        return (IEvlContext)this.getContext();
    }

    default public ConstraintContext getConstraintContext(String name) {
        return this.getConstraintContexts().stream().filter(cc -> cc.getTypeName().equals(name)).findFirst().orElse(null);
    }

    default public Constraint getConstraint(String constraintName, String contextName, Object modelElement, ModuleElement ast) throws EolRuntimeException {
        IEvlContext context = this.getContext();
        for (Constraint constraint : this.getConstraints()) {
            ConstraintContext cc = constraint.getConstraintContext();
            if (!constraint.getName().equals(constraintName) || !StringUtil.isEmpty((String)contextName) && !cc.getTypeName().equals(contextName) || !(cc instanceof GlobalConstraintContext) && modelElement != null && !cc.isOfSourceKind(modelElement, context)) continue;
            return constraint;
        }
        throw new EvlConstraintNotFoundException(constraintName, ast);
    }
}

