/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.evl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.eclipse.epsilon.common.module.IModule;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.debug.EolDebugger;
import org.eclipse.epsilon.eol.dom.ExecutableBlock;
import org.eclipse.epsilon.eol.dom.Import;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.eol.execute.context.Variable;
import org.eclipse.epsilon.erl.ErlModule;
import org.eclipse.epsilon.erl.execute.context.IErlContext;
import org.eclipse.epsilon.evl.IEvlFixer;
import org.eclipse.epsilon.evl.IEvlModule;
import org.eclipse.epsilon.evl.debug.EvlDebugger;
import org.eclipse.epsilon.evl.dom.Constraint;
import org.eclipse.epsilon.evl.dom.ConstraintContext;
import org.eclipse.epsilon.evl.dom.ConstraintSelectTransfomer;
import org.eclipse.epsilon.evl.dom.Fix;
import org.eclipse.epsilon.evl.dom.GlobalConstraintContext;
import org.eclipse.epsilon.evl.execute.UnsatisfiedConstraint;
import org.eclipse.epsilon.evl.execute.context.EvlContext;
import org.eclipse.epsilon.evl.execute.context.IEvlContext;
import org.eclipse.epsilon.evl.execute.operations.EvlOperationFactory;
import org.eclipse.epsilon.evl.parse.EvlLexer;
import org.eclipse.epsilon.evl.parse.EvlParser;

public class EvlModule
extends ErlModule
implements IEvlModule {
    protected IEvlFixer fixer;
    protected List<ConstraintContext> constraintContexts;
    protected final ArrayList<ConstraintContext> declaredConstraintContexts = new ArrayList(0);
    protected final ArrayList<Constraint> constraints = new ArrayList(0);
    private boolean optimizeConstraints;
    public static final String OPTIMIZE_CONSTRAINTS = "optimizeConstraints";
    protected static final Set<String> CONFIG_PROPERTIES = new HashSet<String>(4);

    static {
        CONFIG_PROPERTIES.add(OPTIMIZE_CONSTRAINTS);
        CONFIG_PROPERTIES.add("optimizeConstraintTrace");
        CONFIG_PROPERTIES.add("shortCircuit");
    }

    public EvlModule() {
        this(null);
    }

    public EvlModule(IEvlContext context) {
        super((IErlContext)(context != null ? context : new EvlContext()));
    }

    protected Lexer createLexer(ANTLRInputStream inputStream) {
        return new EvlLexer((CharStream)inputStream);
    }

    public EpsilonParser createParser(TokenStream tokenStream) {
        return new EvlParser(tokenStream);
    }

    public String getMainRule() {
        return "evlModule";
    }

    public ModuleElement adapt(AST cst, ModuleElement parentAst) {
        switch (cst.getType()) {
            case 90: {
                return new Fix();
            }
            case 92: {
                return new ExecutableBlock(Void.class);
            }
            case 93: 
            case 94: {
                return new ExecutableBlock(String.class);
            }
            case 87: 
            case 88: {
                return new Constraint();
            }
            case 89: {
                return new ConstraintContext();
            }
            case 86: 
            case 91: {
                return new ExecutableBlock(Boolean.class);
            }
        }
        return super.adapt(cst, parentAst);
    }

    public HashMap<String, Class<? extends IModule>> getImportConfiguration() {
        HashMap importConfiguration = super.getImportConfiguration();
        importConfiguration.put("evl", EvlModule.class);
        return importConfiguration;
    }

    public void build(AST cst, IModule module) {
        super.build(cst, module);
        GlobalConstraintContext globalConstraintContext = new GlobalConstraintContext();
        globalConstraintContext.setModule((IModule)this);
        globalConstraintContext.setParent((ModuleElement)this);
        List<Constraint> globalConstraints = globalConstraintContext.getConstraints();
        List constraintASTs = AstUtil.getChildren((AST)cst, (int[])new int[]{87});
        List critiqueASTs = AstUtil.getChildren((AST)cst, (int[])new int[]{88});
        List constraintContextAsts = AstUtil.getChildren((AST)cst, (int[])new int[]{89});
        this.declaredConstraintContexts.ensureCapacity(constraintContextAsts.size() + 1);
        CollectionUtil.addCapacityIfArrayList(globalConstraints, (int)constraintASTs.size());
        for (AST constraintAst : constraintASTs) {
            Constraint constraint = (Constraint)module.createAst(constraintAst, (ModuleElement)globalConstraintContext);
            globalConstraints.add(constraint);
            constraint.setConstraintContext(globalConstraintContext);
        }
        for (AST critiqueAst : critiqueASTs) {
            Constraint critique = (Constraint)module.createAst(critiqueAst, (ModuleElement)globalConstraintContext);
            globalConstraints.add(critique);
            critique.setConstraintContext(globalConstraintContext);
        }
        for (AST constraintContextAst : constraintContextAsts) {
            this.declaredConstraintContexts.add((ConstraintContext)module.createAst(constraintContextAst, (ModuleElement)this));
        }
        if (!globalConstraints.isEmpty()) {
            this.declaredConstraintContexts.add(globalConstraintContext);
        }
        for (ConstraintContext constraintContext : this.getConstraintContexts()) {
            this.constraints.addAll(constraintContext.getConstraints());
        }
    }

    @Override
    public List<ConstraintContext> getDeclaredConstraintContexts() {
        return this.declaredConstraintContexts;
    }

    @Override
    public List<ConstraintContext> getConstraintContexts() {
        if (this.constraintContexts == null) {
            this.constraintContexts = new ArrayList<ConstraintContext>();
            for (Import import_ : this.imports) {
                if (!import_.isLoaded() || !(import_.getModule() instanceof IEvlModule)) continue;
                IEvlModule module = (IEvlModule)import_.getModule();
                this.constraintContexts.addAll(module.getConstraintContexts());
            }
            this.constraintContexts.addAll(this.declaredConstraintContexts);
        }
        return this.constraintContexts;
    }

    protected Collection<Constraint> getOptimisedConstraintsFor(ConstraintContext constraintContext) throws EolRuntimeException {
        IEvlContext context = this.getContext();
        Set<Constraint> dependedOn = context.getConstraintsDependedOn();
        ArrayList<Constraint> remainingConstraints = new ArrayList<Constraint>(constraintContext.getConstraints());
        ConstraintSelectTransfomer transformer = new ConstraintSelectTransfomer();
        Iterator itConstraint = remainingConstraints.iterator();
        while (itConstraint.hasNext()) {
            Constraint constraint = (Constraint)((Object)itConstraint.next());
            if (!transformer.canBeTransformed(constraint) || constraint.isLazy(context)) continue;
            ExecutableBlock<?> transformedConstraint = transformer.transformIntoSelect(constraint);
            Iterable results = (Iterable)transformedConstraint.execute((IEolContext)context);
            for (Object self : results) {
                constraint.optimisedCheck(self, context, false);
            }
            if (dependedOn == null || dependedOn.contains((Object)constraint)) {
                context.getConstraintTrace().addCheckedOptimised(constraint);
            }
            itConstraint.remove();
        }
        return remainingConstraints;
    }

    protected Collection<Constraint> preProcessConstraintContext(ConstraintContext constraintContext) throws EolRuntimeException {
        Collection<Constraint> constraintsToCheck;
        if (this.optimizeConstraints) {
            constraintsToCheck = this.getOptimisedConstraintsFor(constraintContext);
            for (Constraint constraint : constraintsToCheck) {
                if (constraint.getConstraintContext() == constraintContext) continue;
                throw new IllegalArgumentException("ConstraintContext '" + constraintContext.getTypeName() + "' is not applicable for Constraint '" + constraint.getName() + "'.");
            }
        } else {
            constraintsToCheck = constraintContext.getConstraints();
        }
        return constraintsToCheck;
    }

    protected void prepareContext() throws EolRuntimeException {
        IEvlContext context = this.getContext();
        super.prepareContext();
        context.setOperationFactory(new EvlOperationFactory());
        context.getFrameStack().put(new Variable[]{Variable.createReadOnlyVariable((String)"constraintTrace", (Object)context.getConstraintTrace()), Variable.createReadOnlyVariable((String)"thisModule", (Object)this)});
    }

    protected Set<UnsatisfiedConstraint> processRules() throws EolRuntimeException {
        this.checkConstraints();
        return this.getContext().uniqueUnsatisfiedConstraints();
    }

    protected void checkConstraints() throws EolRuntimeException {
        IEvlContext context = this.getContext();
        for (ConstraintContext constraintContext : this.getConstraintContexts()) {
            constraintContext.execute(this.preProcessConstraintContext(constraintContext), context);
        }
    }

    public void postExecution() throws EolRuntimeException {
        if (this.fixer != null) {
            this.fixer.fix(this);
        }
        super.postExecution();
    }

    @Override
    public Set<UnsatisfiedConstraint> execute() throws EolRuntimeException {
        return (Set)super.execute();
    }

    @Override
    public IEvlContext getContext() {
        return (IEvlContext)super.getContext();
    }

    @Override
    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    @Override
    public void setUnsatisfiedConstraintFixer(IEvlFixer fixer) {
        this.fixer = fixer;
    }

    @Override
    public IEvlFixer getUnsatisfiedConstraintFixer() {
        return this.fixer;
    }

    public boolean isOptimizeConstraints() {
        return this.optimizeConstraints;
    }

    public void setOptimizeConstraints(boolean optimizeConstraints) {
        this.optimizeConstraints = optimizeConstraints;
    }

    public void configure(Map<String, ?> properties) {
        if (properties.containsKey(OPTIMIZE_CONSTRAINTS)) {
            this.optimizeConstraints = Boolean.valueOf(Objects.toString(properties.get(OPTIMIZE_CONSTRAINTS)));
        }
        if (properties.containsKey("optimizeConstraintTrace")) {
            this.getContext().setOptimizeConstraintTrace(Boolean.valueOf(Objects.toString(properties.get(OPTIMIZE_CONSTRAINTS))));
        }
        if (properties.containsKey("shortCircuit")) {
            this.getContext().setShortCircuit(Boolean.valueOf(Objects.toString(properties.get("shortCircuit"))));
        }
    }

    public Set<String> getConfigurationProperties() {
        return CONFIG_PROPERTIES;
    }

    public EolDebugger createDebugger() {
        return new EvlDebugger();
    }
}

