/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.etl.strategy;

import java.util.Collection;
import java.util.List;
import org.eclipse.epsilon.common.util.CollectionUtil;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.erl.execute.context.IErlContext;
import org.eclipse.epsilon.etl.dom.TransformationRule;
import org.eclipse.epsilon.etl.execute.context.IEtlContext;
import org.eclipse.epsilon.etl.strategy.AbstractTransformationStrategy;

public class DefaultTransformationStrategy
extends AbstractTransformationStrategy {
    @Override
    public Collection<?> transform(Object source, IEtlContext context, List<String> rules) throws EolRuntimeException {
        List targets = CollectionUtil.createDefaultList();
        if (!this.canTransform(source)) {
            return targets;
        }
        for (TransformationRule rule : this.getRulesFor(source, context)) {
            if (rules != null && !rules.contains(rule.getName())) continue;
            Collection<?> transformed = rule.transform(source, context);
            if (!rule.isPrimary(context)) {
                targets.addAll(transformed);
                continue;
            }
            int i = 0;
            for (Object target : transformed) {
                targets.add(i++, target);
            }
        }
        return targets;
    }

    public Collection<?> getEquivalents(Object source, IErlContext context_, List<String> rules) throws EolRuntimeException {
        IEtlContext context = (IEtlContext)context_;
        return this.transform(source, context, rules);
    }

    @Override
    public void transformModels(IEtlContext context) throws EolRuntimeException {
        for (TransformationRule transformRule : this.getExecutableRules(context)) {
            transformRule.transformAll(context, this.getExcluded(), true);
        }
    }
}

